/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.AbstractBAMFileIndex;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.Chunk;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.seekablestream.SeekableStream;

class DiskBasedBAMFileIndex
extends AbstractBAMFileIndex {
    DiskBasedBAMFileIndex(File file, SAMSequenceDictionary dictionary) {
        super(file, dictionary);
    }

    DiskBasedBAMFileIndex(SeekableStream stream, SAMSequenceDictionary dictionary) {
        super(stream, dictionary);
    }

    DiskBasedBAMFileIndex(File file, SAMSequenceDictionary dictionary, boolean useMemoryMapping) {
        super(file, dictionary, useMemoryMapping);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int referenceIndex, int startPos, int endPos) {
        BAMIndexContent queryResults = this.query(referenceIndex, startPos, endPos);
        if (queryResults == null) {
            return null;
        }
        List<Chunk> chunkList = new ArrayList<Chunk>();
        for (Chunk chunk : queryResults.getAllChunks()) {
            chunkList.add(chunk.clone());
        }
        chunkList = this.optimizeChunkList(chunkList, queryResults.getLinearIndex().getMinimumOffset(startPos));
        return new BAMFileSpan(chunkList);
    }

    @Override
    protected BAMIndexContent getQueryResults(int reference) {
        throw new UnsupportedOperationException();
    }
}

