/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publication;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MavenVersionUtils;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.publish.VersionMappingStrategy;
import org.gradle.api.publish.internal.CompositePublicationArtifactSet;
import org.gradle.api.publish.internal.DefaultPublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationArtifactInternal;
import org.gradle.api.publish.internal.PublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenArtifactSet;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.internal.artifact.AbstractMavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.DefaultMavenArtifactSet;
import org.gradle.api.publish.maven.internal.artifact.DerivedMavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.SingleOutputTaskMavenArtifact;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPom;
import org.gradle.api.publish.maven.internal.publication.MavenComponentParser;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublicationCoordinates;
import org.gradle.api.publish.maven.internal.validation.MavenPublicationErrorChecker;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.GUtil;

public abstract class DefaultMavenPublication
implements MavenPublicationInternal {
    private final String name;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final TaskDependencyFactory taskDependencyFactory;
    private final String projectDisplayName;
    private final Directory buildDir;
    private final VersionMappingStrategyInternal versionMappingStrategy;
    private final MavenPomInternal pom;
    private final DefaultMavenArtifactSet mainArtifacts;
    private final PublicationArtifactSet<MavenArtifact> metadataArtifacts;
    private final PublicationArtifactSet<MavenArtifact> derivedArtifacts;
    private final PublicationArtifactSet<MavenArtifact> publishableArtifacts;
    private final SetProperty<MavenArtifact> componentArtifacts;
    private final Set<String> silencedVariants = new HashSet<String>();
    private MavenArtifact pomArtifact;
    private SingleOutputTaskMavenArtifact moduleMetadataArtifact;
    private TaskProvider<? extends Task> moduleDescriptorGenerator;
    private boolean isPublishWithOriginalFileName;
    private boolean alias;
    private boolean populated;
    private boolean artifactsOverridden;
    private boolean silenceAllPublicationWarnings;
    private boolean withBuildIdentifier;

    @Inject
    public DefaultMavenPublication(String name, DependencyMetaDataProvider dependencyMetaDataProvider, NotationParser<Object, MavenArtifact> mavenArtifactParser, ObjectFactory objectFactory, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory immutableAttributesFactory, CollectionCallbackActionDecorator collectionCallbackActionDecorator, VersionMappingStrategyInternal versionMappingStrategy, TaskDependencyFactory taskDependencyFactory, ProviderFactory providerFactory, Project project) {
        this.name = name;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.versionMappingStrategy = versionMappingStrategy;
        this.taskDependencyFactory = taskDependencyFactory;
        this.projectDisplayName = project.getDisplayName();
        this.buildDir = project.getLayout().getProjectDirectory();
        MavenComponentParser mavenComponentParser = (MavenComponentParser)objectFactory.newInstance(MavenComponentParser.class, new Object[]{mavenArtifactParser});
        this.componentArtifacts = objectFactory.setProperty(MavenArtifact.class);
        this.componentArtifacts.convention(this.getComponent().map(mavenComponentParser::parseArtifacts));
        this.componentArtifacts.finalizeValueOnRead();
        this.mainArtifacts = (DefaultMavenArtifactSet)objectFactory.newInstance(DefaultMavenArtifactSet.class, new Object[]{name, mavenArtifactParser, fileCollectionFactory, collectionCallbackActionDecorator});
        this.metadataArtifacts = new DefaultPublicationArtifactSet(MavenArtifact.class, "metadata artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.derivedArtifacts = new DefaultPublicationArtifactSet(MavenArtifact.class, "derived artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.publishableArtifacts = new CompositePublicationArtifactSet(taskDependencyFactory, MavenArtifact.class, (PublicationArtifactSet[])Cast.uncheckedCast((Object)new PublicationArtifactSet[]{this.mainArtifacts, this.metadataArtifacts, this.derivedArtifacts}));
        this.pom = (MavenPomInternal)objectFactory.newInstance(DefaultMavenPom.class, new Object[]{objectFactory});
        this.pom.getWriteGradleMetadataMarker().set(providerFactory.provider(this::writeGradleMetadataMarker));
        this.pom.getPackagingProperty().convention(providerFactory.provider(this::determinePackagingFromArtifacts));
        this.pom.getDependencies().set(this.getComponent().flatMap(component -> mavenComponentParser.parseDependencies((SoftwareComponentInternal)component, versionMappingStrategy, this.getCoordinates())).map(result -> {
            if (!this.silenceAllPublicationWarnings) {
                result.getWarnings().complete(this.getDisplayName() + " pom metadata", this.silencedVariants);
            }
            return result.getDependencies();
        }));
        Module module = dependencyMetaDataProvider.getModule();
        MavenPublicationCoordinates coordinates = this.pom.getCoordinates();
        coordinates.getGroupId().convention(providerFactory.provider(() -> ((Module)module).getGroup()));
        coordinates.getArtifactId().convention(providerFactory.provider(() -> ((Module)module).getName()));
        coordinates.getVersion().convention(providerFactory.provider(() -> ((Module)module).getVersion()));
    }

    public abstract Property<SoftwareComponentInternal> getComponent();

    public String getName() {
        return this.name;
    }

    public void withoutBuildIdentifier() {
        this.withBuildIdentifier = false;
    }

    public void withBuildIdentifier() {
        this.withBuildIdentifier = true;
    }

    public boolean isPublishBuildId() {
        return this.withBuildIdentifier;
    }

    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((Object)"Maven publication", (String)this.name);
    }

    public boolean isLegacy() {
        return false;
    }

    @Override
    public MavenPomInternal getPom() {
        return this.pom;
    }

    @Override
    public void setPomGenerator(TaskProvider<? extends Task> pomGenerator) {
        if (this.pomArtifact != null) {
            this.metadataArtifacts.remove((Object)this.pomArtifact);
        }
        this.pomArtifact = new SingleOutputTaskMavenArtifact(pomGenerator, "pom", null, this.taskDependencyFactory);
        this.metadataArtifacts.add((Object)this.pomArtifact);
    }

    @Override
    public void setModuleDescriptorGenerator(TaskProvider<? extends Task> descriptorGenerator) {
        this.moduleDescriptorGenerator = descriptorGenerator;
        if (this.moduleMetadataArtifact != null) {
            this.metadataArtifacts.remove((Object)this.moduleMetadataArtifact);
        }
        this.moduleMetadataArtifact = null;
        this.updateModuleDescriptorArtifact();
    }

    private void updateModuleDescriptorArtifact() {
        if (!this.canPublishModuleMetadata()) {
            return;
        }
        if (this.moduleDescriptorGenerator == null) {
            return;
        }
        this.moduleMetadataArtifact = new SingleOutputTaskMavenArtifact(this.moduleDescriptorGenerator, "module", null, this.taskDependencyFactory);
        this.metadataArtifacts.add((Object)this.moduleMetadataArtifact);
        this.moduleDescriptorGenerator = null;
    }

    @Override
    public void pom(Action<? super MavenPom> configure) {
        configure.execute((Object)this.pom);
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    @Override
    public void from(SoftwareComponent component) {
        if (this.getComponent().isPresent()) {
            throw new InvalidUserDataException(String.format("Maven publication '%s' cannot include multiple components", this.name));
        }
        this.getComponent().set((Object)((SoftwareComponentInternal)component));
        this.getComponent().finalizeValue();
        this.artifactsOverridden = false;
        this.updateModuleDescriptorArtifact();
    }

    private void populateFromComponent() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        if (!this.artifactsOverridden && this.componentArtifacts.isPresent()) {
            this.mainArtifacts.addAll((Collection)this.componentArtifacts.get());
        }
    }

    @Override
    public MavenArtifact artifact(Object source) {
        return this.mainArtifacts.artifact(source);
    }

    @Override
    public MavenArtifact artifact(Object source, Action<? super MavenArtifact> config) {
        return this.mainArtifacts.artifact(source, config);
    }

    @Override
    public MavenArtifactSet getArtifacts() {
        this.populateFromComponent();
        return this.mainArtifacts;
    }

    @Override
    public void setArtifacts(Iterable<?> sources) {
        this.artifactsOverridden = true;
        this.mainArtifacts.clear();
        for (Object source : sources) {
            this.artifact(source);
        }
    }

    @Override
    public String getGroupId() {
        return (String)this.pom.getCoordinates().getGroupId().get();
    }

    @Override
    public void setGroupId(String groupId) {
        this.pom.getCoordinates().getGroupId().set((Object)groupId);
    }

    @Override
    public String getArtifactId() {
        return (String)this.pom.getCoordinates().getArtifactId().get();
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.pom.getCoordinates().getArtifactId().set((Object)artifactId);
    }

    @Override
    public String getVersion() {
        return (String)this.pom.getCoordinates().getVersion().get();
    }

    @Override
    public void setVersion(String version) {
        this.pom.getCoordinates().getVersion().set((Object)version);
    }

    @Override
    public void versionMapping(Action<? super VersionMappingStrategy> configureAction) {
        configureAction.execute((Object)this.versionMappingStrategy);
    }

    @Override
    public void suppressPomMetadataWarningsFor(String variantName) {
        this.silencedVariants.add(variantName);
    }

    @Override
    public void suppressAllPomMetadataWarnings() {
        this.silenceAllPublicationWarnings = true;
    }

    public VersionMappingStrategyInternal getVersionMappingStrategy() {
        return this.versionMappingStrategy;
    }

    private boolean writeGradleMetadataMarker() {
        return this.canPublishModuleMetadata() && this.moduleMetadataArtifact != null && this.moduleMetadataArtifact.isEnabled();
    }

    public PublicationArtifactSet<MavenArtifact> getPublishableArtifacts() {
        this.populateFromComponent();
        return this.publishableArtifacts;
    }

    public void allPublishableArtifacts(Action<? super MavenArtifact> action) {
        this.publishableArtifacts.all(action);
    }

    public void whenPublishableArtifactRemoved(Action<? super MavenArtifact> action) {
        this.publishableArtifacts.whenObjectRemoved(action);
    }

    public MavenArtifact addDerivedArtifact(MavenArtifact originalArtifact, PublicationInternal.DerivedArtifact file) {
        DerivedMavenArtifact artifact = new DerivedMavenArtifact((AbstractMavenArtifact)originalArtifact, file, this.taskDependencyFactory);
        this.derivedArtifacts.add((Object)artifact);
        return artifact;
    }

    public void removeDerivedArtifact(MavenArtifact artifact) {
        this.derivedArtifacts.remove((Object)artifact);
    }

    @Override
    public MavenNormalizedPublication asNormalisedPublication() {
        this.populateFromComponent();
        Map<MavenArtifact, MavenArtifact> normalizedArtifacts = this.normalizedMavenArtifacts();
        return new MavenNormalizedPublication(this.name, this.pom.getCoordinates(), this.pom.getPackaging(), DefaultMavenPublication.normalizedArtifactFor(this.getPomArtifact(), normalizedArtifacts), DefaultMavenPublication.normalizedArtifactFor(this.determineMainArtifact(), normalizedArtifacts), new LinkedHashSet<MavenArtifact>(normalizedArtifacts.values()));
    }

    @Nullable
    private static MavenArtifact normalizedArtifactFor(@Nullable MavenArtifact artifact, Map<MavenArtifact, MavenArtifact> normalizedArtifacts) {
        if (artifact == null) {
            return null;
        }
        MavenArtifact normalized = normalizedArtifacts.get(artifact);
        if (normalized != null) {
            return normalized;
        }
        return DefaultMavenPublication.normalizedArtifactFor(artifact);
    }

    private Map<MavenArtifact, MavenArtifact> normalizedMavenArtifacts() {
        return this.artifactsToBePublished().stream().collect(Collectors.toMap(Function.identity(), DefaultMavenPublication::normalizedArtifactFor));
    }

    private static MavenArtifact normalizedArtifactFor(MavenArtifact artifact) {
        return new SerializableMavenArtifact(artifact);
    }

    private DomainObjectSet<MavenArtifact> artifactsToBePublished() {
        return CompositeDomainObjectSet.create(MavenArtifact.class, (DomainObjectCollection[])((DomainObjectCollection[])Cast.uncheckedCast((Object)new DomainObjectCollection[]{this.mainArtifacts, this.metadataArtifacts, this.derivedArtifacts}))).matching(element -> {
            if (!((PublicationArtifactInternal)element).shouldBePublished()) {
                return false;
            }
            if (this.moduleMetadataArtifact == element) {
                return this.moduleMetadataArtifact.isEnabled();
            }
            return true;
        });
    }

    private MavenArtifact getPomArtifact() {
        if (this.pomArtifact == null) {
            throw new IllegalStateException("pomArtifact not set for publication");
        }
        return this.pomArtifact;
    }

    private String determinePackagingFromArtifacts() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next().getExtension();
        }
        return "pom";
    }

    @Nullable
    private MavenArtifact determineMainArtifact() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.isEmpty()) {
            return null;
        }
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next();
        }
        for (MavenArtifact unclassifiedArtifact : unclassifiedArtifacts) {
            String packaging = this.pom.getPackaging();
            if (!unclassifiedArtifact.getExtension().equals(packaging)) continue;
            return unclassifiedArtifact;
        }
        return null;
    }

    private Set<MavenArtifact> getUnclassifiedArtifactsWithExtension() {
        this.populateFromComponent();
        return CollectionUtils.filter((Set)((Object)this.mainArtifacts), mavenArtifact -> DefaultMavenPublication.hasNoClassifier(mavenArtifact) && DefaultMavenPublication.hasExtension(mavenArtifact));
    }

    private static boolean hasNoClassifier(MavenArtifact element) {
        return element.getClassifier() == null || element.getClassifier().length() == 0;
    }

    private static boolean hasExtension(MavenArtifact element) {
        return element.getExtension() != null && element.getExtension().length() > 0;
    }

    public ModuleVersionIdentifier getCoordinates() {
        return DefaultModuleVersionIdentifier.newId((String)this.getGroupId(), (String)this.getArtifactId(), (String)this.getVersion());
    }

    @Nullable
    public <T> T getCoordinates(Class<T> type) {
        if (type.isAssignableFrom(ModuleVersionIdentifier.class)) {
            return type.cast(this.getCoordinates());
        }
        return null;
    }

    @Override
    public void publishWithOriginalFileName() {
        this.isPublishWithOriginalFileName = true;
    }

    private boolean canPublishModuleMetadata() {
        return this.getComponent().isPresent();
    }

    public PublicationInternal.PublishedFile getPublishedFile(PublishArtifact source) {
        this.populateFromComponent();
        if (this.getComponent().isPresent()) {
            MavenPublicationErrorChecker.checkThatArtifactIsPublishedUnmodified(this.projectDisplayName, this.buildDir.getAsFile().toPath().toAbsolutePath(), ((SoftwareComponentInternal)this.getComponent().get()).getName(), source, this.mainArtifacts);
        }
        final String publishedUrl = this.getPublishedUrl(source);
        final String publishedName = this.isPublishWithOriginalFileName ? source.getFile().getName() : publishedUrl;
        return new PublicationInternal.PublishedFile(){

            public String getName() {
                return publishedName;
            }

            public String getUri() {
                return publishedUrl;
            }
        };
    }

    @Nullable
    public ImmutableAttributes getAttributes() {
        String version = (String)this.pom.getCoordinates().getVersion().get();
        String status = MavenVersionUtils.inferStatusFromVersionNumber((String)version);
        return this.immutableAttributesFactory.of(ProjectInternal.STATUS_ATTRIBUTE, (Object)status);
    }

    private String getPublishedUrl(PublishArtifact source) {
        return this.getArtifactFileName(source.getClassifier(), source.getExtension());
    }

    private String getArtifactFileName(String classifier, String extension) {
        StringBuilder artifactPath = new StringBuilder();
        ModuleVersionIdentifier coordinates = this.getCoordinates();
        artifactPath.append(coordinates.getName());
        artifactPath.append('-');
        artifactPath.append(coordinates.getVersion());
        if (GUtil.isTrue((Object)classifier)) {
            artifactPath.append('-');
            artifactPath.append(classifier);
        }
        if (GUtil.isTrue((Object)extension)) {
            artifactPath.append('.');
            artifactPath.append(extension);
        }
        return artifactPath.toString();
    }

    private static class SerializableMavenArtifact
    implements MavenArtifact,
    PublicationArtifactInternal {
        private final File file;
        private final String extension;
        private final String classifier;
        private final boolean shouldBePublished;

        public SerializableMavenArtifact(MavenArtifact artifact) {
            PublicationArtifactInternal artifactInternal = (PublicationArtifactInternal)artifact;
            this.file = artifact.getFile();
            this.extension = artifact.getExtension();
            this.classifier = artifact.getClassifier();
            this.shouldBePublished = artifactInternal.shouldBePublished();
        }

        @Override
        public String getExtension() {
            return this.extension;
        }

        @Override
        public void setExtension(String extension) {
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        @Override
        public void setClassifier(@Nullable String classifier) {
            throw new IllegalStateException();
        }

        public File getFile() {
            return this.file;
        }

        public void builtBy(Object ... tasks) {
            throw new IllegalStateException();
        }

        public TaskDependency getBuildDependencies() {
            throw new IllegalStateException();
        }

        public boolean shouldBePublished() {
            return this.shouldBePublished;
        }
    }
}

