/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ITF8 {
    public static final int MAX_BYTES = 5;
    static final int MAX_BITS = 40;

    public static int readUnsignedITF8(InputStream inputStream) {
        try {
            int b1 = inputStream.read();
            if (b1 == -1) {
                throw new RuntimeEOFException();
            }
            if ((b1 & 0x80) == 0) {
                return b1;
            }
            if ((b1 & 0x40) == 0) {
                return (b1 & 0x7F) << 8 | inputStream.read();
            }
            if ((b1 & 0x20) == 0) {
                int b2 = inputStream.read();
                int b3 = inputStream.read();
                return (b1 & 0x3F) << 16 | b2 << 8 | b3;
            }
            if ((b1 & 0x10) == 0) {
                return (b1 & 0x1F) << 24 | inputStream.read() << 16 | inputStream.read() << 8 | inputStream.read();
            }
            return (b1 & 0xF) << 28 | inputStream.read() << 20 | inputStream.read() << 12 | inputStream.read() << 4 | 0xF & inputStream.read();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static int readUnsignedITF8(ByteBuffer buffer) {
        int b1 = 0xFF & buffer.get();
        if ((b1 & 0x80) == 0) {
            return b1;
        }
        if ((b1 & 0x40) == 0) {
            return (b1 & 0x7F) << 8 | 0xFF & buffer.get();
        }
        if ((b1 & 0x20) == 0) {
            int b2 = 0xFF & buffer.get();
            int b3 = 0xFF & buffer.get();
            return (b1 & 0x3F) << 16 | b2 << 8 | b3;
        }
        if ((b1 & 0x10) == 0) {
            return (b1 & 0x1F) << 24 | (0xFF & buffer.get()) << 16 | (0xFF & buffer.get()) << 8 | 0xFF & buffer.get();
        }
        return (b1 & 0xF) << 28 | (0xFF & buffer.get()) << 20 | (0xFF & buffer.get()) << 12 | (0xFF & buffer.get()) << 4 | 0xF & buffer.get();
    }

    public static int readUnsignedITF8(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int value = ITF8.readUnsignedITF8(buffer);
        buffer.clear();
        return value;
    }

    public static int writeUnsignedITF8(int value, OutputStream outputStream) {
        try {
            if (value >>> 7 == 0) {
                outputStream.write(value);
                return 8;
            }
            if (value >>> 14 == 0) {
                outputStream.write(value >> 8 | 0x80);
                outputStream.write(value & 0xFF);
                return 16;
            }
            if (value >>> 21 == 0) {
                outputStream.write(value >> 16 | 0xC0);
                outputStream.write(value >> 8 & 0xFF);
                outputStream.write(value & 0xFF);
                return 24;
            }
            if (value >>> 28 == 0) {
                outputStream.write(value >> 24 | 0xE0);
                outputStream.write(value >> 16 & 0xFF);
                outputStream.write(value >> 8 & 0xFF);
                outputStream.write(value & 0xFF);
                return 32;
            }
            outputStream.write(value >> 28 | 0xF0);
            outputStream.write(value >> 20 & 0xFF);
            outputStream.write(value >> 12 & 0xFF);
            outputStream.write(value >> 4 & 0xFF);
            outputStream.write(value & 0xFF);
            return 40;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static int writeUnsignedITF8(int value, ByteBuffer buffer) {
        if (value >>> 7 == 0) {
            buffer.put((byte)value);
            return 8;
        }
        if (value >>> 14 == 0) {
            buffer.put((byte)(value >> 8 | 0x80));
            buffer.put((byte)(value & 0xFF));
            return 16;
        }
        if (value >>> 21 == 0) {
            buffer.put((byte)(value >> 16 | 0xC0));
            buffer.put((byte)(value >> 8 & 0xFF));
            buffer.put((byte)(value & 0xFF));
            return 24;
        }
        if (value >>> 28 == 0) {
            buffer.put((byte)(value >> 24 | 0xE0));
            buffer.put((byte)(value >> 16 & 0xFF));
            buffer.put((byte)(value >> 8 & 0xFF));
            buffer.put((byte)(value & 0xFF));
            return 32;
        }
        buffer.put((byte)(value >> 28 | 0xF0));
        buffer.put((byte)(value >> 20 & 0xFF));
        buffer.put((byte)(value >> 12 & 0xFF));
        buffer.put((byte)(value >> 4 & 0xFF));
        buffer.put((byte)(value & 0xFF));
        return 40;
    }

    public static byte[] writeUnsignedITF8(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        ITF8.writeUnsignedITF8(value, buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        buffer.clear();
        return array;
    }
}

