/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.baseinfo;

import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.campagnelab.dl.varanalysis.protobuf.BaseInformationRecords;
import org.campagnelab.goby.baseinfo.BasenameUtils;
import org.campagnelab.goby.compression.ChunkCodec;
import org.campagnelab.goby.compression.FastBufferedMessageChunksReader;
import org.campagnelab.goby.compression.MessageChunksReader;
import org.campagnelab.goby.compression.SequenceBaseInfoCollectionHandler;
import org.campagnelab.goby.exception.GobyRuntimeException;
import org.campagnelab.goby.reads.ReadCodec;
import org.campagnelab.goby.util.FileExtensionHelper;

public class SequenceBaseInformationReader
implements Iterator<BaseInformationRecords.BaseInformation>,
Iterable<BaseInformationRecords.BaseInformation>,
Closeable {
    private MessageChunksReader reader;
    private String basename;
    private String sbiPath;
    private BaseInformationRecords.BaseInformationCollection collection;
    private final Properties properties = new Properties();
    private int recordLoadedSoFar;
    private long totalRecords;
    private ReadCodec codec;
    boolean first = true;

    public Properties getProperties() {
        return this.properties;
    }

    public SequenceBaseInformationReader(String path) throws IOException {
        this(BasenameUtils.getBasename(path, FileExtensionHelper.COMPACT_SEQUENCE_BASE_INFORMATION), FileUtils.openInputStream((File)new File(BasenameUtils.getBasename(path, FileExtensionHelper.COMPACT_SEQUENCE_BASE_INFORMATION) + ".sbi")));
    }

    public SequenceBaseInformationReader(File file) throws IOException {
        this(BasenameUtils.getBasename(file.getCanonicalPath(), FileExtensionHelper.COMPACT_SEQUENCE_BASE_INFORMATION), FileUtils.openInputStream((File)file));
    }

    @Override
    public void forEach(Consumer<? super BaseInformationRecords.BaseInformation> action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            BaseInformationRecords.BaseInformation next = this.next();
            action.accept(next);
        }
    }

    public SequenceBaseInformationReader(String basename, InputStream stream) {
        this.basename = basename;
        this.sbiPath = basename + ".sbi";
        this.reset(basename, stream);
    }

    private void reset(String basename, InputStream stream) {
        this.reader = new MessageChunksReader(stream);
        this.reader.setHandler(new SequenceBaseInfoCollectionHandler());
        this.codec = null;
        this.collection = null;
        this.refreshProperties();
    }

    private void refreshProperties() {
        try {
            FileInputStream propertiesStream = new FileInputStream(this.basename + ".sbip");
            try {
                this.properties.load(propertiesStream);
                this.totalRecords = Integer.parseInt(this.properties.getProperty("numRecords"));
            }
            finally {
                IOUtils.closeQuietly((InputStream)propertiesStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load properties for " + this.sbiPath, e);
        }
    }

    public long getRecordsLoadedSoFar() {
        return this.recordLoadedSoFar;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public SequenceBaseInformationReader(long start, long end, String path) throws IOException {
        this(start, end, new FastBufferedInputStream((InputStream)FileUtils.openInputStream((File)new File(path))), path);
        this.sbiPath = path;
        this.basename = SequenceBaseInformationReader.getBasename(path);
    }

    protected SequenceBaseInformationReader(long start, long end, FastBufferedInputStream stream, String path) throws IOException {
        this.basename = SequenceBaseInformationReader.getBasename(path);
        this.sbiPath = path;
        this.reader = new FastBufferedMessageChunksReader(start, end, stream);
        this.reader.setHandler(new SequenceBaseInfoCollectionHandler());
        this.refreshProperties();
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.reader.hasNext(this.collection, this.collection != null ? this.collection.getRecordsCount() : 0);
        byte[] compressedBytes = this.reader.getCompressedBytes();
        ChunkCodec chunkCodec = this.reader.getChunkCodec();
        try {
            if (compressedBytes != null) {
                this.collection = (BaseInformationRecords.BaseInformationCollection)chunkCodec.decode(compressedBytes);
                if (this.codec != null) {
                    this.codec.newChunk();
                }
                if (this.collection == null || this.collection.getRecordsCount() == 0) {
                    return false;
                }
            }
        }
        catch (IOException e) {
            throw new GobyRuntimeException(e);
        }
        return hasNext;
    }

    public String getSourceSbiPath() {
        return this.sbiPath;
    }

    public long getCurrentReadPosition() {
        try {
            return this.reader.position();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public final BaseInformationRecords.BaseInformation next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BaseInformationRecords.BaseInformation record = this.collection.getRecords(this.reader.incrementEntryIndex());
        ++this.recordLoadedSoFar;
        return record;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a reader.");
    }

    @Override
    public Iterator<BaseInformationRecords.BaseInformation> iterator() {
        try {
            IOUtils.closeQuietly((Closeable)this.reader);
            this.reset(this.basename, FileUtils.openInputStream((File)new File(this.sbiPath)));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to reset iterator", e);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public void resetEndOffset(long endOffset) {
        this.reader.resetEndOffset(endOffset);
    }

    public static String getBasename(String filename) {
        return BasenameUtils.getBasename(filename, FileExtensionHelper.COMPACT_SEQUENCE_BASE_INFORMATION);
    }

    public static String[] getBasenames(String ... filenames) {
        return BasenameUtils.getBasenames(FileExtensionHelper.COMPACT_SEQUENCE_BASE_INFORMATION, filenames);
    }
}

