#ifndef QUEUES_H
#define QUEUES_H

#include "libisect.h"

typedef struct Node {
	struct Node *next;
	struct Node *previous;
	struct Queue *queue;
} Node;

typedef struct Queue {
	Node *head;
	Node *tail;
	long count;
} Queue;

#define QUEUE(name, type) struct {type *head; type *tail;} name;
#define NODE(type) struct {type *next; type *previous; void *q;} node;

#define QNULL (void *) -1
#define QEQ 1
#define QGT 2
#define QLT 3
#define QGE 4
#define QLE 5
#define QNE 6
#define QAND 7
#define QNAND 8
#define QOR 9
#define QXOR 10

extern Node *  Xport InsertAfter(Node *, Node *);
extern Node *  Xport InsertBefore(Node *, Node *);
extern Node *  Xport InsertHead(Queue *, Node *);
extern Node *  Xport InsertTail(Queue *, Node *);
extern Node *  Xport RemoveHead(Queue *);
extern Node *  Xport RemoveTail(Queue *);
extern Node *  Xport RemoveNode(Node *);
extern Queue * Xport NodeFree(Queue *);
extern Queue * Xport QueueFree(Queue *);
extern Queue * Xport QueueAlloc(int);
extern Queue * Xport QueueInit(Queue *);
extern int     Xport QueueItems(Queue *);
extern Node *  Xport QueueSearch(Queue *, int, int, int, Node *);
extern Node *  Xport QueueByteCmp(Queue *, int, int, char *, int, Node *);

#endif
