/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class LineInputStream
extends InputStream {
    protected InputStream in;
    private ByteArrayOutputStream buf;
    private String encoding;
    private boolean eof;
    private final boolean blockReads;

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.in.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public String readLine() throws IOException {
        if (this.eof) {
            return null;
        }
        while (true) {
            if (this.blockReads) {
                int n = this.in.available();
                if (n == 0 || n > 1024) {
                    n = 1024;
                }
                byte[] byArray = new byte[n];
                this.in.mark(n);
                n = this.in.read(byArray, 0, n);
                if (n == -1) {
                    this.eof = true;
                    if (this.buf.size() == 0) {
                        return null;
                    }
                    return this.buf.toString(this.encoding);
                }
                int n2 = this.indexOf(byArray, n, (byte)10);
                if (n2 != -1) {
                    this.buf.write(byArray, 0, n2);
                    this.in.reset();
                    ++n2;
                    while (n2 > 0) {
                        n = this.in.read(byArray, 0, n2);
                        int n3 = n2 = n == -1 ? -1 : n2 - n;
                    }
                    String string = this.buf.toString(this.encoding);
                    this.buf.reset();
                    return string;
                }
                this.buf.write(byArray, 0, n);
                continue;
            }
            int n = this.in.read();
            switch (n) {
                case -1: {
                    this.eof = true;
                    if (this.buf.size() == 0) {
                        return null;
                    }
                }
                case 10: {
                    String string = this.buf.toString(this.encoding);
                    this.buf.reset();
                    return string;
                }
            }
            this.buf.write(n);
        }
    }

    private final int indexOf(byte[] byArray, int n, byte by) {
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == by) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public LineInputStream(InputStream inputStream) {
        this(inputStream, "US-ASCII");
    }

    public LineInputStream(InputStream inputStream, String string) {
        this.in = inputStream;
        this.buf = new ByteArrayOutputStream();
        this.encoding = string;
        this.eof = false;
        boolean bl = false;
        if (!(inputStream instanceof BufferedInputStream) && inputStream.markSupported()) {
            bl = true;
        }
        this.blockReads = bl;
    }
}

