/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.lang;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.kaffe.lang.ResourceReader;

public class ClassPathReader
implements ResourceReader {
    public static boolean debug;
    private Vector pathcomps;
    private Vector pathcompsStr;
    private boolean cache;
    private Hashtable classcache;

    void log(String string) {
        if (debug) {
            System.out.println("<ClassPathReader>: " + string);
        }
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        int n = 0;
        while (n < this.pathcomps.size()) {
            block8: {
                Object object;
                Object object2 = this.pathcomps.elementAt(n);
                if (object2 instanceof String) {
                    try {
                        object = ((String)object2).concat("/").concat(string);
                        this.log("opening " + (String)object);
                        inputStream = new FileInputStream((String)object);
                    }
                    catch (IOException iOException) {
                        break block8;
                    }
                }
                if (object2 instanceof ZipFile) {
                    try {
                        object = (ZipFile)object2;
                        ZipEntry zipEntry = ((ZipFile)object).getEntry(string);
                        this.log("entry for " + string + " is " + zipEntry);
                        if (zipEntry == null) {
                            throw new Exception(string + " not found in zip file");
                        }
                        inputStream = ((ZipFile)object).getInputStream(zipEntry);
                    }
                    catch (Exception exception) {
                        break block8;
                    }
                }
                return inputStream;
            }
            ++n;
        }
        return null;
    }

    public byte[] getByteCode(String string) throws Exception {
        byte[] byArray = null;
        if (this.cache) {
            byArray = (byte[])this.classcache.get(string);
        }
        if (byArray != null) {
            return byArray;
        }
        String string2 = string.replace('.', '/').concat(".class");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getResourceAsStream(string2));
        if (bufferedInputStream == null) {
            throw new Exception("Couldn't resolve class `" + string + "'\n in CLASSPATH " + this);
        }
        byArray = new byte[bufferedInputStream.available()];
        int n = bufferedInputStream.read(byArray);
        if (n != byArray.length) {
            throw new Exception("Short read for " + string + " read " + n + ", expected " + byArray.length);
        }
        if (this.cache) {
            this.classcache.put(string2, byArray);
        }
        return byArray;
    }

    public String toString() {
        return this.pathcompsStr.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        ClassPathReader classPathReader = new ClassPathReader(true, System.getProperty("java.class.path"));
        System.out.println(classPathReader.getByteCode("java.lang.Object"));
        System.out.println(classPathReader.getByteCode("java.io.File"));
        System.out.println(classPathReader.getByteCode("kaffe.lang.ClassPathReader"));
        System.out.println(classPathReader.getByteCode("lalala"));
    }

    public ClassPathReader(boolean bl, String string) {
        int n;
        this.cache = bl;
        if (bl) {
            this.classcache = new Hashtable();
        }
        this.pathcomps = new Vector(5, 2);
        this.pathcompsStr = new Vector(5, 2);
        Vector vector = new Vector(5, 2);
        String string2 = string;
        while ((n = string2.indexOf(File.pathSeparatorChar)) != -1) {
            if (n == 0) {
                vector.addElement(".");
            } else {
                vector.addElement(string2.substring(0, n));
            }
            string2 = string2.substring(n + 1);
        }
        vector.addElement(string2);
        n = 0;
        while (n < vector.size()) {
            string2 = (String)vector.elementAt(n);
            File file = new File(string2);
            if ((string2.endsWith(".jar") || string2.endsWith(".zip")) && file.isFile()) {
                try {
                    ZipFile zipFile = new ZipFile(string2);
                    this.pathcomps.addElement(zipFile);
                    this.pathcompsStr.addElement(string2);
                }
                catch (Exception exception) {}
            } else if (file.isDirectory()) {
                this.pathcomps.addElement(string2);
                this.pathcompsStr.addElement(string2);
            }
            ++n;
        }
        this.log("pathcompsStr = " + this.pathcompsStr);
        this.log("pathcomps = " + this.pathcomps);
        this.log("cache = " + bl);
    }
}

