/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.animation;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.animation.Animation;
import uk.ac.ic.doc.scenebeans.animation.WindowTransform;
import uk.ac.ic.doc.scenebeans.bounds.DirtyBounds;

public class AnimationCanvas
extends Canvas {
    private Animation _animation = null;
    private WindowTransform _root = new WindowTransform();
    private RenderingHints _hints = null;
    private Image _backbuffer;
    private Thread _runner;
    private long _frame_delay = 25L;
    private double _time_warp = 1.0;
    private boolean _pause = false;
    private boolean _paused = false;
    private boolean _is_timing_adaptive = false;
    private boolean _is_update_pending = false;

    public AnimationCanvas() {
        this.enableEvents(1L);
        this._runner = new Thread(){

            public void run() {
                AnimationCanvas.this.animateAnimation();
            }
        };
        this._runner.start();
    }

    public Animation getAnimation() {
        return this._animation;
    }

    public synchronized void setAnimation(Animation animation) {
        this._animation = animation;
        this._root.setTransformedGraph(animation);
        this.invalidate();
        this.repaint();
        this.notifyAll();
    }

    public SceneGraph getSceneGraph() {
        return this._root;
    }

    public synchronized long getFrameDelay() {
        return this._frame_delay;
    }

    public synchronized void setFrameDelay(long l) {
        this._frame_delay = l;
    }

    public synchronized double getTimeWarp() {
        return this._time_warp;
    }

    public synchronized void setTimeWarp(double d) {
        this._time_warp = d;
    }

    public boolean isTimingAdaptive() {
        return this._is_timing_adaptive;
    }

    public void setTimingAdaptive(boolean bl) {
        this._is_timing_adaptive = bl;
    }

    public RenderingHints getRenderingHints() {
        return this._hints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this._hints = renderingHints;
        this.repaint();
    }

    public boolean isPaused() {
        return this._paused;
    }

    public synchronized void setPaused(boolean bl) {
        this._pause = bl;
        this._paused = false;
        if (!bl) {
            this.notifyAll();
        }
    }

    public synchronized void waitPaused() throws InterruptedException {
        this.setPaused(true);
        while (!this.isPaused()) {
            this.wait();
        }
    }

    public boolean isAnimationCentered() {
        return this._root.isCentered();
    }

    public synchronized void setAnimationCentered(boolean bl) {
        this._root.setCentered(bl);
        if (this._paused) {
            this.paintBackbuffer();
            this.repaint();
        }
    }

    public boolean isAnimationStretched() {
        return this._root.isStretched();
    }

    public synchronized void setAnimationStretched(boolean bl) {
        this._root.setStretched(bl);
        if (this._paused) {
            this.paintBackbuffer();
            this.repaint();
        }
    }

    public boolean isAnimationAspectFixed() {
        return this._root.isAspectFixed();
    }

    public synchronized void setAnimationAspectFixed(boolean bl) {
        this._root.setAspectFixed(bl);
        if (this._paused) {
            this.paintBackbuffer();
            this.repaint();
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this._animation == null) {
            return new Dimension(256, 256);
        }
        return new Dimension((int)Math.ceil(this._animation.getWidth()), (int)Math.ceil(this._animation.getHeight()));
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public synchronized void stop() {
        if (this._runner != null) {
            Thread thread = this._runner;
            this._runner = null;
            thread.interrupt();
        }
    }

    protected void finalize() throws Throwable {
        this._runner.interrupt();
        super.finalize();
    }

    void animateAnimation() {
        long l = System.currentTimeMillis();
        try {
            while (true) {
                AnimationCanvas animationCanvas = this;
                synchronized (animationCanvas) {
                    while (this._animation == null) {
                        this.wait();
                    }
                    while (this._pause) {
                        this._paused = true;
                        this.notifyAll();
                        this.wait();
                        l = System.currentTimeMillis();
                    }
                    long l2 = System.currentTimeMillis();
                    double d = this.isTimingAdaptive() ? this._time_warp * (double)(l2 - l) / 1000.0 : this._time_warp * (double)this._frame_delay / 1000.0;
                    this._animation.performActivity(d);
                    this.paintAnimationFrame();
                    l = l2;
                }
                Thread.sleep(this._frame_delay);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void discardBackbuffer() {
        if (this._backbuffer != null) {
            this._backbuffer.flush();
            this._backbuffer = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Rectangle2D paintBackbuffer() {
        Rectangle2D rectangle2D;
        Graphics graphics = null;
        try {
            Rectangle2D rectangle2D2 = null;
            if (this._backbuffer == null) {
                this._backbuffer = this.createImage(this.getWidth(), this.getHeight());
                graphics = (Graphics2D)this._backbuffer.getGraphics();
            } else {
                graphics = (Graphics2D)this._backbuffer.getGraphics();
                rectangle2D2 = DirtyBounds.getBounds(this._root, (Graphics2D)graphics);
                if (rectangle2D2 != null) {
                    ((Graphics2D)graphics).clip(rectangle2D2);
                } else {
                    Rectangle2D rectangle2D3 = null;
                    Object var5_5 = null;
                    if (graphics == null) return rectangle2D3;
                    graphics.dispose();
                    return rectangle2D3;
                }
            }
            if (this._hints != null) {
                ((Graphics2D)graphics).setRenderingHints(this._hints);
            }
            graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
            this._root.draw((Graphics2D)graphics);
            rectangle2D = rectangle2D2;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (graphics == null) throw throwable;
            graphics.dispose();
            throw throwable;
        }
        Object var5_6 = null;
        if (graphics == null) return rectangle2D;
        graphics.dispose();
        return rectangle2D;
    }

    private void paintFrontbuffer(Graphics2D graphics2D) {
        graphics2D.drawImage(this._backbuffer, 0, 0, null);
    }

    public synchronized void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (this._backbuffer == null) {
            this.paintBackbuffer();
        }
        this.paintFrontbuffer((Graphics2D)graphics);
    }

    private synchronized void paintAnimationFrame() {
        if (!this.isShowing()) {
            return;
        }
        this._is_update_pending = false;
        Rectangle2D rectangle2D = this.paintBackbuffer();
        if (rectangle2D != null) {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            try {
                graphics2D.setClip(rectangle2D);
                this.paintFrontbuffer(graphics2D);
                Object var4_3 = null;
                graphics2D.dispose();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                graphics2D.dispose();
                throw throwable;
            }
        }
    }

    protected synchronized void processComponentEvent(ComponentEvent componentEvent) {
        if (componentEvent.getID() == 101 || componentEvent.getID() == 102) {
            this._root.setWindowSize(componentEvent.getComponent().getWidth(), componentEvent.getComponent().getHeight());
        }
        if (componentEvent.getID() == 101) {
            this.discardBackbuffer();
        }
        super.processComponentEvent(componentEvent);
    }
}

