/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractSelectableChannel
extends SelectableChannel {
    private boolean blocking;
    private Object LOCK;
    private SelectorProvider provider;
    private LinkedList keys;

    public final Object blockingLock() {
        return this.LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SelectableChannel configureBlocking(boolean blocking) throws IOException {
        Object object = this.blockingLock();
        synchronized (object) {
            if (this.blocking != blocking) {
                this.implConfigureBlocking(blocking);
                this.blocking = blocking;
            }
            return this;
        }
    }

    protected final void implCloseChannel() throws IOException {
        this.implCloseSelectableChannel();
    }

    protected abstract void implCloseSelectableChannel() throws IOException;

    protected abstract void implConfigureBlocking(boolean var1) throws IOException;

    public final boolean isBlocking() {
        return this.blocking;
    }

    public final boolean isRegistered() {
        return this.keys.isEmpty() ^ true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SelectionKey keyFor(Selector selector) {
        if (!this.isOpen()) {
            return null;
        }
        try {
            Object object = this.blockingLock();
            synchronized (object) {
                return this.locate(selector);
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public final SelectorProvider provider() {
        return this.provider;
    }

    private final SelectionKey locate(Selector selector) {
        ListIterator it = this.keys.listIterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            if (key.selector() != selector) continue;
            return key;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SelectionKey register(Selector selin, int ops, Object att) throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((ops & ~this.validOps()) != 0) {
            throw new IllegalArgumentException();
        }
        SelectionKey key = null;
        AbstractSelector selector = (AbstractSelector)selin;
        Object object = this.blockingLock();
        synchronized (object) {
            if (this.blocking) {
                throw new IllegalBlockingModeException();
            }
            key = this.locate(selector);
            if (key != null && key.isValid()) {
                if (att != null) {
                    key.attach(att);
                }
            } else {
                key = selector.register(this, ops, att);
                if (key != null) {
                    this.addSelectionKey(key);
                }
            }
            return key;
        }
    }

    void addSelectionKey(SelectionKey key) {
        this.keys.add(key);
    }

    void removeSelectionKey(SelectionKey key) {
        this.keys.remove(key);
    }

    private final /* synthetic */ void this() {
        this.blocking = true;
        this.LOCK = new Object();
        this.keys = new LinkedList();
    }

    protected AbstractSelectableChannel(SelectorProvider provider) {
        this.this();
        this.provider = provider;
    }
}

