/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class LinkedHashMap
extends HashMap {
    private static final long serialVersionUID = 3801124242820219131L;
    transient LinkedHashEntry root;
    final boolean accessOrder;

    public void clear() {
        super.clear();
        this.root = null;
    }

    public boolean containsValue(Object value) {
        LinkedHashEntry e = this.root;
        while (e != null) {
            if (LinkedHashMap.equals(value, e.value)) {
                return true;
            }
            e = e.succ;
        }
        return false;
    }

    public Object get(Object key) {
        int idx = this.hash(key);
        HashMap.HashEntry e = this.buckets[idx];
        while (e != null) {
            if (LinkedHashMap.equals(key, e.key)) {
                e.access();
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return false;
    }

    void addEntry(Object key, Object value, int idx, boolean callRemove) {
        LinkedHashEntry e = new LinkedHashEntry(key, value);
        e.next = this.buckets[idx];
        this.buckets[idx] = e;
        if (callRemove && this.removeEldestEntry(this.root)) {
            this.remove(this.root.key);
        }
    }

    void putAllInternal(Map m) {
        this.root = null;
        super.putAllInternal(m);
    }

    Iterator iterator(final int type) {
        return new Iterator(){
            LinkedHashEntry current;
            LinkedHashEntry last;
            int knownMod;

            public final boolean hasNext() {
                if (this.knownMod != LinkedHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                boolean bl = false;
                if (this.current != null) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                if (this.knownMod != LinkedHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.current;
                this.current = this.current.succ;
                return type == 1 ? this.last.value : (type == 0 ? this.last.key : this.last);
            }

            public final void remove() {
                if (this.knownMod != LinkedHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                LinkedHashMap.this.remove(this.last.key);
                this.last = null;
                ++this.knownMod;
            }

            private final /* synthetic */ void this() {
                this.current = LinkedHashMap.this.root;
                this.knownMod = LinkedHashMap.this.modCount;
            }
            {
                this.this();
            }
        };
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map m) {
        super(m);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LinkedHashEntry
    extends HashMap.HashEntry {
        LinkedHashEntry pred;
        LinkedHashEntry succ;

        void access() {
            if (LinkedHashMap.this.accessOrder && this.succ != null) {
                ++LinkedHashMap.this.modCount;
                if (this == LinkedHashMap.this.root) {
                    LinkedHashMap.this.root = this.succ;
                    this.pred.succ = this;
                    this.succ = null;
                } else {
                    this.pred.succ = this.succ;
                    this.succ.pred = this.pred;
                    this.succ = null;
                    this.pred = LinkedHashMap.this.root.pred;
                    this.pred.succ = this;
                    LinkedHashMap.this.root.pred = this;
                }
            }
        }

        Object cleanup() {
            if (this == LinkedHashMap.this.root) {
                LinkedHashMap.this.root = this.succ;
                if (this.succ != null) {
                    this.succ.pred = this.pred;
                }
            } else if (this.succ == null) {
                this.pred.succ = null;
                LinkedHashMap.this.root.pred = this.pred;
            } else {
                this.pred.succ = this.succ;
                this.succ.pred = this.pred;
            }
            return this.value;
        }

        LinkedHashEntry(Object key, Object value) {
            super(key, value);
            if (LinkedHashMap.this.root == null) {
                LinkedHashMap.this.root = this;
                this.pred = this;
            } else {
                this.pred = LinkedHashMap.this.root.pred;
                this.pred.succ = this;
                LinkedHashMap.this.root.pred = this;
            }
        }
    }
}

