/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultBoundedRangeModel
implements BoundedRangeModel,
Serializable {
    private static final long serialVersionUID = 5034068491295259790L;
    protected transient ChangeEvent changeEvent;
    protected EventListenerList listenerList;
    private int value;
    private int extent;
    private int minimum;
    private int maximum;
    private boolean isAdjusting;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public String toString() {
        return this.getClass().getName() + "[value=" + this.value + ", extent=" + this.extent + ", min=" + this.minimum + ", max=" + this.maximum + ", adj=" + this.isAdjusting + ']';
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if ((value = Math.max(this.minimum, value)) + this.extent > this.maximum) {
            value = this.maximum - this.extent;
        }
        if (value != this.value) {
            this.value = value;
            this.fireStateChanged();
        }
    }

    public int getExtent() {
        return this.extent;
    }

    public void setExtent(int extent) {
        if (this.value + (extent = Math.max(extent, 0)) > this.maximum) {
            extent = this.maximum - this.value;
        }
        if (extent != this.extent) {
            this.extent = extent;
            this.fireStateChanged();
        }
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        int maximum = Math.max(minimum, this.maximum);
        int value = Math.max(minimum, this.value);
        this.setRangeProperties(value, this.extent, minimum, maximum, this.isAdjusting);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        int minimum = Math.min(this.minimum, maximum);
        int extent = Math.min(this.extent, maximum - minimum);
        int value = Math.min(this.value, maximum - extent);
        this.setRangeProperties(value, extent, minimum, maximum, this.isAdjusting);
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void setValueIsAdjusting(boolean isAdjusting) {
        if (isAdjusting == this.isAdjusting) {
            return;
        }
        this.isAdjusting = isAdjusting;
        this.fireStateChanged();
    }

    public void setRangeProperties(int value, int extent, int minimum, int maximum, boolean isAdjusting) {
        minimum = Math.min(Math.min(minimum, maximum), value);
        if (extent + value > (maximum = Math.max(value, maximum))) {
            extent = maximum - value;
        }
        extent = Math.max(0, extent);
        if (value == this.value && extent == this.extent && minimum == this.minimum && maximum == this.maximum && isAdjusting == this.isAdjusting) {
            return;
        }
        this.value = value;
        this.extent = extent;
        this.minimum = minimum;
        this.maximum = maximum;
        this.isAdjusting = isAdjusting;
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = DefaultBoundedRangeModel.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = DefaultBoundedRangeModel.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        int i = listeners.length - 1;
        while (i >= 0) {
            listeners[i].stateChanged(this.changeEvent);
            --i;
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = DefaultBoundedRangeModel.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.getListeners(clazz);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.listenerList = new EventListenerList();
    }

    public DefaultBoundedRangeModel() {
        this.this();
        this.maximum = 100;
    }

    public DefaultBoundedRangeModel(int value, int extent, int minimum, int maximum) {
        this.this();
        if (minimum > value || extent < 0 || value + extent > maximum) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        this.extent = extent;
        this.minimum = minimum;
        this.maximum = maximum;
    }
}

