/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  Data structures and functions specific to the event module
****/

#include "ubs.h"

// data structures

/*+ This structure defines the basis of how events are stored in the allevents array +*/
struct event
{
 char name[STRBUF]; /*+ The name of the event.  Right now, this is a reference to PREFIX/bin/NAME, where NAME is what would go here +*/
 char logfile[FILEBUF]; /*+ File to log to +*/
 int mins; /*+ The time which the event takes place, in terms of minutes in an hour (0-59) +*/
 int hrs; /*+ The time event occurs, in hours.  If this is -1, (undefined), the event should occur every hour +*/
};

// global variables

struct event *ALLEVENTS; /*+ All known events which were parsed in the configuration file +*/

ubs_table EVENT;

// functions

// read_events.c
int read_events(char *config_fname);
// run_event.c
int run_event(int event_num);
