/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.charts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScatterPlotData {
    String title;
    private String[] sampleNames;
    private Map<String, double[]> dataMap;
    private Map<String, String[]> symbolValueMap;
    private int[] mutationCount;
    private int sampleCount;
    private ArrayList<String> dataTypes;
    private ArrayList<String> symbolNames;

    public ScatterPlotData(String title, String[] sampleNames, Map<String, String[]> symbolMap, Map<String, double[]> dataMap, int[] mutationCount) {
        this.title = title;
        this.sampleNames = sampleNames;
        this.sampleCount = sampleNames.length;
        this.symbolValueMap = symbolMap;
        this.symbolNames = new ArrayList<String>(this.symbolValueMap.keySet());
        this.dataMap = dataMap;
        this.dataTypes = new ArrayList<String>(this.dataMap.keySet());
        this.mutationCount = mutationCount;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public String[] getSampleNames() {
        return this.sampleNames;
    }

    public List<String> getCategories() {
        return this.symbolNames;
    }

    public int getDataMapSize() {
        return this.dataMap.size();
    }

    public ArrayList<String> getDataNames() {
        return this.dataTypes;
    }

    public String getDataKeyName(int index) {
        return this.dataTypes.get(index);
    }

    public int getDataKeyIndex(String keyName) {
        int labelIndex = -1;
        int nLabels = this.dataTypes.size();
        for (int index = 0; index < nLabels; ++index) {
            if (!this.dataTypes.get(index).equals(keyName)) continue;
            labelIndex = index;
            break;
        }
        return labelIndex;
    }

    public double getDataKeyValue(String keyName, int sampleIndex) {
        return this.dataMap.get(keyName)[sampleIndex];
    }

    public double[] getDataValues(String name) {
        return this.dataMap.get(name);
    }

    public int getSymbolMapSize() {
        return this.symbolValueMap.size();
    }

    public ArrayList<String> getSymbolNames() {
        return this.symbolNames;
    }

    public String getSymbolKeyName(int index) {
        return this.symbolNames.get(index);
    }

    public int getSymbolKeyIndex(String name) {
        int symbolIndex = -1;
        int nSymbols = this.symbolNames.size();
        for (int index = 0; index < nSymbols; ++index) {
            if (!this.symbolNames.get(index).equals(name)) continue;
            symbolIndex = index;
            break;
        }
        return symbolIndex;
    }

    public String getSymbolKeyValue(String keyName, int sampleIndex) {
        return this.symbolValueMap.get(keyName)[sampleIndex];
    }

    public String[] getSymbolValues(String keyName) {
        return this.symbolValueMap.get(keyName);
    }

    public String[] getAttributeCategories(String attribute) {
        String[] symbolValues = this.getSymbolValues(attribute);
        ArrayList<String> uniqueVals = new ArrayList<String>();
        uniqueVals.add("");
        for (String x : symbolValues) {
            if (x == null || uniqueVals.contains(x)) continue;
            uniqueVals.add(x);
        }
        int nCategories = uniqueVals.size();
        String[] categories = new String[nCategories];
        uniqueVals.toArray(categories);
        return categories;
    }

    public String getSampleDescription(int sampleIndex, boolean isHTML) {
        String keyName;
        int index;
        String description = "<html>" + this.sampleNames[sampleIndex] + ": <br>";
        int keyCount = this.getDataMapSize();
        for (index = 0; index < keyCount; ++index) {
            keyName = this.getDataKeyName(index);
            Double Value = this.getDataKeyValue(keyName, sampleIndex);
            description = description + keyName + " = " + Value.toString() + "<br>";
        }
        keyCount = this.getSymbolMapSize();
        if (isHTML) {
            for (index = 0; index < keyCount; ++index) {
                keyName = this.getSymbolKeyName(index);
                String Sample = this.getSymbolKeyValue(keyName, sampleIndex);
                description = description + keyName + " = " + Sample + "<br>";
            }
            description = description + "</html>";
        } else {
            for (index = 0; index < keyCount; ++index) {
                keyName = this.getSymbolKeyName(index);
                String Sample = this.getSymbolKeyValue(keyName, sampleIndex);
                description = index < keyCount - 1 ? description + keyName + " = " + Sample + ", " : description + keyName + " = " + Sample;
            }
        }
        return description;
    }

    public int[] getMutationCount() {
        return this.mutationCount;
    }
}

