/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.tabix;

import htsjdk.tribble.TribbleException;

public class TabixFormat
implements Cloneable {
    public static final int ZERO_BASED = 65536;
    public static final int GENERIC_FLAGS = 0;
    public static final int SAM_FLAGS = 1;
    public static final int VCF_FLAGS = 2;
    public static final int UCSC_FLAGS = 65536;
    public static final TabixFormat GFF = new TabixFormat(0, 1, 4, 5, '#', 0);
    public static final TabixFormat BED = new TabixFormat(65536, 1, 2, 3, '#', 0);
    public static final TabixFormat PSLTBL = new TabixFormat(65536, 15, 17, 18, '#', 0);
    public static final TabixFormat SAM = new TabixFormat(1, 3, 4, 0, '@', 0);
    public static final TabixFormat VCF = new TabixFormat(2, 1, 2, 0, '#', 0);
    public int flags;
    public int sequenceColumn;
    public int startPositionColumn;
    public int endPositionColumn;
    public char metaCharacter;
    public int numHeaderLinesToSkip;

    public TabixFormat() {
    }

    public TabixFormat(int flags, int sequenceColumn, int startPositionColumn, int endPositionColumn, char metaCharacter, int numHeaderLinesToSkip) {
        this.flags = flags;
        this.sequenceColumn = sequenceColumn;
        this.startPositionColumn = startPositionColumn;
        this.endPositionColumn = endPositionColumn;
        this.metaCharacter = metaCharacter;
        this.numHeaderLinesToSkip = numHeaderLinesToSkip;
    }

    public TabixFormat clone() {
        try {
            return (TabixFormat)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new TribbleException("unpossible!");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TabixFormat that = (TabixFormat)o;
        if (this.endPositionColumn != that.endPositionColumn) {
            return false;
        }
        if (this.flags != that.flags) {
            return false;
        }
        if (this.metaCharacter != that.metaCharacter) {
            return false;
        }
        if (this.numHeaderLinesToSkip != that.numHeaderLinesToSkip) {
            return false;
        }
        if (this.sequenceColumn != that.sequenceColumn) {
            return false;
        }
        return this.startPositionColumn == that.startPositionColumn;
    }

    public int hashCode() {
        int result = this.flags;
        result = 31 * result + this.sequenceColumn;
        result = 31 * result + this.startPositionColumn;
        result = 31 * result + this.endPositionColumn;
        result = 31 * result + this.metaCharacter;
        result = 31 * result + this.numHeaderLinesToSkip;
        return result;
    }
}

