/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Field
extends AccessibleObject
implements Member {
    private int slot;
    private String name;
    private Class declaringClass;
    private Class type;
    byte[] vmData;

    public final Class getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = Field.nativeGetDeclaringClass(this.vmData);
        }
        return this.declaringClass;
    }

    public static final native Class nativeGetDeclaringClass(byte[] var0);

    public final String getName() {
        if (this.name == null) {
            this.name = Field.nativeGetName(this.vmData);
        }
        return this.name;
    }

    public static final native String nativeGetName(byte[] var0);

    public final int getModifiers() {
        return this.nativeGetModifiers(this.vmData);
    }

    private final native int nativeGetModifiers(byte[] var1);

    public final Class getType() {
        if (this.type == null) {
            this.type = Field.nativeGetType(this.vmData);
        }
        return this.type;
    }

    public static final native Class nativeGetType(byte[] var0);

    public final boolean equals(Object o) {
        if (!(o instanceof Field)) {
            return false;
        }
        Field that = (Field)o;
        if (this.getDeclaringClass() != that.getDeclaringClass()) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getType() == that.getType();
    }

    public final int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer(64);
        Modifier.toString(this.getModifiers(), sb).append(' ');
        sb.append(this.getType().getName()).append(' ');
        sb.append(this.getDeclaringClass().getName()).append('.');
        sb.append(this.getName());
        return sb.toString();
    }

    public final Object get(Object o) throws IllegalAccessException {
        Class type = this.getType();
        if (type == Boolean.TYPE) {
            return this.getBoolean(o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (type == Byte.TYPE) {
            return new Byte(this.getByte(o));
        }
        if (type == Short.TYPE) {
            return new Short(this.getShort(o));
        }
        if (type == Character.TYPE) {
            return new Character(this.getChar(o));
        }
        if (type == Integer.TYPE) {
            return new Integer(this.getInt(o));
        }
        if (type == Long.TYPE) {
            return new Long(this.getLong(o));
        }
        if (type == Float.TYPE) {
            return new Float(this.getFloat(o));
        }
        if (type == Double.TYPE) {
            return new Double(this.getDouble(o));
        }
        this.checkField(type, o, null);
        return this.nativeGetReference(this.vmData, o);
    }

    private final native Object nativeGetReference(byte[] var1, Object var2) throws IllegalAccessException;

    private final void checkField(Object o, Class acceptType) {
        this.checkField(this.getType(), o, new Class[]{acceptType});
    }

    private final void checkField(Object o, Class[] acceptTypes) {
        this.checkField(this.getType(), o, acceptTypes);
    }

    private final void checkField(Class type, Object o, Class[] acceptTypes) {
        if (!Modifier.isStatic(this.getModifiers())) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!this.getDeclaringClass().isInstance(o)) {
                throw new IllegalArgumentException();
            }
        }
        if (acceptTypes != null) {
            boolean ok = false;
            int i = 0;
            while (i < acceptTypes.length) {
                if (type == acceptTypes[i]) {
                    ok = true;
                    break;
                }
                ++i;
            }
            if (!ok) {
                throw new IllegalArgumentException();
            }
        }
    }

    public final boolean getBoolean(Object o) throws IllegalAccessException {
        this.checkField(o, Boolean.TYPE);
        return this.nativeGetBoolean(this.vmData, o);
    }

    private final native boolean nativeGetBoolean(byte[] var1, Object var2) throws IllegalAccessException;

    public final byte getByte(Object o) throws IllegalAccessException {
        this.checkField(o, Byte.TYPE);
        return this.nativeGetByte(this.vmData, o);
    }

    private final native byte nativeGetByte(byte[] var1, Object var2) throws IllegalAccessException;

    public final char getChar(Object o) throws IllegalAccessException {
        this.checkField(o, Character.TYPE);
        return this.nativeGetChar(this.vmData, o);
    }

    private final native char nativeGetChar(byte[] var1, Object var2) throws IllegalAccessException;

    public final short getShort(Object o) throws IllegalAccessException {
        this.checkField(o, new Class[]{Byte.TYPE, Short.TYPE});
        return this.nativeGetShort(this.vmData, o);
    }

    private final native short nativeGetShort(byte[] var1, Object var2) throws IllegalAccessException;

    public final int getInt(Object o) throws IllegalAccessException {
        this.checkField(o, new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE});
        return this.nativeGetInt(this.vmData, o);
    }

    private final native int nativeGetInt(byte[] var1, Object var2) throws IllegalAccessException;

    public final long getLong(Object o) throws IllegalAccessException {
        this.checkField(o, new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE});
        return this.nativeGetLong(this.vmData, o);
    }

    private final native long nativeGetLong(byte[] var1, Object var2) throws IllegalAccessException;

    public final float getFloat(Object o) throws IllegalAccessException {
        this.checkField(o, new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE});
        return this.nativeGetFloat(this.vmData, o);
    }

    public final native float nativeGetFloat(byte[] var1, Object var2) throws IllegalAccessException;

    public final double getDouble(Object o) throws IllegalAccessException {
        this.checkField(o, new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        return this.nativeGetDouble(this.vmData, o);
    }

    private final native double nativeGetDouble(byte[] var1, Object var2) throws IllegalAccessException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void set(Object o, Object value) throws IllegalAccessException {
        Class type = this.getType();
        if (type.isPrimitive()) {
            if (value instanceof Boolean) {
                this.setBoolean(o, (Boolean)value);
                return;
            } else if (value instanceof Byte) {
                this.setByte(o, (Byte)value);
                return;
            } else if (value instanceof Short) {
                this.setShort(o, (Short)value);
                return;
            } else if (value instanceof Character) {
                this.setChar(o, ((Character)value).charValue());
                return;
            } else if (value instanceof Integer) {
                this.setInt(o, (Integer)value);
                return;
            } else if (value instanceof Long) {
                this.setLong(o, (Long)value);
                return;
            } else if (value instanceof Float) {
                this.setFloat(o, ((Float)value).floatValue());
                return;
            } else {
                if (!(value instanceof Double)) throw new IllegalArgumentException();
                this.setDouble(o, (Double)value);
            }
            return;
        } else {
            this.checkField(type, o, null);
            if (!type.isInstance(value)) {
                throw new IllegalArgumentException();
            }
            this.nativeSetReference(this.vmData, o, value);
        }
    }

    private final native void nativeSetReference(byte[] var1, Object var2, Object var3) throws IllegalAccessException;

    public final void setBoolean(Object o, boolean value) throws IllegalAccessException {
        this.checkField(o, Boolean.TYPE);
        this.nativeSetBoolean(this.vmData, o, value);
    }

    private final native void nativeSetBoolean(byte[] var1, Object var2, boolean var3) throws IllegalAccessException;

    public final void setByte(Object o, byte value) throws IllegalAccessException {
        this.checkField(o, new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        this.nativeSetByte(this.vmData, o, value);
    }

    private final native void nativeSetByte(byte[] var1, Object var2, byte var3) throws IllegalAccessException;

    public final void setChar(Object o, char value) throws IllegalAccessException {
        this.checkField(o, new Class[]{Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        this.nativeSetChar(this.vmData, o, value);
    }

    private final native void nativeSetChar(byte[] var1, Object var2, char var3) throws IllegalAccessException;

    public final void setShort(Object o, short value) throws IllegalAccessException {
        this.checkField(o, new Class[]{Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        this.nativeSetShort(this.vmData, o, value);
    }

    private final native void nativeSetShort(byte[] var1, Object var2, short var3) throws IllegalAccessException;

    public final void setInt(Object o, int value) throws IllegalAccessException {
        this.checkField(o, new Class[]{Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        this.nativeSetInt(this.vmData, o, value);
    }

    private final native void nativeSetInt(byte[] var1, Object var2, int var3) throws IllegalAccessException;

    public final void setLong(Object o, long value) throws IllegalAccessException {
        this.checkField(o, new Class[]{Long.TYPE, Float.TYPE, Double.TYPE});
        this.nativeSetLong(this.vmData, o, value);
    }

    private final native void nativeSetLong(byte[] var1, Object var2, long var3) throws IllegalAccessException;

    public final void setFloat(Object o, float value) throws IllegalAccessException {
        this.checkField(o, new Class[]{Float.TYPE, Long.TYPE});
        this.nativeSetFloat(this.vmData, o, value);
    }

    private final native void nativeSetFloat(byte[] var1, Object var2, float var3) throws IllegalAccessException;

    public final void setDouble(Object o, double value) throws IllegalAccessException {
        this.checkField(o, Double.TYPE);
        this.nativeSetDouble(this.vmData, o, value);
    }

    private final native void nativeSetDouble(byte[] var1, Object var2, double var3) throws IllegalAccessException;

    private Field(byte[] vmData) {
        this.vmData = vmData;
    }

    private Field(Class declaringClass, String name, int slot) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.slot = slot;
    }
}

