require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&EVENT2_UTIL_H_INCLUDED_)) {
    eval 'sub EVENT2_UTIL_H_INCLUDED_ () {1;}' unless defined(&EVENT2_UTIL_H_INCLUDED_);
    require 'event2/visibility.ph';
    if(defined(&__cplusplus)) {
    }
    require 'event2/event-config.ph';
    if(defined(&EVENT__HAVE_SYS_TIME_H)) {
	require 'sys/time.ph';
    }
    if(defined(&EVENT__HAVE_STDINT_H)) {
	require 'stdint.ph';
    }
 elsif(defined(&EVENT__HAVE_INTTYPES_H)) {
	require 'inttypes.ph';
    }
    if(defined(&EVENT__HAVE_SYS_TYPES_H)) {
	require 'sys/types.ph';
    }
    if(defined(&EVENT__HAVE_STDDEF_H)) {
	require 'stddef.ph';
    }
    if(defined(&_MSC_VER)) {
	require 'BaseTsd.ph';
    }
    require 'stdarg.ph';
    if(defined(&EVENT__HAVE_NETDB_H)) {
	require 'netdb.ph';
    }
    if(defined(&_WIN32)) {
	require 'winsock2.ph';
	if(defined(&EVENT__HAVE_GETADDRINFO)) {
	    require 'ws2tcpip.ph';
	}
    } else {
	if(defined(&EVENT__HAVE_ERRNO_H)) {
	    require 'errno.ph';
	}
	require 'sys/socket.ph';
    }
    require 'time.ph';
    if(defined(&EVENT__SIZEOF_VOID__)  && !defined(&EVENT__SIZEOF_VOID_P)) {
	eval 'sub EVENT__SIZEOF_VOID_P () { &EVENT__SIZEOF_VOID__;}' unless defined(&EVENT__SIZEOF_VOID_P);
    }
    if(defined(&EVENT__HAVE_UINT64_T)) {
	eval 'sub ev_uint64_t () { &uint64_t;}' unless defined(&ev_uint64_t);
	eval 'sub ev_int64_t () { &int64_t;}' unless defined(&ev_int64_t);
    }
 elsif(defined(&_WIN32)) {
	eval 'sub ev_uint64_t () {\'unsigned __int64\';}' unless defined(&ev_uint64_t);
	eval 'sub ev_int64_t () {\'signed __int64\';}' unless defined(&ev_int64_t);
    }
 elsif((defined(&EVENT__SIZEOF_LONG_LONG) ? &EVENT__SIZEOF_LONG_LONG : undef) == 8) {
	eval 'sub ev_uint64_t () {\'unsigned long long\';}' unless defined(&ev_uint64_t);
	eval 'sub ev_int64_t () {\'long long\';}' unless defined(&ev_int64_t);
    }
 elsif((defined(&EVENT__SIZEOF_LONG) ? &EVENT__SIZEOF_LONG : undef) == 8) {
	eval 'sub ev_uint64_t () {\'unsigned long\';}' unless defined(&ev_uint64_t);
	eval 'sub ev_int64_t () {\'long\';}' unless defined(&ev_int64_t);
    }
 elsif(defined(&EVENT_IN_DOXYGEN_)) {
	eval 'sub ev_uint64_t () {...;}' unless defined(&ev_uint64_t);
	eval 'sub ev_int64_t () {...;}' unless defined(&ev_int64_t);
    } else {
	die("No way to define ev_uint64_t");
    }
    if(defined(&EVENT__HAVE_UINT32_T)) {
	eval 'sub ev_uint32_t () { &uint32_t;}' unless defined(&ev_uint32_t);
	eval 'sub ev_int32_t () { &int32_t;}' unless defined(&ev_int32_t);
    }
 elsif(defined(&_WIN32)) {
	eval 'sub ev_uint32_t () {\'unsigned int\';}' unless defined(&ev_uint32_t);
	eval 'sub ev_int32_t () {\'signed int\';}' unless defined(&ev_int32_t);
    }
 elsif((defined(&EVENT__SIZEOF_LONG) ? &EVENT__SIZEOF_LONG : undef) == 4) {
	eval 'sub ev_uint32_t () {\'unsigned long\';}' unless defined(&ev_uint32_t);
	eval 'sub ev_int32_t () {\'signed long\';}' unless defined(&ev_int32_t);
    }
 elsif((defined(&EVENT__SIZEOF_INT) ? &EVENT__SIZEOF_INT : undef) == 4) {
	eval 'sub ev_uint32_t () {\'unsigned int\';}' unless defined(&ev_uint32_t);
	eval 'sub ev_int32_t () {\'signed int\';}' unless defined(&ev_int32_t);
    }
 elsif(defined(&EVENT_IN_DOXYGEN_)) {
	eval 'sub ev_uint32_t () {...;}' unless defined(&ev_uint32_t);
	eval 'sub ev_int32_t () {...;}' unless defined(&ev_int32_t);
    } else {
	die("No way to define ev_uint32_t");
    }
    if(defined(&EVENT__HAVE_UINT16_T)) {
	eval 'sub ev_uint16_t () { &uint16_t;}' unless defined(&ev_uint16_t);
	eval 'sub ev_int16_t () { &int16_t;}' unless defined(&ev_int16_t);
    }
 elsif(defined(&_WIN32)) {
	eval 'sub ev_uint16_t () {\'unsigned short\';}' unless defined(&ev_uint16_t);
	eval 'sub ev_int16_t () {\'signed short\';}' unless defined(&ev_int16_t);
    }
 elsif((defined(&EVENT__SIZEOF_INT) ? &EVENT__SIZEOF_INT : undef) == 2) {
	eval 'sub ev_uint16_t () {\'unsigned int\';}' unless defined(&ev_uint16_t);
	eval 'sub ev_int16_t () {\'signed int\';}' unless defined(&ev_int16_t);
    }
 elsif((defined(&EVENT__SIZEOF_SHORT) ? &EVENT__SIZEOF_SHORT : undef) == 2) {
	eval 'sub ev_uint16_t () {\'unsigned short\';}' unless defined(&ev_uint16_t);
	eval 'sub ev_int16_t () {\'signed short\';}' unless defined(&ev_int16_t);
    }
 elsif(defined(&EVENT_IN_DOXYGEN_)) {
	eval 'sub ev_uint16_t () {...;}' unless defined(&ev_uint16_t);
	eval 'sub ev_int16_t () {...;}' unless defined(&ev_int16_t);
    } else {
	die("No way to define ev_uint16_t");
    }
    if(defined(&EVENT__HAVE_UINT8_T)) {
	eval 'sub ev_uint8_t () { &uint8_t;}' unless defined(&ev_uint8_t);
	eval 'sub ev_int8_t () { &int8_t;}' unless defined(&ev_int8_t);
    }
 elsif(defined(&EVENT_IN_DOXYGEN_)) {
	eval 'sub ev_uint8_t () {...;}' unless defined(&ev_uint8_t);
	eval 'sub ev_int8_t () {...;}' unless defined(&ev_int8_t);
    } else {
	eval 'sub ev_uint8_t () {\'unsigned char\';}' unless defined(&ev_uint8_t);
	eval 'sub ev_int8_t () {\'signed char\';}' unless defined(&ev_int8_t);
    }
    if(defined(&EVENT__HAVE_UINTPTR_T)) {
	eval 'sub ev_uintptr_t () { &uintptr_t;}' unless defined(&ev_uintptr_t);
	eval 'sub ev_intptr_t () { &intptr_t;}' unless defined(&ev_intptr_t);
    }
 elsif((defined(&EVENT__SIZEOF_VOID_P) ? &EVENT__SIZEOF_VOID_P : undef) <= 4) {
	eval 'sub ev_uintptr_t () { &ev_uint32_t;}' unless defined(&ev_uintptr_t);
	eval 'sub ev_intptr_t () { &ev_int32_t;}' unless defined(&ev_intptr_t);
    }
 elsif((defined(&EVENT__SIZEOF_VOID_P) ? &EVENT__SIZEOF_VOID_P : undef) <= 8) {
	eval 'sub ev_uintptr_t () { &ev_uint64_t;}' unless defined(&ev_uintptr_t);
	eval 'sub ev_intptr_t () { &ev_int64_t;}' unless defined(&ev_intptr_t);
    }
 elsif(defined(&EVENT_IN_DOXYGEN_)) {
	eval 'sub ev_uintptr_t () {...;}' unless defined(&ev_uintptr_t);
	eval 'sub ev_intptr_t () {...;}' unless defined(&ev_intptr_t);
    } else {
	die("No way to define ev_uintptr_t");
    }
    if(defined(&EVENT__ssize_t)) {
	eval 'sub ev_ssize_t () { &EVENT__ssize_t;}' unless defined(&ev_ssize_t);
    } else {
	eval 'sub ev_ssize_t () { &ssize_t;}' unless defined(&ev_ssize_t);
    }
    if(defined(&_WIN32)) {
	eval 'sub ev_off_t () { &ev_int64_t;}' unless defined(&ev_off_t);
    }
 elsif((defined(&EVENT__SIZEOF_OFF_T) ? &EVENT__SIZEOF_OFF_T : undef) == 8) {
	eval 'sub ev_off_t () { &ev_int64_t;}' unless defined(&ev_off_t);
    }
 elsif((defined(&EVENT__SIZEOF_OFF_T) ? &EVENT__SIZEOF_OFF_T : undef) == 4) {
	eval 'sub ev_off_t () { &ev_int32_t;}' unless defined(&ev_off_t);
    }
 elsif(defined(&EVENT_IN_DOXYGEN_)) {
	eval 'sub ev_off_t () {...;}' unless defined(&ev_off_t);
    } else {
	eval 'sub ev_off_t () { &off_t;}' unless defined(&ev_off_t);
    }
    unless(defined(&EVENT__HAVE_STDINT_H)) {
	eval 'sub EV_UINT64_MAX () {(((( &ev_uint64_t)0xffffffff) << 32) | 0xffffffff);}' unless defined(&EV_UINT64_MAX);
	eval 'sub EV_INT64_MAX () {(((( &ev_int64_t) 0x7fffffff) << 32) | 0xffffffff);}' unless defined(&EV_INT64_MAX);
	eval 'sub EV_INT64_MIN () {((- &EV_INT64_MAX) - 1);}' unless defined(&EV_INT64_MIN);
	eval 'sub EV_UINT32_MAX () {(( &ev_uint32_t)0xffffffff);}' unless defined(&EV_UINT32_MAX);
	eval 'sub EV_INT32_MAX () {(( &ev_int32_t) 0x7fffffff);}' unless defined(&EV_INT32_MAX);
	eval 'sub EV_INT32_MIN () {((- &EV_INT32_MAX) - 1);}' unless defined(&EV_INT32_MIN);
	eval 'sub EV_UINT16_MAX () {(( &ev_uint16_t)0xffff);}' unless defined(&EV_UINT16_MAX);
	eval 'sub EV_INT16_MAX () {(( &ev_int16_t) 0x7fff);}' unless defined(&EV_INT16_MAX);
	eval 'sub EV_INT16_MIN () {((- &EV_INT16_MAX) - 1);}' unless defined(&EV_INT16_MIN);
	eval 'sub EV_UINT8_MAX () {255;}' unless defined(&EV_UINT8_MAX);
	eval 'sub EV_INT8_MAX () {127;}' unless defined(&EV_INT8_MAX);
	eval 'sub EV_INT8_MIN () {((- &EV_INT8_MAX) - 1);}' unless defined(&EV_INT8_MIN);
    } else {
	eval 'sub EV_UINT64_MAX () { &UINT64_MAX;}' unless defined(&EV_UINT64_MAX);
	eval 'sub EV_INT64_MAX () { &INT64_MAX;}' unless defined(&EV_INT64_MAX);
	eval 'sub EV_INT64_MIN () { &INT64_MIN;}' unless defined(&EV_INT64_MIN);
	eval 'sub EV_UINT32_MAX () { &UINT32_MAX;}' unless defined(&EV_UINT32_MAX);
	eval 'sub EV_INT32_MAX () { &INT32_MAX;}' unless defined(&EV_INT32_MAX);
	eval 'sub EV_INT32_MIN () { &INT32_MIN;}' unless defined(&EV_INT32_MIN);
	eval 'sub EV_UINT16_MAX () { &UINT16_MAX;}' unless defined(&EV_UINT16_MAX);
	eval 'sub EV_INT16_MIN () { &INT16_MIN;}' unless defined(&EV_INT16_MIN);
	eval 'sub EV_INT16_MAX () { &INT16_MAX;}' unless defined(&EV_INT16_MAX);
	eval 'sub EV_UINT8_MAX () { &UINT8_MAX;}' unless defined(&EV_UINT8_MAX);
	eval 'sub EV_INT8_MAX () { &INT8_MAX;}' unless defined(&EV_INT8_MAX);
	eval 'sub EV_INT8_MIN () { &INT8_MIN;}' unless defined(&EV_INT8_MIN);
    }
    if((defined(&EVENT__SIZEOF_SIZE_T) ? &EVENT__SIZEOF_SIZE_T : undef) == 8) {
	eval 'sub EV_SIZE_MAX () { &EV_UINT64_MAX;}' unless defined(&EV_SIZE_MAX);
	eval 'sub EV_SSIZE_MAX () { &EV_INT64_MAX;}' unless defined(&EV_SSIZE_MAX);
    }
 elsif((defined(&EVENT__SIZEOF_SIZE_T) ? &EVENT__SIZEOF_SIZE_T : undef) == 4) {
	eval 'sub EV_SIZE_MAX () { &EV_UINT32_MAX;}' unless defined(&EV_SIZE_MAX);
	eval 'sub EV_SSIZE_MAX () { &EV_INT32_MAX;}' unless defined(&EV_SSIZE_MAX);
    }
 elsif(defined(&EVENT_IN_DOXYGEN_)) {
	eval 'sub EV_SIZE_MAX () {...;}' unless defined(&EV_SIZE_MAX);
	eval 'sub EV_SSIZE_MAX () {...;}' unless defined(&EV_SSIZE_MAX);
    } else {
	die("No way to define SIZE_MAX");
    }
    eval 'sub EV_SSIZE_MIN () {((- &EV_SSIZE_MAX) - 1);}' unless defined(&EV_SSIZE_MIN);
    if(defined(&_WIN32)) {
	eval 'sub ev_socklen_t () {\'int\';}' unless defined(&ev_socklen_t);
    }
 elsif(defined(&EVENT__socklen_t)) {
	eval 'sub ev_socklen_t () { &EVENT__socklen_t;}' unless defined(&ev_socklen_t);
    } else {
	eval 'sub ev_socklen_t () { &socklen_t;}' unless defined(&ev_socklen_t);
    }
    if(defined(&EVENT__HAVE_STRUCT_SOCKADDR_STORAGE___SS_FAMILY)) {
	if(!defined(&EVENT__HAVE_STRUCT_SOCKADDR_STORAGE_SS_FAMILY)  && !defined(&ss_family)) {
	    eval 'sub ss_family () { &__ss_family;}' unless defined(&ss_family);
	}
    }
    if(defined(&_WIN32)) {
	eval 'sub evutil_socket_t () { &intptr_t;}' unless defined(&evutil_socket_t);
    } else {
	eval 'sub evutil_socket_t () {\'int\';}' unless defined(&evutil_socket_t);
    }
    if(defined(&EVENT_IN_DOXYGEN_)) {
    }
    eval 'sub EV_MONOT_PRECISE () {1;}' unless defined(&EV_MONOT_PRECISE);
    eval 'sub EV_MONOT_FALLBACK () {2;}' unless defined(&EV_MONOT_FALLBACK);
    eval 'sub EVUTIL_CLOSESOCKET {
        my($s) = @_;
	    eval q( &evutil_closesocket($s));
    }' unless defined(&EVUTIL_CLOSESOCKET);
    if(defined(&_WIN32)) {
	eval 'sub EVUTIL_SOCKET_ERROR () {
	    eval q( &WSAGetLastError());
	}' unless defined(&EVUTIL_SOCKET_ERROR);
	eval 'sub EVUTIL_SET_SOCKET_ERROR {
	    my($errcode) = @_;
    	    eval q( &do {  &WSASetLastError($errcode); }  &while (0));
	}' unless defined(&EVUTIL_SET_SOCKET_ERROR);
	eval 'sub EVUTIL_INVALID_SOCKET () { &INVALID_SOCKET;}' unless defined(&EVUTIL_INVALID_SOCKET);
    }
 elsif(defined(&EVENT_IN_DOXYGEN_)) {
	eval 'sub EVUTIL_SOCKET_ERROR () {
	    eval q(...);
	}' unless defined(&EVUTIL_SOCKET_ERROR);
	eval 'sub EVUTIL_SET_SOCKET_ERROR {
	    my($errcode) = @_;
    	    eval q(...);
	}' unless defined(&EVUTIL_SET_SOCKET_ERROR);
	eval 'sub evutil_socket_geterror {
	    my($sock) = @_;
    	    eval q(...);
	}' unless defined(&evutil_socket_geterror);
	eval 'sub evutil_socket_error_to_string {
	    my($errcode) = @_;
    	    eval q(...);
	}' unless defined(&evutil_socket_error_to_string);
	eval 'sub EVUTIL_INVALID_SOCKET () {-1;}' unless defined(&EVUTIL_INVALID_SOCKET);
    } else {
	eval 'sub EVUTIL_SOCKET_ERROR () {
	    eval q(( &errno));
	}' unless defined(&EVUTIL_SOCKET_ERROR);
	eval 'sub EVUTIL_SET_SOCKET_ERROR {
	    my($errcode) = @_;
    	    eval q( &do {  &errno = ($errcode); }  &while (0));
	}' unless defined(&EVUTIL_SET_SOCKET_ERROR);
	eval 'sub evutil_socket_geterror {
	    my($sock) = @_;
    	    eval q(( &errno));
	}' unless defined(&evutil_socket_geterror);
	eval 'sub evutil_socket_error_to_string {
	    my($errcode) = @_;
    	    eval q(( &strerror($errcode)));
	}' unless defined(&evutil_socket_error_to_string);
	eval 'sub EVUTIL_INVALID_SOCKET () {-1;}' unless defined(&EVUTIL_INVALID_SOCKET);
    }
    if(defined(&EVENT__HAVE_TIMERADD)) {
	eval 'sub evutil_timeradd {
	    my($tvp, $uvp, $vvp) = @_;
    	    eval q( &timeradd(($tvp), ($uvp), ($vvp)));
	}' unless defined(&evutil_timeradd);
	eval 'sub evutil_timersub {
	    my($tvp, $uvp, $vvp) = @_;
    	    eval q( &timersub(($tvp), ($uvp), ($vvp)));
	}' unless defined(&evutil_timersub);
    } else {
	eval 'sub evutil_timeradd {
	    my($tvp, $uvp, $vvp) = @_;
    	    eval q( &do { ($vvp)-> &tv_sec = ($tvp)-> &tv_sec + ($uvp)-> &tv_sec; ($vvp)-> &tv_usec = ($tvp)-> &tv_usec + ($uvp)-> &tv_usec;  &if (($vvp)-> &tv_usec >= 1000000) { ($vvp)-> &tv_sec++; ($vvp)-> &tv_usec -= 1000000; } }  &while (0));
	}' unless defined(&evutil_timeradd);
	eval 'sub evutil_timersub {
	    my($tvp, $uvp, $vvp) = @_;
    	    eval q( &do { ($vvp)-> &tv_sec = ($tvp)-> &tv_sec - ($uvp)-> &tv_sec; ($vvp)-> &tv_usec = ($tvp)-> &tv_usec - ($uvp)-> &tv_usec;  &if (($vvp)-> &tv_usec < 0) { ($vvp)-> &tv_sec--; ($vvp)-> &tv_usec += 1000000; } }  &while (0));
	}' unless defined(&evutil_timersub);
    }
    if(defined(&EVENT__HAVE_TIMERCLEAR)) {
	eval 'sub evutil_timerclear {
	    my($tvp) = @_;
    	    eval q( &timerclear($tvp));
	}' unless defined(&evutil_timerclear);
    } else {
	eval 'sub evutil_timerclear {
	    my($tvp) = @_;
    	    eval q(($tvp)-> &tv_sec = ($tvp)-> &tv_usec = 0);
	}' unless defined(&evutil_timerclear);
    }
    eval 'sub evutil_timercmp {
        my($tvp, $uvp, $cmp) = @_;
	    eval q(((($tvp)-> &tv_sec == ($uvp)-> &tv_sec) ? (($tvp)-> &tv_usec $cmp ($uvp)-> &tv_usec) : (($tvp)-> &tv_sec $cmp ($uvp)-> &tv_sec)));
    }' unless defined(&evutil_timercmp);
    if(defined(&EVENT__HAVE_TIMERISSET)) {
	eval 'sub evutil_timerisset {
	    my($tvp) = @_;
    	    eval q( &timerisset($tvp));
	}' unless defined(&evutil_timerisset);
    } else {
	eval 'sub evutil_timerisset {
	    my($tvp) = @_;
    	    eval q((($tvp)-> &tv_sec || ($tvp)-> &tv_usec));
	}' unless defined(&evutil_timerisset);
    }
    if(defined(&offsetof)) {
	eval 'sub evutil_offsetof {
	    my($type, $field) = @_;
    	    eval q( &offsetof($type, $field));
	}' unless defined(&evutil_offsetof);
    } else {
	eval 'sub evutil_offsetof {
	    my($type, $field) = @_;
    	    eval q((( &off_t)((($type *)0)->$field)));
	}' unless defined(&evutil_offsetof);
    }
    if(defined(&EVENT__HAVE_GETTIMEOFDAY)) {
	eval 'sub evutil_gettimeofday {
	    my($tv, $tz) = @_;
    	    eval q( &gettimeofday(($tv), ($tz)));
	}' unless defined(&evutil_gettimeofday);
    } else {
    }
    if(defined(&__GNUC__)) {
    }
    if(defined(&__GNUC__)) {
    }
    if(defined(&EVENT__HAVE_STRUCT_ADDRINFO)) {
	eval 'sub evutil_addrinfo () { &addrinfo;}' unless defined(&evutil_addrinfo);
    } else {
    }
    if(defined(&EAI_ADDRFAMILY)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_EAI_ADDRFAMILY () { &EAI_ADDRFAMILY;}' unless defined(&EVUTIL_EAI_ADDRFAMILY);
    } else {
	eval 'sub EVUTIL_EAI_ADDRFAMILY () {-901;}' unless defined(&EVUTIL_EAI_ADDRFAMILY);
    }
    if(defined(&EAI_AGAIN)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_EAI_AGAIN () { &EAI_AGAIN;}' unless defined(&EVUTIL_EAI_AGAIN);
    } else {
	eval 'sub EVUTIL_EAI_AGAIN () {-902;}' unless defined(&EVUTIL_EAI_AGAIN);
    }
    if(defined(&EAI_BADFLAGS)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_EAI_BADFLAGS () { &EAI_BADFLAGS;}' unless defined(&EVUTIL_EAI_BADFLAGS);
    } else {
	eval 'sub EVUTIL_EAI_BADFLAGS () {-903;}' unless defined(&EVUTIL_EAI_BADFLAGS);
    }
    if(defined(&EAI_FAIL)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_EAI_FAIL () { &EAI_FAIL;}' unless defined(&EVUTIL_EAI_FAIL);
    } else {
	eval 'sub EVUTIL_EAI_FAIL () {-904;}' unless defined(&EVUTIL_EAI_FAIL);
    }
    if(defined(&EAI_FAMILY)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_EAI_FAMILY () { &EAI_FAMILY;}' unless defined(&EVUTIL_EAI_FAMILY);
    } else {
	eval 'sub EVUTIL_EAI_FAMILY () {-905;}' unless defined(&EVUTIL_EAI_FAMILY);
    }
    if(defined(&EAI_MEMORY)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_EAI_MEMORY () { &EAI_MEMORY;}' unless defined(&EVUTIL_EAI_MEMORY);
    } else {
	eval 'sub EVUTIL_EAI_MEMORY () {-906;}' unless defined(&EVUTIL_EAI_MEMORY);
    }
    if(defined(&EAI_NODATA)  && defined(&EVENT__HAVE_GETADDRINFO)  && (!defined(&EAI_NONAME) || (defined(&EAI_NODATA) ? &EAI_NODATA : undef) != (defined(&EAI_NONAME) ? &EAI_NONAME : undef))) {
	eval 'sub EVUTIL_EAI_NODATA () { &EAI_NODATA;}' unless defined(&EVUTIL_EAI_NODATA);
    } else {
	eval 'sub EVUTIL_EAI_NODATA () {-907;}' unless defined(&EVUTIL_EAI_NODATA);
    }
    if(defined(&EAI_NONAME)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_EAI_NONAME () { &EAI_NONAME;}' unless defined(&EVUTIL_EAI_NONAME);
    } else {
	eval 'sub EVUTIL_EAI_NONAME () {-908;}' unless defined(&EVUTIL_EAI_NONAME);
    }
    if(defined(&EAI_SERVICE)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_EAI_SERVICE () { &EAI_SERVICE;}' unless defined(&EVUTIL_EAI_SERVICE);
    } else {
	eval 'sub EVUTIL_EAI_SERVICE () {-909;}' unless defined(&EVUTIL_EAI_SERVICE);
    }
    if(defined(&EAI_SOCKTYPE)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_EAI_SOCKTYPE () { &EAI_SOCKTYPE;}' unless defined(&EVUTIL_EAI_SOCKTYPE);
    } else {
	eval 'sub EVUTIL_EAI_SOCKTYPE () {-910;}' unless defined(&EVUTIL_EAI_SOCKTYPE);
    }
    if(defined(&EAI_SYSTEM)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_EAI_SYSTEM () { &EAI_SYSTEM;}' unless defined(&EVUTIL_EAI_SYSTEM);
    } else {
	eval 'sub EVUTIL_EAI_SYSTEM () {-911;}' unless defined(&EVUTIL_EAI_SYSTEM);
    }
    eval 'sub EVUTIL_EAI_CANCEL () {-90001;}' unless defined(&EVUTIL_EAI_CANCEL);
    if(defined(&AI_PASSIVE)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_AI_PASSIVE () { &AI_PASSIVE;}' unless defined(&EVUTIL_AI_PASSIVE);
    } else {
	eval 'sub EVUTIL_AI_PASSIVE () {0x1000;}' unless defined(&EVUTIL_AI_PASSIVE);
    }
    if(defined(&AI_CANONNAME)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_AI_CANONNAME () { &AI_CANONNAME;}' unless defined(&EVUTIL_AI_CANONNAME);
    } else {
	eval 'sub EVUTIL_AI_CANONNAME () {0x2000;}' unless defined(&EVUTIL_AI_CANONNAME);
    }
    if(defined(&AI_NUMERICHOST)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_AI_NUMERICHOST () { &AI_NUMERICHOST;}' unless defined(&EVUTIL_AI_NUMERICHOST);
    } else {
	eval 'sub EVUTIL_AI_NUMERICHOST () {0x4000;}' unless defined(&EVUTIL_AI_NUMERICHOST);
    }
    if(defined(&AI_NUMERICSERV)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_AI_NUMERICSERV () { &AI_NUMERICSERV;}' unless defined(&EVUTIL_AI_NUMERICSERV);
    } else {
	eval 'sub EVUTIL_AI_NUMERICSERV () {0x8000;}' unless defined(&EVUTIL_AI_NUMERICSERV);
    }
    if(defined(&AI_V4MAPPED)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_AI_V4MAPPED () { &AI_V4MAPPED;}' unless defined(&EVUTIL_AI_V4MAPPED);
    } else {
	eval 'sub EVUTIL_AI_V4MAPPED () {0x10000;}' unless defined(&EVUTIL_AI_V4MAPPED);
    }
    if(defined(&AI_ALL)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_AI_ALL () { &AI_ALL;}' unless defined(&EVUTIL_AI_ALL);
    } else {
	eval 'sub EVUTIL_AI_ALL () {0x20000;}' unless defined(&EVUTIL_AI_ALL);
    }
    if(defined(&AI_ADDRCONFIG)  && defined(&EVENT__HAVE_GETADDRINFO)) {
	eval 'sub EVUTIL_AI_ADDRCONFIG () { &AI_ADDRCONFIG;}' unless defined(&EVUTIL_AI_ADDRCONFIG);
    } else {
	eval 'sub EVUTIL_AI_ADDRCONFIG () {0x40000;}' unless defined(&EVUTIL_AI_ADDRCONFIG);
    }
    if(!defined(&EVENT__HAVE_ARC4RANDOM) || defined(&EVENT__HAVE_ARC4RANDOM_ADDRANDOM)) {
    }
    if(defined(&__cplusplus)) {
    }
}
1;
