/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.beans.Disposable;
import org.jhotdraw.beans.WeakPropertyChangeListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;

public abstract class AbstractDrawingViewAction
extends AbstractAction
implements Disposable {
    private DrawingEditor editor;
    private DrawingView specificView;
    private transient DrawingView activeView;
    private EventHandler eventHandler = new EventHandler();

    public AbstractDrawingViewAction(DrawingEditor drawingEditor) {
        this.setEditor(drawingEditor);
    }

    public AbstractDrawingViewAction(DrawingView drawingView) {
        this.specificView = drawingView;
        this.registerEventHandler();
    }

    protected void setEditor(DrawingEditor drawingEditor) {
        if (this.eventHandler != null) {
            this.unregisterEventHandler();
        }
        this.editor = drawingEditor;
        if (this.eventHandler != null) {
            this.registerEventHandler();
            this.updateEnabledState();
        }
    }

    protected DrawingEditor getEditor() {
        return this.editor;
    }

    protected DrawingView getView() {
        return this.specificView != null ? this.specificView : this.editor.getActiveView();
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        this.getDrawing().fireUndoableEditHappened(undoableEdit);
    }

    public void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled());
        } else {
            this.setEnabled(false);
        }
    }

    protected void updateViewState() {
    }

    @Override
    public void dispose() {
        this.setEditor(null);
    }

    public void setUpdateEnabledState(boolean bl) {
        if (this.eventHandler != null != bl) {
            if (bl) {
                this.eventHandler = new EventHandler();
                this.registerEventHandler();
            } else {
                this.unregisterEventHandler();
                this.eventHandler = null;
            }
        }
        if (bl) {
            this.updateEnabledState();
        }
    }

    public boolean isUpdatEnabledState() {
        return this.eventHandler != null;
    }

    private void unregisterEventHandler() {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
        }
        if (this.activeView != null) {
            this.activeView.removePropertyChangeListener(this.eventHandler);
            this.activeView = null;
        }
        if (this.specificView != null) {
            this.specificView.removePropertyChangeListener(this.eventHandler);
        }
    }

    private void registerEventHandler() {
        if (this.specificView != null) {
            this.specificView.addPropertyChangeListener(this.eventHandler);
        } else if (this.editor != null) {
            this.editor.addPropertyChangeListener(new WeakPropertyChangeListener(this.eventHandler));
            if (this.activeView != null) {
                this.activeView.removePropertyChangeListener(this.eventHandler);
            }
            this.activeView = this.editor.getActiveView();
            if (this.activeView != null) {
                this.activeView.addPropertyChangeListener(this.eventHandler);
            }
        }
    }

    private class EventHandler
    implements PropertyChangeListener {
        private EventHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                AbstractDrawingViewAction.this.updateEnabledState();
            } else if (propertyChangeEvent.getPropertyName() == "activeView") {
                if (AbstractDrawingViewAction.this.activeView != null) {
                    AbstractDrawingViewAction.this.activeView.removePropertyChangeListener(AbstractDrawingViewAction.this.eventHandler);
                    AbstractDrawingViewAction.this.activeView = null;
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    AbstractDrawingViewAction.this.activeView = (DrawingView)propertyChangeEvent.getNewValue();
                    AbstractDrawingViewAction.this.activeView.addPropertyChangeListener(AbstractDrawingViewAction.this.eventHandler);
                    AbstractDrawingViewAction.this.updateEnabledState();
                }
                AbstractDrawingViewAction.this.updateViewState();
            }
        }

        public String toString() {
            return AbstractDrawingViewAction.this + "^$EventHandler";
        }
    }
}

