/* -*- Mode: C; c-file-style: "gnu" -*-
   qop.h -- basic queue (doubly linked list) operations. 
   Created: Chris Toshok <toshok@hungry.com>, 10-Aug-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _qop_h
#define _qop_h

#define UNQUEUE(item, queue) \
do {\
      if ((queue) == (item)) (queue) = (item)->next; \
						       if ((item)->next) (item)->next->prev = (item)->prev; \
													      (item)->next = NULL; \
																     if ((item)->prev) (item)->prev->next = (item)->next; \
																							    (item)->prev = NULL; \
																										   } while (0);

#define ENQUEUE(item, queue) \
do { \
       if ((queue)) (queue)->prev = (item); \
					      (item)->next = (queue); \
									(queue) = (item); \
											    } while (0);

#endif /* _qop_h */
