#
# NAME
#	papaya.pl - perl library for swclib
# VERSION
#	$Id$
# CHANGELOG
#	$Log$
#

package papaya ;

$g_this = "UNKNOWN" ;

sub set_this_name {
	local($this) = @_ ;
	$g_this = $this ;
}

sub get_this_name {
	return $g_this ;
}

sub error {
	local($message) = @_ ;
	print STDERR "$g_this [ERROR] $message\n" ;
	exit 1 ;
}

sub warning {
	local($message) = @_ ;
	print STDERR "$g_this [WARNING] $message\n" ;
}

#
# verbose mode
#

$g_verbose = 0 ;

sub set_verbose_mode {
	local($mode) = @_ ;
	$g_verbose = $mode ;
}

sub verbose {
	local($message) = @_ ;
	$g_verbose == 0 || print STDERR "[verbose] $message\n" ;
}

#
# papaya-config
#
sub search_papaya_config {
	local($config) ;

	$config = $ENV{"PAPAYA_CONFIG"} ;
	if($config ne ''){
		if(! -x $config){
			error "env variable \"PAPAYA_CONFIG\" has been " .
			  "defined. but the value \"$config\" is not " .
			  "point executable file." ;
		}
	} else {
		$config = `which papaya-config 2>/dev/null` ;
		if($config ne '' || ! -x $config){
			error "papaya-config command is not found." ;
		}
		$ENV{"PAPAYA_CONFIG"} = $config ;
	}
	return $config ;
}

# NOTE: you must call search_papaya_config subroutine before call
#	this routine.
sub search_papaya_bin {
	local($cmdname) = @_ ;
	local($cmdpath) ;
	$cmdpath = `$ENV{"PAPAYA_CONFIG"} --bin-path $cmdname` ;
	$cmdpath = remove_spaces($cmdpath) ;
	if(! -x $cmdpath){
		error("command \"$cmdpath\" is not found.") ;
	}
	return $cmdpath ;
}

#
# file opeation
#

$g_stdin_name = "" ;
$g_stdin_line = 0 ;
$g_stdout_name = "" ;

sub open_stdin {
	local($filename) = @_ ;
	close(STDIN) ;
	if($filename eq ''){
		&error("file name is not given.") ;
	} elsif(! -f "$filename"){
		&error("file \"$filename\" is not exist.") ;
	} elsif(! -r "$filename"){
		&error("file \"$filename\" can not be read.") ;
	}
	open(STDIN, "<$filename") ||
		&error("can not read \"$filename\".") ;
	$g_stdin_name = $filename ;
}

sub get_stdin_name {
	return $g_stdin_name ;
}

sub change_stdin_name {
	($g_stdin_name) = @_ ;
}

sub get_stdin_line {
	return $g_stdin_line ;
}

sub change_stdin_line {
	($g_stdin_line) = @_ ;
}

sub open_stdout {
	local($filename) = @_ ;
	close(STDOUT) ;
	if($filename eq ''){
		&error("no output filename is given.") ;
	}
	open(STDOUT, ">$filename") ||
		&error("can not write \"$filename\".") ;
	$g_stdout_name = $filename ;
}

sub skip_empty_lines {
	local($line) ;
	while($line = &read_line()){
		if(! $line =~ /^\s*$/){
			last ;
		}
	}
	return $line ;
}

sub skip_comment_lines {
	local($line) ;
	while($line = &read_line()){
		if(!($line =~ /^\s*$/) && !($line =~ /^\s*#/)){
			last ;
		}
	}
	$line =~ s/#.*$// ;
	return $line ;
}

sub read_line {
	local($line, $nextline) ;
	$line = '' ;
	while($nextline = <>){
		$g_stdin_line++ ;
		$line = $line . $nextline ;
		if($line =~ /\\$/){
			$line =~ s/\\$// ;
		} else {
			last ;
		}
		chop $line ;
	}
	return $line ;
}

sub error_with_lineno {
	local($msg) = @_ ;
	&error("(near line $g_stdin_line in \"$g_stdin_name\") $msg") ;
}

sub warning_with_lineno {
	local($msg) = @_ ;
	&warning("(near line $g_stdin_line in \"$g_stdin_name\") $msg") ;
}

#
# indent operation
#
$g_tab_num = 0 ;

sub inc_tab_num {
	$g_tab_num++ ;
}

sub dec_tab_num {
	$g_tab_num-- ;
}

sub get_tab_string {
	local($i, $str) ;
	$str='' ;
	for($i=0 ; $i<g_tab_num ; $i++){
		$str = "$str\t" ;
	}
	return $str ;
}

# 
# string operation
#
sub remove_spaces {
	local($line) = @_ ;
	$line =~ s/^\s*// ; $line =~ s/\s*$// ;
	return $line ;
}

sub escape_double_quatation {
	local($line) = @_ ;
	$line =~ s/"/\\"/g ;
	return $line ;
}

sub connect_line_buffer {
	local(@buffer) = @_ ;
	local($line, $result) ;
	$result = '' ;
	foreach $line(@buffer){
		$result = $result . &remove_spaces($line) . " " ;
	}
	return $result ;
}

1 ;

