/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.Date;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MetalFileChooserUI
extends BasicFileChooserUI {
    private String directoryLabel;
    private JComboBox directoryComboBox;
    DirectoryComboBoxModel directoryModel;
    private String fileLabel;
    private JTextField fileTextField;
    private String filterLabel;
    private JPanel topPanel;
    private JPanel controls;
    private JPanel bottomPanel = new JPanel(new GridLayout(3, 2));
    private JPanel buttonPanel = new JPanel();
    private JButton approveButton;
    JList fileList;
    JTable fileTable;
    JPanel fileListPanel;
    JPanel fileTablePanel;
    private FilterComboBoxModel filterModel;
    private ActionMap actionMap;
    boolean listView;
    boolean startEditing;
    JScrollPane scrollPane;
    String save;
    String look;
    JLabel dirLabel;
    ListSelectionListener listSelList;
    MouseListener doubleClickList;
    SingleClickListener singleClickList;
    TableClickListener tableClickList;
    static /* synthetic */ Class class$java$lang$Object;

    public static ComponentUI createUI(JComponent jComponent) {
        JFileChooser jFileChooser = (JFileChooser)jComponent;
        return new MetalFileChooserUI(jFileChooser);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.actionMap = this.createActionMap();
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.actionMap = null;
    }

    public void installComponents(JFileChooser jFileChooser) {
        jFileChooser.setLayout(new BorderLayout());
        this.topPanel = new JPanel(new BorderLayout());
        this.dirLabel = new JLabel(this.directoryLabel);
        this.topPanel.add((Component)this.dirLabel, "West");
        this.controls = new JPanel();
        this.addControlButtons();
        JPanel jPanel = new JPanel(new VerticalMidLayout());
        this.directoryModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox = new JComboBox(this.directoryModel);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        jPanel.add(this.directoryComboBox);
        this.topPanel.add(jPanel);
        this.topPanel.add((Component)this.controls, "East");
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        jFileChooser.add((Component)this.topPanel, "North");
        JPanel jPanel2 = this.createList(jFileChooser);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jFileChooser.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.getBottomPanel();
        this.filterModel = this.createFilterComboBoxModel();
        JComboBox jComboBox = new JComboBox(this.filterModel);
        jComboBox.setRenderer(this.createFilterComboBoxRenderer());
        this.fileTextField = new JTextField();
        JPanel jPanel4 = new JPanel(new VerticalMidLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 5));
        jPanel4.add(this.fileTextField);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)new JLabel(this.fileLabel), "West");
        jPanel5.add(jPanel4);
        jPanel3.add(jPanel5);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)new JLabel(this.filterLabel), "West");
        jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jPanel6.add(jComboBox);
        jPanel3.add(jPanel6);
        JPanel jPanel7 = new JPanel(new ButtonLayout());
        this.approveButton = new JButton(this.getApproveSelectionAction());
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        jPanel7.add(this.approveButton);
        jPanel7.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        JButton jButton = new JButton(this.getCancelSelectionAction());
        jButton.setText(this.cancelButtonText);
        jButton.setToolTipText(this.cancelButtonToolTipText);
        jButton.setMnemonic(this.cancelButtonMnemonic);
        jPanel7.add(jButton);
        jPanel3.add((Component)jPanel7, "South");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        jFileChooser.add((Component)jPanel3, "South");
        jFileChooser.add((Component)this.getAccessoryPanel(), "East");
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.remove(this.bottomPanel);
        this.bottomPanel = null;
        jFileChooser.remove(this.fileListPanel);
        jFileChooser.remove(this.fileTablePanel);
        this.fileTablePanel = null;
        this.fileListPanel = null;
        jFileChooser.remove(this.topPanel);
        this.topPanel = null;
        this.directoryModel = null;
        this.fileTextField = null;
        this.directoryComboBox = null;
    }

    protected JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new GridLayout(3, 2));
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        this.look = "Look In: ";
        this.save = "Save In: ";
        this.directoryLabel = jFileChooser.getDialogType() == 1 ? this.save : this.look;
        this.fileLabel = "File Name: ";
        this.filterLabel = "Files of Type: ";
        this.cancelButtonMnemonic = 0;
        this.cancelButtonText = "Cancel";
        this.cancelButtonToolTipText = "Abort file chooser dialog";
        this.directoryOpenButtonMnemonic = 0;
        this.directoryOpenButtonText = "Open";
        this.directoryOpenButtonToolTipText = "Open selected directory";
        this.helpButtonMnemonic = 0;
        this.helpButtonText = "Help";
        this.helpButtonToolTipText = "Filechooser help";
        this.openButtonMnemonic = 0;
        this.openButtonText = "Open";
        this.openButtonToolTipText = "Open selected file";
        this.saveButtonMnemonic = 0;
        this.saveButtonText = "Save";
        this.saveButtonToolTipText = "Save selected file";
        this.updateButtonMnemonic = 0;
        this.updateButtonText = "Update";
        this.updateButtonToolTipText = "Update directory listing";
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.directoryComboBox.setAction(new DirectoryComboBoxAction());
        jFileChooser.addPropertyChangeListener(this.filterModel);
        this.listSelList = this.createListSelectionListener(jFileChooser);
        this.doubleClickList = this.createDoubleClickListener(jFileChooser, this.fileList);
        this.singleClickList = new SingleClickListener(this.fileList);
        this.fileList.addListSelectionListener(this.listSelList);
        this.fileList.addMouseListener(this.doubleClickList);
        this.fileList.addMouseListener(this.singleClickList);
        super.installListeners(jFileChooser);
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
        jFileChooser.removePropertyChangeListener(this.filterModel);
        this.directoryComboBox.setAction(null);
        this.fileList.removeListSelectionListener(this.listSelList);
        this.fileList.removeMouseListener(this.doubleClickList);
        this.fileList.removeMouseListener(this.singleClickList);
        if (this.fileTable != null) {
            this.fileTable.removeMouseListener(this.tableClickList);
        }
    }

    protected ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = this.createActionMap();
        }
        return this.actionMap;
    }

    protected ActionMap createActionMap() {
        ActionMap actionMap = new ActionMap();
        actionMap.put("approveSelection", this.getApproveSelectionAction());
        actionMap.put("cancelSelection", this.getCancelSelectionAction());
        actionMap.put("Go Up", this.getChangeToParentDirectoryAction());
        return actionMap;
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        if (this.fileList == null) {
            this.fileListPanel = new JPanel(new BorderLayout());
            this.fileList = new JList(this.getModel());
            this.scrollPane = new JScrollPane(this.fileList);
            this.fileList.setLayoutOrientation(1);
            this.fileList.setCellRenderer(new FileRenderer());
        } else {
            this.fileList.setModel(this.getModel());
            this.fileListPanel.removeAll();
            this.scrollPane.getViewport().setView(this.fileList);
        }
        this.fileListPanel.add(this.scrollPane);
        this.fileListPanel.setPreferredSize(new Dimension(405, 135));
        return this.fileListPanel;
    }

    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        this.fileTablePanel = new JPanel(new BorderLayout());
        Object[] objectArray = new Object[]{"Name", "Size", "Modified"};
        Object[][] objectArray2 = new Object[this.fileList.getModel().getSize()][3];
        this.fileTable = new JTable(new DefaultTableModel(objectArray2, objectArray));
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.fileTable.setSelectionMode(2);
        } else {
            this.fileTable.setSelectionMode(0);
        }
        this.fileTable.setShowGrid(false);
        this.fileTable.setColumnSelectionAllowed(false);
        Class clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = MetalFileChooserUI.class("[Ljava.lang.Object;", false);
        }
        this.fileTable.setDefaultRenderer(clazz, new TableFileRenderer());
        this.tableClickList = new TableClickListener(this.fileTable, jFileChooser);
        this.fileTable.addMouseListener(this.tableClickList);
        return this.updateTable();
    }

    JPanel updateTable() {
        int n;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.fileTable.getModel();
        ListModel listModel = this.fileList.getModel();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        File file = null;
        int n2 = listModel.getSize();
        int n3 = n = defaultTableModel.getRowCount();
        while (n3 < n2) {
            defaultTableModel.addRow(new Object[3]);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            file = (File)listModel.getElementAt(n3);
            this.fileTable.setValueAt(file.getName(), n3, 0);
            this.fileTable.setValueAt(this.formatSize(file.length()), n3, 1);
            this.fileTable.setValueAt(dateFormat.format(new Date(file.lastModified())), n3, 2);
            ++n3;
        }
        while (n > n2) {
            defaultTableModel.removeRow(--n);
        }
        this.scrollPane.getViewport().setView(this.fileTable);
        this.scrollPane.setColumnHeaderView(this.fileTable.getTableHeader());
        this.fileTablePanel.removeAll();
        this.fileTablePanel.add(this.scrollPane);
        return this.fileTablePanel;
    }

    private final String formatSize(long l) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        long l2 = (long)Math.pow(2, 20.0);
        long l3 = (long)Math.pow(2, 10.0);
        long l4 = (long)Math.pow(2, 30.0);
        double d = 0.0;
        String string = "";
        if (l / l4 >= 1L) {
            d = (double)l / (double)l4;
            string = "GB";
        } else if (l / l2 >= 1L) {
            d = (double)l / (double)l2;
            string = "MB";
        } else if (l / l3 >= 1L) {
            d = (double)l / (double)l3;
            string = "KB";
        } else {
            d = l;
            string = "Bytes";
        }
        return numberFormat.format(d) + ' ' + string;
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new MetalFileChooserSelectionListener();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.topPanel.getPreferredSize();
        Dimension dimension2 = this.bottomPanel.getPreferredSize();
        Dimension dimension3 = this.fileListPanel.getPreferredSize();
        return new Dimension(dimension3.width, dimension.height + dimension2.height + dimension3.height);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.topPanel.getMinimumSize();
        Dimension dimension2 = this.bottomPanel.getMinimumSize();
        Dimension dimension3 = this.fileListPanel.getMinimumSize();
        return new Dimension(dimension3.width, dimension.height + dimension2.height + dimension3.height);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new MetalFileChooserPropertyChangeListener();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer(jFileChooser);
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected void addControlButtons() {
        JButton jButton = new JButton(this.getChangeToParentDirectoryAction());
        jButton.setText(null);
        jButton.setIcon(this.upFolderIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        this.controls.add(jButton);
        JButton jButton2 = new JButton(this.getGoHomeAction());
        jButton2.setText(null);
        jButton2.setIcon(this.homeFolderIcon);
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        this.controls.add(jButton2);
        JButton jButton3 = new JButton(this.getNewFolderAction());
        jButton3.setText(null);
        jButton3.setIcon(this.newFolderIcon);
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        this.controls.add(jButton3);
        JToggleButton jToggleButton = new JToggleButton(this.listViewIcon);
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton.addActionListener(new ListViewActionListener());
        jToggleButton.setSelected(true);
        this.listView = true;
        this.controls.add(jToggleButton);
        JToggleButton jToggleButton2 = new JToggleButton(this.detailsViewIcon);
        jToggleButton2.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton2.addActionListener(new DetailViewActionListener());
        jToggleButton2.setSelected(false);
        this.controls.add(jToggleButton2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jToggleButton);
        buttonGroup.add(jToggleButton2);
    }

    protected void removeControlButtons() {
        this.controls.removeAll();
        this.controls.revalidate();
        this.controls.repaint();
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.directoryModel.setSelectedItem(jFileChooser.getCurrentDirectory());
        this.getModel().validateFileCache();
        if (!this.listView) {
            this.updateTable();
        } else {
            this.createList(jFileChooser);
        }
    }

    public String getFileName() {
        String string = null;
        if (this.fileTextField != null) {
            string = this.fileTextField.getText();
        }
        return string;
    }

    public void setFileName(String string) {
        this.fileTextField.setText(string);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public MetalFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class VerticalMidLayout
    implements LayoutManager {
        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            if (n > 0) {
                Insets insets = container.getInsets();
                Component component = container.getComponent(0);
                Dimension dimension = component.getPreferredSize();
                int n2 = container.getHeight() - insets.top - insets.bottom;
                int n3 = Math.max(0, (n2 - dimension.height) / 2);
                component.setBounds(insets.left, insets.top + n3, container.getWidth() - insets.left - insets.right, (int)Math.min(dimension.getHeight(), (double)n2));
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            if (container.getComponentCount() > 0) {
                return container.getComponent(0).getPreferredSize();
            }
            return null;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        VerticalMidLayout() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ButtonLayout
    implements LayoutManager {
        static final int GAP = 4;

        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            if (n > 0) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    Component component = container.getComponent(n3);
                    Dimension dimension = component.getPreferredSize();
                    n2 = Math.max(dimension.width, n2);
                    ++n3;
                }
                Insets insets = container.getInsets();
                int n4 = container.getHeight() - insets.top - insets.bottom;
                int n5 = container.getWidth() - insets.right;
                int n6 = n - 1;
                while (n6 >= 0) {
                    Component component = container.getComponent(n6);
                    Dimension dimension = component.getPreferredSize();
                    int n7 = Math.max(0, (n4 - dimension.height) / 2);
                    component.setBounds(n5 -= dimension.width, insets.top + n7, dimension.width, (int)Math.min(dimension.getHeight(), (double)n4));
                    n5 -= 4;
                    --n6;
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            int n = 0;
            int n2 = 0;
            int n3 = container.getComponentCount();
            if (n3 > 0) {
                int n4 = 0;
                while (n4 < n3) {
                    Component component = container.getComponent(n4);
                    Dimension dimension = component.getPreferredSize();
                    n = Math.max(dimension.width, n);
                    n2 = Math.max(dimension.height, n2);
                    ++n4;
                }
            }
            return new Dimension(n * n3 + 4 * (n3 - 1) + insets.left + insets.right, n2 + insets.top + insets.bottom);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        ButtonLayout() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class DirectoryComboBoxAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
            jFileChooser.setCurrentDirectory((File)MetalFileChooserUI.this.directoryModel.getSelectedItem());
        }

        protected DirectoryComboBoxAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class SingleClickListener
    extends MouseAdapter {
        JList list;
        File editFile;
        JFileChooser fc;
        Object lastSelected;
        JTextField editField;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 1) {
                int n = this.list.locationToIndex(mouseEvent.getPoint());
                File[] fileArray = this.fc.getSelectedFiles();
                if ((!this.fc.isMultiSelectionEnabled() || fileArray != null && fileArray.length <= 1) && n >= 0 && !MetalFileChooserUI.this.startEditing && this.list.isSelectedIndex(n)) {
                    Object object = this.list.getModel().getElementAt(n);
                    if (this.lastSelected != null && this.lastSelected.equals(object)) {
                        this.editFile(n);
                    }
                    this.lastSelected = object;
                } else {
                    this.completeEditing();
                }
            } else {
                this.completeEditing();
            }
        }

        void editFile(int n) {
            Rectangle rectangle = this.list.getCellBounds(n, n);
            this.list.scrollRectToVisible(rectangle);
            this.editFile = (File)this.list.getModel().getElementAt(n);
            if (this.editFile.canWrite()) {
                MetalFileChooserUI.this.startEditing = true;
                this.editField = new JTextField(this.editFile.getName());
                this.editField.addActionListener(new EditingActionListener());
                Icon icon = MetalFileChooserUI.this.getFileView(this.fc).getIcon(this.editFile);
                if (icon != null) {
                    int n2 = icon.getIconWidth() + 4;
                    rectangle.x += n2;
                    rectangle.width -= n2;
                }
                this.editField.setBounds(rectangle);
                this.list.add(this.editField);
                this.editField.requestFocus();
                this.editField.selectAll();
            } else {
                this.completeEditing();
            }
            this.list.repaint();
        }

        void completeEditing() {
            if (this.editField != null && this.editFile != null) {
                String string = this.editField.getText();
                if (string != null && string != "" && !string.equals(this.fc.getName(this.editFile)) && this.editFile.renameTo(this.fc.getFileSystemView().createFileObject(this.fc.getCurrentDirectory(), string))) {
                    MetalFileChooserUI.this.rescanCurrentDirectory(this.fc);
                }
                this.list.remove(this.editField);
            }
            MetalFileChooserUI.this.startEditing = false;
            this.editFile = null;
            this.lastSelected = null;
            this.editField = null;
            this.list.repaint();
        }

        public SingleClickListener(JList jList) {
            this.list = jList;
            this.editFile = null;
            this.fc = MetalFileChooserUI.this.getFileChooser();
            this.lastSelected = null;
            MetalFileChooserUI.this.startEditing = false;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class EditingActionListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("notify-field-accept")) {
                    SingleClickListener.this.completeEditing();
                } else if (SingleClickListener.this.editField != null) {
                    SingleClickListener.this.list.remove(SingleClickListener.this.editField);
                    MetalFileChooserUI.this.startEditing = false;
                    SingleClickListener.this.editFile = null;
                    SingleClickListener.this.lastSelected = null;
                    SingleClickListener.this.editField = null;
                    SingleClickListener.this.list.repaint();
                }
            }

            EditingActionListener() {
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class FileRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            FileView fileView = MetalFileChooserUI.this.getFileView(MetalFileChooserUI.this.getFileChooser());
            File file = (File)object;
            if (file != null) {
                this.setText(fileView.getName(file));
                this.setIcon(fileView.getIcon(file));
            } else {
                this.setText("");
                this.setIcon(null);
            }
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            if (bl2) {
                this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }

        protected FileRenderer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TableFileRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                FileView fileView = MetalFileChooserUI.this.getFileView(MetalFileChooserUI.this.getFileChooser());
                ListModel listModel = MetalFileChooserUI.this.fileList.getModel();
                if (n < listModel.getSize()) {
                    this.setIcon(fileView.getIcon((File)listModel.getElementAt(n)));
                }
            } else {
                this.setIcon(null);
            }
            this.setText(object.toString());
            this.setOpaque(true);
            this.setEnabled(jTable.isEnabled());
            this.setFont(MetalFileChooserUI.this.fileList.getFont());
            if (MetalFileChooserUI.this.startEditing && n2 == 0 || !bl) {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            } else {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            }
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TableClickListener
    extends MouseAdapter {
        JTable table;
        JFileChooser fc;
        Object lastSelected;
        File editFile;
        JTextField editField;

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.table.getSelectedRow();
            Object object = MetalFileChooserUI.this.fileList.getModel().getElementAt(n);
            if (object == null) {
                return;
            }
            FileSystemView fileSystemView = this.fc.getFileSystemView();
            if (mouseEvent.getClickCount() == 1 && object.equals(this.lastSelected) && mouseEvent.getButton() == 1) {
                File[] fileArray = this.fc.getSelectedFiles();
                if ((!this.fc.isMultiSelectionEnabled() || fileArray != null && fileArray.length <= 1) && !MetalFileChooserUI.this.startEditing) {
                    this.editFile = (File)object;
                    this.editFile(n);
                }
            } else if (mouseEvent.getClickCount() >= 2 && object.equals(this.lastSelected)) {
                File file;
                if (MetalFileChooserUI.this.startEditing) {
                    this.completeEditing();
                }
                if (this.fc.isTraversable(file = fileSystemView.createFileObject(this.lastSelected.toString()))) {
                    this.fc.setCurrentDirectory(file);
                    this.fc.rescanCurrentDirectory();
                } else {
                    this.fc.setSelectedFile(file);
                    this.fc.approveSelection();
                    this.closeDialog();
                }
            } else {
                if (MetalFileChooserUI.this.startEditing) {
                    this.completeEditing();
                }
                String string = object.toString();
                File file = fileSystemView.createFileObject(string);
                this.fc.setSelectedFile(file);
                if (this.fc.isTraversable(file)) {
                    MetalFileChooserUI.this.setDirectorySelected(true);
                    MetalFileChooserUI.this.setDirectory(file);
                } else {
                    MetalFileChooserUI.this.setDirectorySelected(false);
                    MetalFileChooserUI.this.setDirectory(null);
                }
                this.lastSelected = object;
                if (file.isFile()) {
                    MetalFileChooserUI.this.setFileName(string.substring(string.lastIndexOf("/") + 1));
                } else if (this.fc.getFileSelectionMode() == 1) {
                    MetalFileChooserUI.this.setFileName(string);
                }
            }
            MetalFileChooserUI.this.fileTable.repaint();
        }

        void editFile(int n) {
            Rectangle rectangle = this.table.getCellRect(n, 0, true);
            this.table.scrollRectToVisible(rectangle);
            if (this.editFile.canWrite()) {
                MetalFileChooserUI.this.startEditing = true;
                this.editField = new JTextField(this.editFile.getName());
                this.editField.addActionListener(new EditingActionListener());
                rectangle.y = n * this.table.getRowHeight();
                this.editField.setBounds(rectangle);
                this.table.add(this.editField);
                this.editField.requestFocus();
                this.editField.selectAll();
            } else {
                this.completeEditing();
            }
            this.table.repaint();
        }

        void completeEditing() {
            if (this.editField != null && this.editFile != null) {
                String string = this.editField.getText();
                if (string != null && string != "" && !string.equals(this.fc.getName(this.editFile)) && this.editFile.renameTo(this.fc.getFileSystemView().createFileObject(this.fc.getCurrentDirectory(), string))) {
                    MetalFileChooserUI.this.rescanCurrentDirectory(this.fc);
                }
                this.table.remove(this.editField);
            }
            MetalFileChooserUI.this.startEditing = false;
            this.editFile = null;
            this.editField = null;
            this.table.repaint();
        }

        public void closeDialog() {
            Window window = SwingUtilities.windowForComponent(this.fc);
            if (window instanceof JDialog) {
                ((JDialog)window).dispose();
            }
        }

        private final /* synthetic */ void this() {
            this.lastSelected = null;
        }

        public TableClickListener(JTable jTable, JFileChooser jFileChooser) {
            this.this();
            this.table = jTable;
            this.fc = jFileChooser;
            this.lastSelected = MetalFileChooserUI.this.fileList.getSelectedValue();
            MetalFileChooserUI.this.setDirectorySelected(false);
            MetalFileChooserUI.this.startEditing = false;
            this.editFile = null;
            this.editField = null;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class EditingActionListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("notify-field-accept")) {
                    TableClickListener.this.completeEditing();
                } else if (TableClickListener.this.editField != null) {
                    TableClickListener.this.table.remove(TableClickListener.this.editField);
                    MetalFileChooserUI.this.startEditing = false;
                    TableClickListener.this.editFile = null;
                    TableClickListener.this.editField = null;
                    TableClickListener.this.table.repaint();
                }
            }

            EditingActionListener() {
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MetalFileChooserSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            File file = (File)MetalFileChooserUI.this.fileList.getSelectedValue();
            if (file == null) {
                return;
            }
            JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
            if (!jFileChooser.isTraversable(file)) {
                jFileChooser.setSelectedFile(file);
            } else {
                jFileChooser.setSelectedFile(null);
            }
        }

        protected MetalFileChooserSelectionListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MetalFileChooserPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("MultiSelectionEnabledChangedProperty")) {
                int n = -1;
                n = jFileChooser.isMultiSelectionEnabled() ? 2 : 0;
                if (MetalFileChooserUI.this.listView) {
                    MetalFileChooserUI.this.fileList.setSelectionMode(n);
                } else {
                    MetalFileChooserUI.this.fileTable.setSelectionMode(n);
                }
            } else if (string.equals("SelectedFileChangedProperty")) {
                File file = jFileChooser.getSelectedFile();
                if (file != null && jFileChooser.getDialogType() == 1) {
                    if (file.isDirectory() && jFileChooser.isTraversable(file)) {
                        MetalFileChooserUI.this.directoryLabel = MetalFileChooserUI.this.look;
                        MetalFileChooserUI.this.dirLabel.setText(MetalFileChooserUI.this.directoryLabel);
                        jFileChooser.setApproveButtonText(MetalFileChooserUI.this.openButtonText);
                        jFileChooser.setApproveButtonToolTipText(MetalFileChooserUI.this.openButtonToolTipText);
                    } else if (file.isFile()) {
                        MetalFileChooserUI.this.directoryLabel = MetalFileChooserUI.this.save;
                        MetalFileChooserUI.this.dirLabel.setText(MetalFileChooserUI.this.directoryLabel);
                        jFileChooser.setApproveButtonText(MetalFileChooserUI.this.saveButtonText);
                        jFileChooser.setApproveButtonToolTipText(MetalFileChooserUI.this.saveButtonToolTipText);
                    }
                }
                if (file == null) {
                    MetalFileChooserUI.this.setFileName(null);
                } else {
                    MetalFileChooserUI.this.setFileName(file.getName());
                }
                int n = -1;
                n = MetalFileChooserUI.this.getModel().indexOf(file);
                if (n >= 0) {
                    if (MetalFileChooserUI.this.listView) {
                        MetalFileChooserUI.this.fileList.setSelectedIndex(n);
                        MetalFileChooserUI.this.fileList.ensureIndexIsVisible(n);
                        MetalFileChooserUI.this.fileList.revalidate();
                        MetalFileChooserUI.this.fileList.repaint();
                    } else {
                        MetalFileChooserUI.this.fileTable.getSelectionModel().addSelectionInterval(n, n);
                        MetalFileChooserUI.this.fileTable.scrollRectToVisible(MetalFileChooserUI.this.fileTable.getCellRect(n, 0, true));
                        MetalFileChooserUI.this.fileTable.revalidate();
                        MetalFileChooserUI.this.fileTable.repaint();
                    }
                }
            } else if (string.equals("directoryChanged")) {
                if (MetalFileChooserUI.this.listView) {
                    MetalFileChooserUI.this.fileList.clearSelection();
                    MetalFileChooserUI.this.fileList.revalidate();
                    MetalFileChooserUI.this.fileList.repaint();
                } else {
                    MetalFileChooserUI.this.fileTable.clearSelection();
                    MetalFileChooserUI.this.fileTable.revalidate();
                    MetalFileChooserUI.this.fileTable.repaint();
                }
                MetalFileChooserUI.this.setDirectorySelected(false);
                File file = jFileChooser.getCurrentDirectory();
                MetalFileChooserUI.this.setDirectory(file);
                boolean bl = false;
                if (file.getParentFile() != null) {
                    bl = true;
                }
                boolean bl2 = bl;
                MetalFileChooserUI.this.getChangeToParentDirectoryAction().setEnabled(bl2);
            } else if (string.equals("ChoosableFileFilterChangedProperty")) {
                MetalFileChooserUI.this.filterModel.propertyChange(propertyChangeEvent);
            } else if (string.equals("fileFilterChanged")) {
                MetalFileChooserUI.this.filterModel.propertyChange(propertyChangeEvent);
            } else if (string.equals("DialogTypeChangedProperty") || string.equals("DialogTitleChangedProperty")) {
                Window window = SwingUtilities.windowForComponent(jFileChooser);
                if (window instanceof JDialog) {
                    ((JDialog)window).setTitle(MetalFileChooserUI.this.getDialogTitle(jFileChooser));
                }
                MetalFileChooserUI.this.approveButton.setText(MetalFileChooserUI.this.getApproveButtonText(jFileChooser));
                MetalFileChooserUI.this.approveButton.setToolTipText(MetalFileChooserUI.this.getApproveButtonToolTipText(jFileChooser));
                MetalFileChooserUI.this.approveButton.setMnemonic(MetalFileChooserUI.this.getApproveButtonMnemonic(jFileChooser));
            } else if (string.equals("ApproveButtonTextChangedProperty")) {
                MetalFileChooserUI.this.approveButton.setText(MetalFileChooserUI.this.getApproveButtonText(jFileChooser));
            } else if (string.equals("ApproveButtonToolTipTextChangedProperty")) {
                MetalFileChooserUI.this.approveButton.setToolTipText(MetalFileChooserUI.this.getApproveButtonToolTipText(jFileChooser));
            } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                MetalFileChooserUI.this.approveButton.setMnemonic(MetalFileChooserUI.this.getApproveButtonMnemonic(jFileChooser));
            } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                if (jFileChooser.getControlButtonsAreShown()) {
                    MetalFileChooserUI.this.topPanel.add((Component)MetalFileChooserUI.this.controls, "East");
                } else {
                    MetalFileChooserUI.this.topPanel.remove(MetalFileChooserUI.this.controls);
                }
                MetalFileChooserUI.this.topPanel.revalidate();
                MetalFileChooserUI.this.topPanel.repaint();
                MetalFileChooserUI.this.topPanel.doLayout();
            } else if (string.equals("acceptAllFileFilterUsedChanged")) {
                if (jFileChooser.isAcceptAllFileFilterUsed()) {
                    jFileChooser.addChoosableFileFilter(MetalFileChooserUI.this.getAcceptAllFileFilter(jFileChooser));
                } else {
                    jFileChooser.removeChoosableFileFilter(MetalFileChooserUI.this.getAcceptAllFileFilter(jFileChooser));
                }
            } else if (string.equals("AccessoryChangedProperty")) {
                JComponent jComponent;
                JComponent jComponent2 = (JComponent)propertyChangeEvent.getOldValue();
                if (jComponent2 != null) {
                    MetalFileChooserUI.this.getAccessoryPanel().remove(jComponent2);
                }
                if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                    MetalFileChooserUI.this.getAccessoryPanel().add(jComponent);
                }
            }
            if (string.equals("directoryChanged") || string.equals("fileFilterChanged") || string.equals("FileHidingChanged")) {
                if (MetalFileChooserUI.this.fileTable != null) {
                    MetalFileChooserUI.this.fileTable.removeAll();
                }
                if (MetalFileChooserUI.this.fileList != null) {
                    MetalFileChooserUI.this.fileList.removeAll();
                }
                MetalFileChooserUI.this.startEditing = false;
                if (jFileChooser.getDialogType() == 1) {
                    MetalFileChooserUI.this.directoryLabel = MetalFileChooserUI.this.save;
                    MetalFileChooserUI.this.dirLabel.setText(MetalFileChooserUI.this.directoryLabel);
                    jFileChooser.setApproveButtonText(MetalFileChooserUI.this.saveButtonText);
                    jFileChooser.setApproveButtonToolTipText(MetalFileChooserUI.this.saveButtonToolTipText);
                }
                MetalFileChooserUI.this.rescanCurrentDirectory(jFileChooser);
            }
            jFileChooser.revalidate();
            jFileChooser.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private List items = new ArrayList();
        private int selectedIndex = -1;

        public int getSize() {
            return this.items.size();
        }

        public Object getElementAt(int n) {
            return this.items.get(n);
        }

        public int getDepth(int n) {
            return Math.max(n, 0);
        }

        public Object getSelectedItem() {
            if (this.selectedIndex >= 0) {
                return this.items.get(this.selectedIndex);
            }
            return null;
        }

        public void setSelectedItem(Object object) {
            this.items.clear();
            FileSystemView fileSystemView = MetalFileChooserUI.this.getFileChooser().getFileSystemView();
            File file = (File)object;
            while (file != null) {
                this.items.add(0, file);
                file = fileSystemView.getParentDirectory(file);
            }
            this.selectedIndex = this.items.indexOf(object);
            this.fireContentsChanged(this, 0, this.items.size() - 1);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            FileView fileView = MetalFileChooserUI.this.getFileView(MetalFileChooserUI.this.getFileChooser());
            File file = (File)object;
            this.setIcon(fileView.getIcon(file));
            this.setText(fileView.getName(file));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }

        public DirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters = new FileFilter[1];
        private Object selected;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("fileFilterChanged")) {
                JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
                FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
                this.filters = fileFilterArray;
                this.fireContentsChanged(this, 0, this.filters.length);
                this.selected = propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (propertyChangeEvent.getPropertyName().equals("ChoosableFileFilterChangedProperty")) {
                JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
                FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
                this.filters = fileFilterArray;
                this.fireContentsChanged(this, 0, this.filters.length);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                this.selected = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public int getSize() {
            return this.filters.length;
        }

        public Object getElementAt(int n) {
            return this.filters[n];
        }

        protected FilterComboBoxModel() {
            this.filters[0] = MetalFileChooserUI.this.getAcceptAllFileFilter(MetalFileChooserUI.this.getFileChooser());
            this.selected = this.filters[0];
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            FileFilter fileFilter = (FileFilter)object;
            this.setText(fileFilter.getDescription());
            return this;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ListViewActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!MetalFileChooserUI.this.listView) {
                int[] nArray = MetalFileChooserUI.this.fileTable.getSelectedRows();
                MetalFileChooserUI.this.listView = true;
                JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
                jFileChooser.remove(MetalFileChooserUI.this.fileTablePanel);
                MetalFileChooserUI.this.createList(jFileChooser);
                MetalFileChooserUI.this.fileList.getSelectionModel().clearSelection();
                if (nArray.length > 0) {
                    int n = 0;
                    while (n < nArray.length) {
                        MetalFileChooserUI.this.fileList.getSelectionModel().addSelectionInterval(nArray[n], nArray[n]);
                        ++n;
                    }
                }
                jFileChooser.add((Component)MetalFileChooserUI.this.fileListPanel, "Center");
                jFileChooser.revalidate();
                jFileChooser.repaint();
            }
        }

        ListViewActionListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DetailViewActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (MetalFileChooserUI.this.listView) {
                int[] nArray = MetalFileChooserUI.this.fileList.getSelectedIndices();
                JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
                MetalFileChooserUI.this.listView = false;
                jFileChooser.remove(MetalFileChooserUI.this.fileListPanel);
                if (MetalFileChooserUI.this.fileTable == null) {
                    MetalFileChooserUI.this.createDetailsView(jFileChooser);
                } else {
                    MetalFileChooserUI.this.updateTable();
                }
                MetalFileChooserUI.this.fileTable.getSelectionModel().clearSelection();
                if (nArray.length > 0) {
                    int n = 0;
                    while (n < nArray.length) {
                        MetalFileChooserUI.this.fileTable.getSelectionModel().addSelectionInterval(nArray[n], nArray[n]);
                        ++n;
                    }
                }
                jFileChooser.add((Component)MetalFileChooserUI.this.fileTablePanel, "Center");
                jFileChooser.revalidate();
                jFileChooser.repaint();
            }
        }

        DetailViewActionListener() {
        }
    }
}

