/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.Access;
import gnu.bytecodecvssnap.Attribute;
import gnu.bytecodecvssnap.ClassType;
import gnu.bytecodecvssnap.ClassTypeWriter;
import gnu.bytecodecvssnap.ConstantPool;
import gnu.bytecodecvssnap.CpoolClass;
import gnu.bytecodecvssnap.CpoolEntry;
import gnu.bytecodecvssnap.CpoolUtf8;
import java.io.DataOutputStream;
import java.io.IOException;

public class InnerClassesAttr
extends Attribute {
    short count;
    short[] data;

    public int getLength() {
        return 2 + 8 * this.count;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.count);
        int n = 0;
        while (n < this.count) {
            dataOutputStream.writeShort(this.data[4 * n]);
            dataOutputStream.writeShort(this.data[4 * n + 1]);
            dataOutputStream.writeShort(this.data[4 * n + 2]);
            dataOutputStream.writeShort(this.data[4 * n + 3]);
            ++n;
        }
    }

    public void print(ClassTypeWriter classTypeWriter) {
        ClassType classType = (ClassType)this.container;
        ConstantPool constantPool = classType.getConstants();
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", count: ");
        classTypeWriter.println(this.count);
        int n = 0;
        while (n < this.count) {
            classTypeWriter.print("  ");
            int n2 = this.data[4 * n] & (char)-1;
            CpoolEntry cpoolEntry = constantPool.getForced(n2, 7);
            classTypeWriter.print(((CpoolClass)cpoolEntry).getStringName());
            classTypeWriter.print("; ");
            n2 = this.data[4 * n + 1] & (char)-1;
            if (n2 != 0) {
                classTypeWriter.print("Member of ");
                cpoolEntry = constantPool.getForced(n2, 7);
                classTypeWriter.print(((CpoolClass)cpoolEntry).getStringName());
            }
            classTypeWriter.print("; ");
            n2 = this.data[4 * n + 2] & (char)-1;
            if (n2 != 0) {
                cpoolEntry = constantPool.getForced(n2, 1);
                classTypeWriter.print(((CpoolUtf8)cpoolEntry).string);
            } else {
                classTypeWriter.print("(Anonymous)");
            }
            classTypeWriter.print(";");
            classTypeWriter.print(Access.toString(this.data[4 * n + 3] & (char)-1, 'C'));
            classTypeWriter.println();
            ++n;
        }
    }

    public InnerClassesAttr(ClassType classType) {
        super("InnerClasses");
        this.addToFrontOf(classType);
    }

    public InnerClassesAttr(short[] sArray, ClassType classType) {
        this(classType);
        this.count = (short)(sArray.length >> 2);
        this.data = sArray;
    }
}

