/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.codec.v4;

import java.io.IOException;
import org.apache.activemq.apollo.openwire.codec.BaseDataStreamMarshaller;
import org.apache.activemq.apollo.openwire.codec.BooleanStream;
import org.apache.activemq.apollo.openwire.codec.OpenWireFormat;
import org.apache.activemq.apollo.openwire.command.DataStructure;
import org.apache.activemq.apollo.openwire.command.PartialCommand;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;

public class PartialCommandMarshaller
extends BaseDataStreamMarshaller {
    public byte getDataStructureType() {
        return 60;
    }

    public DataStructure createObject() {
        return new PartialCommand();
    }

    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        PartialCommand info = (PartialCommand)o;
        info.setCommandId(dataIn.readInt());
        info.setData(this.tightUnmarshalByteArray(dataIn, bs));
    }

    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        PartialCommand info = (PartialCommand)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return (rc += this.tightMarshalByteArray1(info.getData(), bs)) + 4;
    }

    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        PartialCommand info = (PartialCommand)o;
        dataOut.writeInt(info.getCommandId());
        this.tightMarshalByteArray2(info.getData(), dataOut, bs);
    }

    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        PartialCommand info = (PartialCommand)o;
        info.setCommandId(dataIn.readInt());
        info.setData(this.looseUnmarshalByteArray(dataIn));
    }

    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut) throws IOException {
        PartialCommand info = (PartialCommand)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getCommandId());
        this.looseMarshalByteArray(wireFormat, info.getData(), dataOut);
    }
}

