#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <util.h>
#include <sys/ioctl.h>
#include <sys/types.h>

main(int argc, char **argv)
{
	int r, w;
	char name[20];
	char rbuf[BUFSIZ];
	fd_set rd, wr;
	int rsize;
	
	if ((r = open(argv[1], O_RDONLY, 0)) < 0) {
		perror(argv[1]);
		exit(1);
	}
	if ((w = open(argv[2], O_WRONLY | O_TRUNC | O_CREAT, 0644)) < 0) {
		perror(argv[1]);
		exit(1);
	}
	
	
	while(1) {
		FD_ZERO(&rd);
		FD_ZERO(&wr);
		FD_SET(0, &rd);
		FD_SET(1, &wr);
		if (select(1+1, &rd, &wr, NULL, NULL) < 0) {
			perror("select");
		}
		if (FD_ISSET(1, &wr)) {
			rsize=read(r, rbuf, 1);
			if (rsize >= 1)
				write(1, rbuf, 1);
			fsync(1);
		}
		if (FD_ISSET(0, &rd)) {
			rsize = read(0, rbuf, BUFSIZ);
			if (rsize < 0) {
				perror("read");
			} else if (rsize == 0) {
				continue;
			} else if (rsize > 0) {
				write(w, rbuf, rsize);
			}
		}
	}
}
