/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.compression;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.campagnelab.goby.compression.ChunkCodec;
import org.campagnelab.goby.compression.ProtobuffCollectionHandler;

public class NotCompressedChunkCodec
implements ChunkCodec {
    private ProtobuffCollectionHandler parser;
    public static final byte REGISTRATION_CODE = -6;

    @Override
    public void setHandler(ProtobuffCollectionHandler parser) {
        this.parser = parser;
    }

    @Override
    public boolean validate(byte c, DataInputStream input) {
        return true;
    }

    @Override
    public String name() {
        return "no-compression";
    }

    @Override
    public byte registrationCode() {
        return -6;
    }

    @Override
    public ByteArrayOutputStream encode(Message readCollection) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(10000);
        readCollection.writeTo((OutputStream)byteBuffer);
        byteBuffer.flush();
        byteBuffer.close();
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message decode(byte[] bytes) throws IOException {
        try (ByteArrayInputStream uncompressStream = new ByteArrayInputStream(bytes);){
            GeneratedMessage generatedMessage = this.parser.parse(uncompressStream);
            return generatedMessage;
        }
    }

    @Override
    public int getSuggestedChunkSize() {
        return 10000;
    }
}

