/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    private final String fileName;
    private final int lineNumber;
    private final String declaringClass;
    private final String methodName;
    private final transient boolean isNative;

    public final String getFileName() {
        return this.fileName;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final String getClassName() {
        return this.declaringClass;
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final boolean isNativeMethod() {
        return this.isNative;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.declaringClass != null) {
            stringBuffer.append(this.declaringClass);
            if (this.methodName != null) {
                stringBuffer.append('.');
            }
        }
        if (this.methodName != null) {
            stringBuffer.append(this.methodName);
        }
        stringBuffer.append(" (");
        if (this.fileName != null) {
            stringBuffer.append(this.fileName);
        } else {
            stringBuffer.append(this.isNative ? "Native Method" : "Unknown Source");
        }
        if (this.lineNumber >= 0) {
            stringBuffer.append(':').append(this.lineNumber);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement stackTraceElement = (StackTraceElement)object;
        boolean bl = false;
        if (StackTraceElement.equals(this.fileName, stackTraceElement.fileName) && this.lineNumber == stackTraceElement.lineNumber && StackTraceElement.equals(this.declaringClass, stackTraceElement.declaringClass) && StackTraceElement.equals(this.methodName, stackTraceElement.methodName)) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return StackTraceElement.hashCode(this.fileName) ^ this.lineNumber ^ StackTraceElement.hashCode(this.declaringClass) ^ StackTraceElement.hashCode(this.methodName);
    }

    private static final boolean equals(Object object, Object object2) {
        boolean bl;
        if (object == null) {
            bl = false;
            if (object2 == null) {
                bl = true;
            }
        } else {
            bl = object.equals(object2);
        }
        return bl;
    }

    private static final int hashCode(Object object) {
        int n = 0;
        if (object != null) {
            n = object.hashCode();
        }
        return n;
    }

    StackTraceElement(String string, int n, String string2, String string3, boolean bl) {
        this.fileName = string;
        this.lineNumber = n;
        this.declaringClass = string2;
        this.methodName = string3;
        this.isNative = bl;
    }

    public StackTraceElement(String string, String string2, String string3, int n) {
        boolean bl = false;
        if (n == -2) {
            bl = true;
        }
        this(string3, n, string, string2, bl);
        if (string == null || string2 == null) {
            throw new NullPointerException("invalid argument to constructor");
        }
    }
}

