/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;

public class BasicMenuBarUI
extends MenuBarUI {
    protected ChangeListener changeListener = this.createChangeListener();
    protected ContainerListener containerListener = this.createContainerListener();
    private PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    protected JMenuBar menuBar;
    private MouseInputListener mouseListener = new MouseInputHandler();

    protected ChangeListener createChangeListener() {
        return new ChangeHandler();
    }

    protected ContainerListener createContainerListener() {
        return new ContainerHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuBarUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.menuBar, "MenuBar.border");
        LookAndFeel.installColorsAndFont(this.menuBar, "MenuBar.background", "MenuBar.foreground", "MenuBar.font");
        this.menuBar.setOpaque(true);
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.menuBar.addContainerListener(this.containerListener);
        this.menuBar.addPropertyChangeListener(this.propertyChangeListener);
        this.menuBar.addMouseListener(this.mouseListener);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.menuBar = (JMenuBar)jComponent;
        this.menuBar.setLayout(new BoxLayout(this.menuBar, 0));
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void uninstallDefaults() {
        this.menuBar.setBackground(null);
        this.menuBar.setBorder(null);
        this.menuBar.setFont(null);
        this.menuBar.setForeground(null);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.menuBar.removeContainerListener(this.containerListener);
        this.menuBar.removePropertyChangeListener(this.propertyChangeListener);
        this.menuBar.removeMouseListener(this.mouseListener);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuBar = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
        }

        private ChangeHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ContainerHandler
    implements ContainerListener {
        public void componentAdded(ContainerEvent containerEvent) {
            BasicMenuBarUI.this.menuBar.revalidate();
            BasicMenuBarUI.this.menuBar.repaint();
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            BasicMenuBarUI.this.menuBar.revalidate();
            BasicMenuBarUI.this.menuBar.repaint();
        }

        private ContainerHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("borderPainted")) {
                BasicMenuBarUI.this.menuBar.repaint();
            }
            if (propertyChangeEvent.getPropertyName().equals("margin")) {
                BasicMenuBarUI.this.menuBar.repaint();
            }
        }

        private PropertyChangeHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            MenuElement[] menuElementArray = BasicMenuBarUI.this.menuBar.getSubElements();
            int n = 0;
            while (n < menuElementArray.length) {
                JMenu jMenu = BasicMenuBarUI.this.menuBar.getMenu(n);
                if (jMenu != null) {
                    jMenu.setSelected(false);
                }
                ++n;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        private MouseInputHandler() {
        }
    }
}

