import rox
from rox import g, OptionsBox
from rox.options import Option
from rcfile import Opt, OptionGroupRC, update_options

### TODO:
###
### A special widget for button layout? (drag and drop of symbols)
###

app_name = 'OroboROX'

def build_mytoggle(box, node, label, option):
	toggle = g.CheckButton(label)
	box.may_add_tip(toggle, node)
	def get():
		if toggle.get_active():
			return 'true'
		else:
			return 'false'
	def set():
		if option.value == 'true':
			toggle.set_active(True)
		else:
			toggle.set_active(False)
		
	box.handlers[option] = (get, set)
	toggle.connect('toggled', lambda w: box.check_widget(option))
	return [toggle]

OptionsBox.widget_registry['mytoggle'] = build_mytoggle

rox.app_options = OptionGroupRC(app_name,'workspacerc')

Opt('workspace_count')
Opt('cycle_workspaces')
Opt('wrap_workspaces')

#Opt('next_workspace_key')
#Opt('prev_workspace_key')
#Opt('add_workspace_key')
#Opt('del_workspace_key')
#Opt('workspace_1_key')
#Opt('workspace_2_key')
#Opt('workspace_3_key')
#Opt('workspace_4_key')
#Opt('workspace_5_key')
#Opt('workspace_6_key')
#Opt('workspace_7_key')
#Opt('workspace_8_key')
#Opt('workspace_9_key')
#Opt('move_window_next_workspace_key')
#Opt('move_window_prev_workspace_key')
#Opt('move_window_workspace_1_key')
#Opt('move_window_workspace_2_key')
#Opt('move_window_workspace_3_key')
#Opt('move_window_workspace_4_key')
#Opt('move_window_workspace_5_key')
#Opt('move_window_workspace_6_key')
#Opt('move_window_workspace_7_key')
#Opt('move_window_workspace_8_key')
#Opt('move_window_workspace_9_key')

rox.app_options.add_notify(update_options)
rox.app_options.notify()
rox.edit_options()
