require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NETIPSEC_IPSEC_H_)) {
    eval 'sub _NETIPSEC_IPSEC_H_ () {1;}' unless defined(&_NETIPSEC_IPSEC_H_);
    if(defined(&_KERNEL_OPT)) {
	require './netipsec/opt_inet.ph';
	require './netipsec/opt_ipsec.ph';
    }
    require 'net/pfkeyv2.ph';
    if(defined(&_KERNEL)) {
	require 'sys/socketvar.ph';
	require 'sys/localcount.ph';
	require 'netinet/in_pcb_hdr.ph';
	require 'netipsec/keydb.ph';
	eval 'sub IPSEC_SPSTATE_DEAD () {0;}' unless defined(&IPSEC_SPSTATE_DEAD);
	eval 'sub IPSEC_SPSTATE_ALIVE () {1;}' unless defined(&IPSEC_SPSTATE_ALIVE);
	eval 'sub IPSEC_SPORIGIN_USER () {0;}' unless defined(&IPSEC_SPORIGIN_USER);
	eval 'sub IPSEC_SPORIGIN_KERNEL () {1;}' unless defined(&IPSEC_SPORIGIN_KERNEL);
	eval 'sub IPSEC_PCBHINT_UNKNOWN () {0;}' unless defined(&IPSEC_PCBHINT_UNKNOWN);
	eval 'sub IPSEC_PCBHINT_YES () {1;}' unless defined(&IPSEC_PCBHINT_YES);
	eval 'sub IPSEC_PCBHINT_NO () {2;}' unless defined(&IPSEC_PCBHINT_NO);
	eval 'sub IPSEC_PCBSP_CONNECTED () {1;}' unless defined(&IPSEC_PCBSP_CONNECTED);
	eval 'sub ipsec_pcb_skip_ipsec {
	    my($pcbsp,$dir) = @_;
    	    eval q({  &KASSERT( &inph_locked( ($pcbsp->{sp_inph})));  ($pcbsp->{sp_cache[&(dir)]}->{cachehint}) ==  &IPSEC_PCBHINT_NO  &&  ($pcbsp->{sp_cache[&(dir)]}->{cachegen}) ==  &ipsec_spdgen; });
	}' unless defined(&ipsec_pcb_skip_ipsec);
    }
    eval 'sub IPSEC_ADDRSTRLEN () {( &INET6_ADDRSTRLEN + 11);}' unless defined(&IPSEC_ADDRSTRLEN);
    eval 'sub IPSEC_LOGSASTRLEN () {192;}' unless defined(&IPSEC_LOGSASTRLEN);
    eval 'sub IPSEC_PORT_ANY () {0;}' unless defined(&IPSEC_PORT_ANY);
    eval 'sub IPSEC_ULPROTO_ANY () {255;}' unless defined(&IPSEC_ULPROTO_ANY);
    eval 'sub IPSEC_PROTO_ANY () {255;}' unless defined(&IPSEC_PROTO_ANY);
    eval 'sub IPSEC_MODE_ANY () {0;}' unless defined(&IPSEC_MODE_ANY);
    eval 'sub IPSEC_MODE_TRANSPORT () {1;}' unless defined(&IPSEC_MODE_TRANSPORT);
    eval 'sub IPSEC_MODE_TUNNEL () {2;}' unless defined(&IPSEC_MODE_TUNNEL);
    eval 'sub IPSEC_MODE_TCPMD5 () {3;}' unless defined(&IPSEC_MODE_TCPMD5);
    eval 'sub IPSEC_DIR_ANY () {0;}' unless defined(&IPSEC_DIR_ANY);
    eval 'sub IPSEC_DIR_INBOUND () {1;}' unless defined(&IPSEC_DIR_INBOUND);
    eval 'sub IPSEC_DIR_OUTBOUND () {2;}' unless defined(&IPSEC_DIR_OUTBOUND);
    eval 'sub IPSEC_DIR_MAX () {3;}' unless defined(&IPSEC_DIR_MAX);
    eval 'sub IPSEC_DIR_INVALID () {4;}' unless defined(&IPSEC_DIR_INVALID);
    eval 'sub IPSEC_DIR_IS_VALID {
        my($dir) = @_;
	    eval q((($dir) >= 0 && ($dir) <=  &IPSEC_DIR_MAX));
    }' unless defined(&IPSEC_DIR_IS_VALID);
    eval 'sub IPSEC_DIR_IS_INOROUT {
        my($dir) = @_;
	    eval q((($dir) ==  &IPSEC_DIR_INBOUND || ($dir) ==  &IPSEC_DIR_OUTBOUND));
    }' unless defined(&IPSEC_DIR_IS_INOROUT);
    eval 'sub IPSEC_POLICY_DISCARD () {0;}' unless defined(&IPSEC_POLICY_DISCARD);
    eval 'sub IPSEC_POLICY_NONE () {1;}' unless defined(&IPSEC_POLICY_NONE);
    eval 'sub IPSEC_POLICY_IPSEC () {2;}' unless defined(&IPSEC_POLICY_IPSEC);
    eval 'sub IPSEC_POLICY_ENTRUST () {3;}' unless defined(&IPSEC_POLICY_ENTRUST);
    eval 'sub IPSEC_POLICY_BYPASS () {4;}' unless defined(&IPSEC_POLICY_BYPASS);
    eval 'sub IPSEC_LEVEL_DEFAULT () {0;}' unless defined(&IPSEC_LEVEL_DEFAULT);
    eval 'sub IPSEC_LEVEL_USE () {1;}' unless defined(&IPSEC_LEVEL_USE);
    eval 'sub IPSEC_LEVEL_REQUIRE () {2;}' unless defined(&IPSEC_LEVEL_REQUIRE);
    eval 'sub IPSEC_LEVEL_UNIQUE () {3;}' unless defined(&IPSEC_LEVEL_UNIQUE);
    eval 'sub IPSEC_MANUAL_REQID_MAX () {0x3fff;}' unless defined(&IPSEC_MANUAL_REQID_MAX);
    eval 'sub IPSEC_REPLAYWSIZE () {32;}' unless defined(&IPSEC_REPLAYWSIZE);
    if(defined(&_KERNEL)) {
	if(defined(&IPSEC_DEBUG)) {
	}
	require 'sys/syslog.ph';
	eval 'sub DPRINTF () {( &fmt,  &args...)  &do {  &if ( &ipsec_debug)  &log( &LOG_DEBUG, "%s: "  &fmt,  &__func__,  &args); }  &while ( 0);}' unless defined(&DPRINTF);
	eval 'sub IPSECLOG () {( &level,  &fmt,  &args...)  &do {  &if ( &ipsec_debug)  &log( &level, "%s: "  &fmt,  &__func__,  &args); }  &while ( 0);}' unless defined(&IPSECLOG);
	eval 'sub ipsec_indone {
	    my($m) = @_;
    	    eval q((( ($m->{m_flags}) &  &M_AUTHIPHDR) || ( ($m->{m_flags}) &  &M_DECRYPTED)));
	}' unless defined(&ipsec_indone);
	eval 'sub ipsec_outdone {
	    my($m) = @_;
    	    eval q(( &m_tag_find(($m),  &PACKET_TAG_IPSEC_OUT_DONE) !=  &NULL));
	}' unless defined(&ipsec_outdone);
	eval 'sub ipsec_skip_pfil {
	    my($m) = @_;
    	    eval q({  &bool  &rv;  &if ( &ipsec_indone($m)  && (( ($m->{m_pkthdr}->{pkthdr_flags}) &  &PKTHDR_FLAG_IPSEC_SKIP_PFIL) != 0)) {  ($m->{m_pkthdr}->{pkthdr_flags}) &= ~ &PKTHDR_FLAG_IPSEC_SKIP_PFIL;  &rv =  &true; }  &else {  &rv =  &false; }  &rv; });
	}' unless defined(&ipsec_skip_pfil);
	if(defined(&INET6)) {
	}
    }
    unless(defined(&_KERNEL)) {
    }
    if(defined(&_KERNEL)) {
	if(defined(&INET6)) {
	}
    }
}
1;
