/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public abstract class HttpHeader
implements Serializable {
    public static final String CRLF = "\r\n";
    public static final String LF = "\n";
    public static final String CONTENT_LENGTH = "Content-length";
    public static final String TRANSFER_ENCODING = "Transfer-encoding";
    public static final String CONTENT_ENCODING = "Content-encoding";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String PROXY_CONNECTION = "Proxy-Connection";
    public static final String PROXY_AUTHENTICATE = "Proxy-authenticate";
    public static final String CONNECTION = "Connection";
    public static final String AUTHORIZATION = "Authorization";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String LOCATION = "Location";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String USER_AGENT = "User-Agent";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String CACHE_CONTROL = "Cache-control";
    public static final String PRAGMA = "Pragma";
    public static final String REFERER = "Referer";
    public static final String HTTP09 = "HTTP/0.9";
    public static final String HTTP10 = "HTTP/1.0";
    public static final String HTTP11 = "HTTP/1.1";
    public static final String _CLOSE = "Close";
    public static final String _KEEP_ALIVE = "Keep-alive";
    public static final String _CHUNKED = "Chunked";
    public static final String SCHEME_HTTP = "http://";
    public static final String SCHEME_HTTPS = "https://";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final Pattern patternCRLF = Pattern.compile("\\r\\n", 8);
    public static final Pattern patternLF = Pattern.compile("\\n", 8);
    private static final Pattern patternCharset = Pattern.compile("charset *= *([^;\\s]+)", 2);
    protected static final String p_TEXT = "[^\\x00-\\x1f\\r\\n]*";
    protected static final String p_METHOD = "(\\w+)";
    protected static final String p_SP = " +";
    protected static final String p_URI = "([^\\r\\n]+)";
    protected static final String p_VERSION = "(HTTP/\\d+\\.\\d+)";
    protected static final String p_STATUS_CODE = "(\\d{3})";
    protected static final String p_REASON_PHRASE = "([^\\x00-\\x1f\\r\\n]*)";
    protected String mStartLine = "";
    protected String mMsgHeader = "";
    protected boolean mMalformedHeader = false;
    protected Hashtable mHeaderFields = new Hashtable();
    protected int mContentLength = -1;
    protected String mLineDelimiter = "\r\n";
    protected String mVersion = "";

    public HttpHeader() {
        this.init();
    }

    public HttpHeader(String string) throws HttpMalformedHeaderException {
        this();
        this.setMessage(string);
    }

    private void init() {
        this.mHeaderFields = new Hashtable();
        this.mStartLine = "";
        this.mMsgHeader = "";
        this.mMalformedHeader = false;
        this.mContentLength = -1;
        this.mLineDelimiter = CRLF;
        this.mVersion = "";
    }

    public void setMessage(String string) throws HttpMalformedHeaderException {
        this.init();
        this.mMsgHeader = string;
        try {
            if (!this.parse(string)) {
                this.mMalformedHeader = true;
            }
        }
        catch (Exception exception) {
            this.mMalformedHeader = true;
        }
        if (this.mMalformedHeader) {
            throw new HttpMalformedHeaderException();
        }
    }

    public void clear() {
        this.init();
    }

    public String getHeader(String string) {
        Vector vector = this.getHeaders(string);
        if (vector == null) {
            return null;
        }
        return (String)vector.firstElement();
    }

    public Vector getHeaders(String string) {
        Vector vector = (Vector)this.mHeaderFields.get(string.toUpperCase());
        return vector;
    }

    public void addHeader(String string, String string2) {
        this.mMsgHeader = this.mMsgHeader + string + ": " + string2 + this.mLineDelimiter;
        this.addInternalHeaderFields(string, string2);
    }

    public void setHeader(String string, String string2) {
        Pattern pattern = null;
        if (this.getHeaders(string) == null && string2 != null) {
            this.addHeader(string, string2);
        } else {
            try {
                pattern = this.getHeaderRegex(string);
                Matcher matcher = pattern.matcher(this.mMsgHeader);
                if (string2 == null) {
                    this.mMsgHeader = matcher.replaceAll("");
                } else {
                    String string3 = string + ": " + string2 + this.mLineDelimiter;
                    this.mMsgHeader = matcher.replaceAll(string3);
                }
                this.replaceInternalHeaderFields(string, string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Pattern getHeaderRegex(String string) throws PatternSyntaxException {
        return Pattern.compile("^ *" + string + " *: *[^\\r\\n]*" + this.mLineDelimiter, 10);
    }

    public String getVersion() {
        return this.mVersion;
    }

    public abstract void setVersion(String var1);

    public int getContentLength() {
        return this.mContentLength;
    }

    public void setContentLength(int n) {
        if (this.mContentLength != n) {
            this.setHeader(CONTENT_LENGTH, Integer.toString(n));
            this.mContentLength = n;
        }
    }

    public boolean isConnectionClose() {
        boolean bl = true;
        if (this.mMalformedHeader) {
            return true;
        }
        if (this.isHttp10()) {
            bl = true;
            try {
                if (this.getHeader(CONNECTION).equalsIgnoreCase(_KEEP_ALIVE) || this.getHeader(PROXY_CONNECTION).equalsIgnoreCase(_KEEP_ALIVE)) {
                    return false;
                }
            }
            catch (NullPointerException nullPointerException) {}
        } else if (this.isHttp11()) {
            bl = false;
            try {
                if (this.getHeader(CONNECTION).equalsIgnoreCase(_CLOSE)) {
                    return true;
                }
                if (this.getHeader(PROXY_CONNECTION).equalsIgnoreCase(_CLOSE)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean isHttp10() {
        return this.mVersion.equalsIgnoreCase(HTTP10);
    }

    public boolean isHttp11() {
        return this.mVersion.equalsIgnoreCase(HTTP11);
    }

    public boolean isTransferEncodingChunked() {
        String string = this.getHeader(TRANSFER_ENCODING);
        return string != null && string.equalsIgnoreCase(_CHUNKED);
    }

    protected boolean parse(String string) throws Exception {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        Pattern pattern = null;
        if (string == null || string.equals("")) {
            return true;
        }
        n = string.indexOf(CRLF);
        if (n < 0) {
            n = string.indexOf(LF);
            if (n < 0) {
                return false;
            }
            this.mLineDelimiter = LF;
            pattern = patternLF;
        } else {
            this.mLineDelimiter = CRLF;
            pattern = patternCRLF;
        }
        String[] stringArray = pattern.split(string);
        this.mStartLine = stringArray[0];
        StringBuffer stringBuffer = new StringBuffer(2048);
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            if (string2.equals("")) continue;
            n = string2.indexOf(":");
            if (n < 0) {
                this.mMalformedHeader = true;
                return false;
            }
            string3 = string2.substring(0, n).trim();
            string4 = string2.substring(n + 1).trim();
            if (string3.equalsIgnoreCase(CONTENT_LENGTH)) {
                try {
                    this.mContentLength = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            stringBuffer.append(string3 + ": " + string4 + this.mLineDelimiter);
            this.addInternalHeaderFields(string3, string4);
        }
        this.mMsgHeader = stringBuffer.toString();
        return true;
    }

    private void replaceInternalHeaderFields(String string, String string2) {
        String string3 = string.toUpperCase();
        Vector<String> vector = this.getHeaders(string3);
        if (vector == null) {
            vector = new Vector<String>();
            this.mHeaderFields.put(string3, vector);
        }
        if (string2 != null) {
            vector.clear();
            vector.add(string2);
        } else {
            this.mHeaderFields.remove(string3);
        }
    }

    private void addInternalHeaderFields(String string, String string2) {
        String string3 = string.toUpperCase();
        Vector<String> vector = this.getHeaders(string3);
        if (vector == null) {
            vector = new Vector<String>();
            this.mHeaderFields.put(string3, vector);
        }
        if (string2 != null) {
            vector.add(string2);
        } else {
            this.mHeaderFields.remove(string3);
        }
    }

    public boolean isMalformedHeader() {
        return this.mMalformedHeader;
    }

    public String toString() {
        return this.getPrimeHeader() + this.mLineDelimiter + this.mMsgHeader + this.mLineDelimiter;
    }

    public abstract String getPrimeHeader();

    public boolean isImage() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public String getLineDelimiter() {
        return this.mLineDelimiter;
    }

    public String getHeadersAsString() {
        return this.mMsgHeader;
    }

    public boolean isEmpty() {
        return this.mMsgHeader == null || this.mMsgHeader.equals("");
    }

    public String getCharset() {
        String string = this.getHeader(CONTENT_TYPE);
        String string2 = "";
        if (string == null) {
            return null;
        }
        Matcher matcher = patternCharset.matcher(string);
        if (matcher.find()) {
            string2 = matcher.group(1);
        }
        return string2;
    }
}

