/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.bean.ReqEntityByteArray;
import org.wiztools.restclient.bean.ReqEntityFile;
import org.wiztools.restclient.bean.ReqEntitySimple;
import org.wiztools.restclient.bean.ReqEntityStream;
import org.wiztools.restclient.bean.ReqEntityString;

class HTTPClientUtil {
    private static final Logger LOG = Logger.getLogger(HTTPClientUtil.class.getName());

    HTTPClientUtil() {
    }

    private static void appendHttpEntity(StringBuilder sb, HttpEntity e) {
        try {
            InputStream is = e.getContent();
            String encoding = e.getContentEncoding().getValue();
            System.out.println(encoding);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.forName(encoding)));
            String str = null;
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            br.close();
        }
        catch (IOException ex) {
            LOG.severe(ex.getMessage());
        }
    }

    static String getHTTPRequestTrace(HttpRequest request) {
        HttpEntityEnclosingRequest r;
        HttpEntity e;
        StringBuilder sb = new StringBuilder();
        sb.append(request.getRequestLine());
        sb.append('\n');
        for (Header h2 : request.getAllHeaders()) {
            sb.append(h2.getName()).append(": ").append(h2.getValue()).append('\n');
        }
        sb.append('\n');
        if (request instanceof HttpEntityEnclosingRequest && (e = (r = (HttpEntityEnclosingRequest)request).getEntity()) != null) {
            HTTPClientUtil.appendHttpEntity(sb, e);
        }
        return sb.toString();
    }

    static String getHTTPResponseTrace(HttpResponse response) {
        StringBuilder sb = new StringBuilder();
        sb.append(response.getStatusLine()).append('\n');
        for (Header h2 : response.getAllHeaders()) {
            sb.append(h2.getName()).append(": ").append(h2.getValue()).append('\n');
        }
        sb.append('\n');
        HttpEntity e = response.getEntity();
        if (e != null) {
            HTTPClientUtil.appendHttpEntity(sb, e);
        }
        return sb.toString();
    }

    static AbstractHttpEntity getEntity(ReqEntitySimple bean) throws UnsupportedEncodingException, IOException {
        AbstractHttpEntity entity = null;
        org.apache.http.entity.ContentType contentType = null;
        if (bean.getContentType() != null) {
            ContentType ct = bean.getContentType();
            contentType = org.apache.http.entity.ContentType.create(ct.getContentType(), ct.getCharset());
        }
        if (bean instanceof ReqEntityString) {
            entity = new StringEntity(((ReqEntityString)bean).getBody(), contentType);
        } else if (bean instanceof ReqEntityByteArray) {
            entity = new ByteArrayEntity(((ReqEntityByteArray)bean).getBody(), contentType);
        } else if (bean instanceof ReqEntityStream) {
            entity = new InputStreamEntity(((ReqEntityStream)bean).getBody(), ((ReqEntityStream)bean).getLength(), contentType);
        } else if (bean instanceof ReqEntityFile) {
            entity = new FileEntity(((ReqEntityFile)bean).getBody(), contentType);
        }
        return entity;
    }

    public static org.apache.http.entity.ContentType getContentType(ContentType ct) {
        return org.apache.http.entity.ContentType.create(ct.getContentType(), ct.getCharset());
    }
}

