# -*- encoding: utf-8 -*-

require File.dirname(__FILE__) + '/helper.rb'

class TestPallet < Test::Unit::TestCase

  module MyPallet
    extend Color::RGB::JP::Base::Pallet

    Foo = define_color("Foo", "abcdef", "風雨", "ふー", "フー", "foo")
    Bar_A = define_color("Bar_A", "ff00bb", "馬嗚呼", "ばー", "バー", "ba-r")
    Bar_B = define_color("Bar_B", "ff00bb", "葉嗚呼", "ばー", "バー", "ba-r")
  end

  module MySakura
    extend Color::RGB::JP::Base::Pallet

    SakuraIro = c("SakuraIro",
                  "aabbcc",
                  Fixture::UTF_8::SakuraIroKanji,
                  Fixture::UTF_8::SakuraIroHiragana,
                  Fixture::UTF_8::SakuraIroKatakana,
                  "sakura-iro")
  end

  def test_colors
    assert_equal(3, MyPallet.colors.size)
    assert_equal("Foo", MyPallet.colors[0].name.const_name)
    assert_equal("Bar_A", MyPallet.colors[1].name.const_name)
    assert_equal("Bar_B", MyPallet.colors[2].name.const_name)
  end

  def test_each
    t = %W(Foo Bar_A Bar_B)
    MyPallet.each do |c|
      assert_equal(t.first ,c.name.const_name)
      t.shift
    end
  end

  def test_enumerable
    r = MyPallet.find_all {|e| e.name.romaji =~ /f/}
    assert_equal(1, r.length)
    assert_equal(MyPallet::Foo, r.first)
  end

  def test_bracket
    assert_equal(MyPallet::Foo, MyPallet["foo"])

    assert_equal(MyPallet::Bar_A, MyPallet["ba-r"])
    assert_equal(MyPallet::Bar_A, MyPallet["ばー"])
    assert_equal(MyPallet::Bar_A, MyPallet["バー"])

    assert_equal(MyPallet::Bar_A, MyPallet["Bar_A"])
    assert_equal(MyPallet::Bar_B, MyPallet["Bar_B"])

    assert_equal(MyPallet::Bar_A, MyPallet["馬嗚呼"])
    assert_equal(MyPallet::Bar_B, MyPallet["葉嗚呼"])
  end

  def test_bracket_2
    assert_equal(MyPallet::Bar_A, MyPallet["BAR"])
    assert_equal(MyPallet::Bar_A, MyPallet["b-a-r-----"])
  end

  def test_bracket_sjis
    assert_equal(MySakura::SakuraIro, MySakura[Fixture::Shift_JIS::SakuraIroKanji, "Shift_JIS"])
    assert_equal(MySakura::SakuraIro, MySakura[Fixture::Shift_JIS::SakuraIroHiragana, "Shift_JIS"])
    assert_equal(MySakura::SakuraIro, MySakura[Fixture::Shift_JIS::SakuraIroKatakana, "Shift_JIS"])
  end

  def test_bracket_eucjp
    assert_equal(MySakura::SakuraIro, MySakura[Fixture::EUC_JP::SakuraIroKanji, "EUC-JP"])
    assert_equal(MySakura::SakuraIro, MySakura[Fixture::EUC_JP::SakuraIroHiragana, "EUC-JP"])
    assert_equal(MySakura::SakuraIro, MySakura[Fixture::EUC_JP::SakuraIroKatakana, "EUC-JP"])
  end

end
