/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.text;

import gnu.java.text.BaseBreakIterator;
import java.text.CharacterIterator;

public class CharacterBreakIterator
extends BaseBreakIterator {
    private static final int LBase = 4352;
    private static final int VBase = 4449;
    private static final int TBase = 4519;
    private static final int LCount = 19;
    private static final int VCount = 21;
    private static final int TCount = 28;
    private static final int highSurrogateStart = 55296;
    private static final int highSurrogateEnd = 56319;
    private static final int lowSurrogateStart = 56320;
    private static final int lowSurrogateEnd = 57343;

    public Object clone() {
        return new CharacterBreakIterator(this);
    }

    private final boolean isL(char c) {
        boolean bl = false;
        if (c >= '\u1100' && c <= '\u1113') {
            bl = true;
        }
        return bl;
    }

    private final boolean isV(char c) {
        boolean bl = false;
        if (c >= '\u1161' && c <= '\u1176') {
            bl = true;
        }
        return bl;
    }

    private final boolean isT(char c) {
        boolean bl = false;
        if (c >= '\u11a7' && c <= '\u11c3') {
            bl = true;
        }
        return bl;
    }

    private final boolean isLVT(char c) {
        boolean bl = false;
        if (this.isL(c) || this.isV(c) || this.isT(c)) {
            bl = true;
        }
        return bl;
    }

    private final boolean isHighSurrogate(char c) {
        boolean bl = false;
        if (c >= '\ud800' && c <= '\udbff') {
            bl = true;
        }
        return bl;
    }

    private final boolean isLowSurrogate(char c) {
        boolean bl = false;
        if (c >= '\udc00' && c <= '\udfff') {
            bl = true;
        }
        return bl;
    }

    public int next() {
        int end = this.iter.getEndIndex();
        if (this.iter.getIndex() == end) {
            return -1;
        }
        char prev = (char)-1;
        while (this.iter.getIndex() < end) {
            int aheadType;
            int type;
            char c = this.iter.next();
            if (c == (char)-1 || (type = Character.getType(c)) == 14) break;
            char ahead = this.iter.next();
            this.iter.previous();
            if (ahead == (char)-1 || (aheadType = Character.getType(ahead)) != 6 && !this.isLowSurrogate(ahead) && !this.isLVT(ahead) || !this.isLVT(c) && this.isLVT(ahead) || this.isL(c) && !this.isLVT(ahead) && aheadType != 6 || this.isV(c) && !this.isV(ahead) && !this.isT(ahead) && aheadType != 6 || this.isT(c) && !this.isT(ahead) && aheadType != 6 || !this.isHighSurrogate(c) && this.isLowSurrogate(ahead) || this.isHighSurrogate(c) && !this.isLowSurrogate(ahead) || !this.isHighSurrogate(prev) && this.isLowSurrogate(c)) break;
            prev = c;
        }
        return this.iter.getIndex();
    }

    /*
     * Unable to fully structure code
     */
    public int previous() {
        if (this.iter.getIndex() != this.iter.getBeginIndex()) ** GOTO lbl15
        return -1;
        while ((c = this.iter.previous()) != (char)-1 && ((type = Character.getType(c)) == 6 || this.isLowSurrogate(c) || this.isLVT(c))) {
            ahead = this.iter.previous();
            if (ahead == (char)-1) {
                this.iter.next();
                break;
            }
            ahead2 = this.iter.previous();
            this.iter.next();
            this.iter.next();
            if (ahead2 == (char)-1 || (aheadType = Character.getType(ahead)) == 14 || this.isLVT(c) && !this.isLVT(ahead) || !this.isLVT(c) && type != 6 && this.isL(ahead) || !this.isV(c) && !this.isT(c) && type != 6 && this.isV(ahead) || !this.isT(c) && type != 6 && this.isT(ahead) || this.isLowSurrogate(c) && !this.isHighSurrogate(ahead) || !this.isLowSurrogate(c) && this.isHighSurrogate(ahead) || this.isLowSurrogate(ahead) && !this.isHighSurrogate(ahead2)) break;
lbl15:
            // 2 sources

            if (this.iter.getIndex() >= this.iter.getBeginIndex()) continue;
        }
        return this.iter.getIndex();
    }

    public CharacterBreakIterator() {
    }

    private CharacterBreakIterator(CharacterBreakIterator other) {
        this.iter = (CharacterIterator)other.iter.clone();
    }
}

