/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EventQueue {
    private static final int INITIAL_QUEUE_DEPTH = 8;
    private AWTEvent[] queue;
    private int next_in;
    private int next_out;
    private EventQueue next;
    private EventQueue prev;
    private AWTEvent currentEvent;
    private long lastWhen;
    private EventDispatchThread dispatchThread;
    private boolean shutdown;

    private final synchronized void setShutdown(boolean b) {
        this.shutdown = b;
    }

    synchronized boolean isShutdown() {
        if (this.shutdown) {
            return true;
        }
        if (this.peekEvent() == null) {
            Frame[] frames = Frame.getFrames();
            int i = 0;
            while (i < frames.length) {
                if (frames[i].isDisplayable()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized AWTEvent getNextEvent() throws InterruptedException {
        if (this.next == null) ** GOTO lbl6
        return this.next.getNextEvent();
lbl-1000:
        // 1 sources

        {
            if (this.isShutdown()) {
                throw new InterruptedException();
            }
            this.wait();
lbl6:
            // 2 sources

            ** while (this.next_in == this.next_out)
        }
lbl7:
        // 1 sources

        res = this.queue[this.next_out];
        if (++this.next_out == this.queue.length) {
            this.next_out = 0;
        }
        return res;
    }

    public synchronized AWTEvent peekEvent() {
        if (this.next != null) {
            return this.next.peekEvent();
        }
        if (this.next_in != this.next_out) {
            return this.queue[this.next_out];
        }
        return null;
    }

    public synchronized AWTEvent peekEvent(int id) {
        if (this.next != null) {
            return this.next.peekEvent(id);
        }
        int i = this.next_out;
        while (i != this.next_in) {
            AWTEvent qevt = this.queue[i];
            if (qevt.id != id) continue;
            return qevt;
        }
        return null;
    }

    public synchronized void postEvent(AWTEvent evt) {
        if (evt == null) {
            throw new NullPointerException();
        }
        if (this.next != null) {
            this.next.postEvent(evt);
            return;
        }
        int i = this.next_out;
        while (i != this.next_in) {
            Object src;
            AWTEvent qevt = this.queue[i];
            if (qevt.id == evt.id && (src = qevt.getSource()) == evt.getSource() && src instanceof Component) {
                Component srccmp = (Component)src;
                AWTEvent coalesced_evt = srccmp.coalesceEvents(qevt, evt);
                if (coalesced_evt == null) break;
                this.queue[i] = coalesced_evt;
                return;
            }
            if (++i != this.queue.length) continue;
            i = 0;
        }
        this.queue[this.next_in] = evt;
        if (++this.next_in == this.queue.length) {
            this.next_in = 0;
        }
        if (this.next_in == this.next_out) {
            AWTEvent[] oldQueue = this.queue;
            this.queue = new AWTEvent[this.queue.length * 2];
            int len = oldQueue.length - this.next_out;
            System.arraycopy(oldQueue, this.next_out, this.queue, 0, len);
            if (this.next_out != 0) {
                System.arraycopy(oldQueue, 0, this.queue, len, this.next_out);
            }
            this.next_out = 0;
            this.next_in = oldQueue.length;
        }
        if (this.dispatchThread == null || !this.dispatchThread.isAlive()) {
            this.dispatchThread = new EventDispatchThread(this);
            this.dispatchThread.start();
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Can't call invokeAndWait from event dispatch thread");
        }
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Thread current = Thread.currentThread();
        InvocationEvent ie = new InvocationEvent(eq, runnable, current, true);
        Thread thread = current;
        synchronized (thread) {
            eq.postEvent(ie);
            current.wait();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
            Exception exception = ie.getException();
            if (exception == null) return;
            throw new InvocationTargetException(exception);
        }
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        InvocationEvent ie = new InvocationEvent(eq, runnable, null, false);
        eq.postEvent(ie);
    }

    public static boolean isDispatchThread() {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (eq.next != null) {
            eq = eq.next;
        }
        boolean bl = false;
        if (Thread.currentThread() == eq.dispatchThread) {
            bl = true;
        }
        return bl;
    }

    public static AWTEvent getCurrentEvent() {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Thread ct = Thread.currentThread();
        while (ct != eq.dispatchThread) {
            if (eq.next == null) {
                return null;
            }
            eq = eq.next;
        }
        return eq.currentEvent;
    }

    public synchronized void push(EventQueue newEventQueue) {
        if (newEventQueue == null) {
            throw new NullPointerException();
        }
        if (this.next != null) {
            this.next.push(newEventQueue);
            return;
        }
        if (this.dispatchThread == null) {
            this.dispatchThread = new EventDispatchThread(this);
        }
        int i = this.next_out;
        while (i != this.next_in) {
            newEventQueue.postEvent(this.queue[i]);
            this.next_out = i++;
            if (i != this.queue.length) continue;
            i = 0;
        }
        this.next = newEventQueue;
        newEventQueue.prev = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void pop() throws EmptyStackException {
        if (this.prev == null) {
            throw new EmptyStackException();
        }
        EventQueue eventQueue = this.prev;
        synchronized (eventQueue) {
            this.prev.next = this.next;
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            EventQueue eventQueue2 = this;
            synchronized (eventQueue2) {
                int i = this.next_out;
                while (true) {
                    if (i == this.next_in) {
                        this.next_in = 0;
                        this.next_out = 0;
                        this.setShutdown(true);
                        this.dispatchThread = null;
                        this.notifyAll();
                        return;
                    }
                    this.prev.postEvent(this.queue[i]);
                    this.next_out = i++;
                    if (i != this.queue.length) continue;
                    i = 0;
                }
            }
        }
    }

    protected void dispatchEvent(AWTEvent evt) {
        this.currentEvent = evt;
        if (evt instanceof InputEvent) {
            this.lastWhen = ((InputEvent)evt).getWhen();
        } else if (evt instanceof ActionEvent) {
            this.lastWhen = ((ActionEvent)evt).getWhen();
        } else if (evt instanceof InvocationEvent) {
            this.lastWhen = ((InvocationEvent)evt).getWhen();
        }
        if (evt instanceof ActiveEvent) {
            ActiveEvent active_evt = (ActiveEvent)((Object)evt);
            active_evt.dispatch();
        } else {
            Object source = evt.getSource();
            if (source instanceof Component) {
                Component srccmp = (Component)source;
                srccmp.dispatchEvent(evt);
            } else if (source instanceof MenuComponent) {
                MenuComponent srccmp = (MenuComponent)source;
                srccmp.dispatchEvent(evt);
            }
        }
    }

    public static long getMostRecentEventTime() {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (Thread.currentThread() != eq.dispatchThread) {
            return System.currentTimeMillis();
        }
        return eq.lastWhen;
    }

    private final /* synthetic */ void this() {
        this.queue = new AWTEvent[8];
        this.next_in = 0;
        this.next_out = 0;
        this.lastWhen = System.currentTimeMillis();
        this.dispatchThread = new EventDispatchThread(this);
        this.shutdown = false;
    }

    public EventQueue() {
        this.this();
    }
}

