/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class KeyAgreement {
    private static final String SERVICE = "KeyAgreement";
    private KeyAgreementSpi kaSpi;
    private Provider provider;
    private String algorithm;
    private boolean virgin;

    public static final KeyAgreement getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] provs = Security.getProviders();
        String msg = algorithm;
        int i = 0;
        while (i < provs.length) {
            try {
                return KeyAgreement.getInstance(algorithm, provs[i]);
            }
            catch (NoSuchAlgorithmException nsae) {
                msg = nsae.getMessage();
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(msg);
    }

    public static final KeyAgreement getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return KeyAgreement.getInstance(algorithm, p);
    }

    public static final KeyAgreement getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new KeyAgreement((KeyAgreementSpi)Engine.getInstance(SERVICE, algorithm, provider), provider, algorithm);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() == null) {
                throw new NoSuchAlgorithmException(algorithm);
            }
            if (ite.getCause() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ite.getCause();
            }
            throw new NoSuchAlgorithmException(algorithm);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(algorithm);
        }
    }

    public final Key doPhase(Key key, boolean lastPhase) throws IllegalStateException, InvalidKeyException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.kaSpi.engineDoPhase(key, lastPhase);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.kaSpi.engineGenerateSecret();
    }

    public final int generateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.kaSpi.engineGenerateSecret(sharedSecret, offset);
    }

    public final SecretKey generateSecret(String algorithm) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.kaSpi.engineGenerateSecret(algorithm);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        this.init(key, new SecureRandom());
    }

    public final void init(Key key, SecureRandom random) throws InvalidKeyException {
        this.kaSpi.engineInit(key, random);
        this.virgin = false;
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.init(key, params, new SecureRandom());
    }

    public final void init(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.kaSpi.engineInit(key, params, random);
        this.virgin = false;
    }

    protected KeyAgreement(KeyAgreementSpi kaSpi, Provider provider, String algorithm) {
        this.kaSpi = kaSpi;
        this.provider = provider;
        this.algorithm = algorithm;
        this.virgin = true;
    }
}

