/* $Header: /usr/cvsroot/libutf/utf.h,v 1.2 2006/05/26 20:20:46 agc Exp $ */

/*
 * Copyright © 1996-2006 Alistair Crooks.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef UTF_H_
#define UTF_H_

/* a Unicode character */
typedef unsigned short	Rune;

enum {
	UTFmax = 3,		/* maximum bytes per Rune */
	Runesync = 0x21,	/* can't represent part of a UTF sequence */
	Runeself = 0xa0,	/* rune and UTF sequences are the same */
	Runeerror = 0x80	/* decoding error in UTF */
};

/* prototypes */
int runetochar(char *, Rune *);
int chartorune(Rune *, char *);
int runelen(long);
int fullrune(char *, int);
int utflen(char *);
int utfbytes(char *);
char *utfrune(char *, long);
char *utfrrune(char *, long);
char *utfutf(char *, char *);

int utfcmp(char *, char *);
int utfncmp(char *, char *, int);
int utfspan(char *, char *, int *);
int utfcspan(char *, char *, int *);
int priorrune(Rune *, char *);
char *utffindrune(char *, char *);
int runeutfncmp(Rune *, char *, int);
char *utfcpy(char *, char *);
char *utfncpy(char *, char *, int);
char *utflcpy(char *, char *, int);
int utf_snprintf(char *, int, char *, ...);
int utfnlen(char *, int);
char *utfcat(char *, char *);
char *utfncat(char *, char *, int);

int AsciiToNumber(char *, int, int);
int CharToNum(char *);
int CharToDec(unsigned char);
int UNICODE_isdigit(Rune);
int UNICODE_isletter(Rune);
int UNICODE_IsIdent(Rune);
Rune UNICODE_tolower(Rune);
Rune UNICODE_toupper(Rune);
int UNICODE_isalpha(Rune);
int UNICODE_isupper(Rune);
int UNICODE_islower(Rune);
int UNICODE_isnumber(Rune);
int UNICODE_isxdigit(Rune);
int UNICODE_isalnum(Rune);
int UNICODE_isspace(Rune);
int UNICODE_isblank(Rune);
int UNICODE_ispunct(Rune);
int UNICODE_isprint(Rune);
int UNICODE_iscntrl(Rune);
int UNICODE_isascii(Rune);
int UNICODE_isgraph(Rune);
int UNICODE_InRange(Rune, Rune, Rune);
int UNICODE_mixed_strncmp(Rune *, char *, int);
int UNICODE_strcasecmp(Rune *, Rune *);
int UNICODE_strlen(Rune *);
Rune *UNICODE_strcat(Rune *, Rune *);
Rune *UNICODE_strchr(Rune *, Rune);
int UNICODE_strcmp(Rune *, Rune *);
Rune *UNICODE_strcpy(Rune *, Rune *);
int UNICODE_strcspn(Rune *, Rune *);
Rune *UNICODE_strdup(Rune *);
int UNICODE_strncasecmp(Rune *, Rune *, int);
Rune *UNICODE_strncat(Rune *, Rune *, int);
int UNICODE_strncmp(Rune *, Rune *, int);
Rune *UNICODE_strncpy(Rune *, Rune *, int);
Rune *UNICODE_strpbrk(Rune *, Rune *);
Rune *UNICODE_strrchr(Rune *, Rune);
int UNICODE_strspn(Rune *, Rune *);
Rune *UNICODE_strstr(Rune *, Rune *);

int urecollseq(char *);
int utflangcmp(char *, char *, char *, int);

#endif /* ! UTF_H_ */
