/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BasicButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener,
PropertyChangeListener {
    public void propertyChange(PropertyChangeEvent e) {
    }

    protected void checkOpacity(AbstractButton b) {
    }

    public void focusGained(FocusEvent e) {
        AbstractButton button;
        if (e.getSource() instanceof AbstractButton && (button = (AbstractButton)e.getSource()).isFocusPainted()) {
            button.repaint();
        }
    }

    public void focusLost(FocusEvent e) {
        AbstractButton button;
        if (e.getSource() instanceof AbstractButton && (button = (AbstractButton)e.getSource()).isFocusPainted()) {
            button.repaint();
        }
    }

    public void installKeyboardActions(JComponent c) {
        c.getActionMap().put("pressed", new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                AbstractButton button = (AbstractButton)e.getSource();
                ButtonModel model = button.getModel();
                model.setArmed(true);
                model.setPressed(true);
            }
        });
        c.getActionMap().put("released", new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                AbstractButton button = (AbstractButton)e.getSource();
                ButtonModel model = button.getModel();
                model.setPressed(false);
                model.setArmed(false);
            }
        });
    }

    public void uninstallKeyboardActions(JComponent c) {
        c.getActionMap().put("pressed", null);
        c.getActionMap().put("released", null);
    }

    public void stateChanged(ChangeEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)e.getSource();
            ButtonModel model = button.getModel();
            if (e.getButton() == 1) {
                model.setArmed(true);
                model.setPressed(true);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)e.getSource();
            ButtonModel model = button.getModel();
            if (e.getButton() == 1) {
                model.setPressed(false);
                model.setArmed(false);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)e.getSource();
            ButtonModel model = button.getModel();
            if (button.isRolloverEnabled()) {
                model.setRollover(true);
            }
            if (model.isPressed() && (e.getModifiersEx() & 0x400) != 0) {
                model.setArmed(true);
            } else {
                model.setArmed(false);
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)e.getSource();
            ButtonModel model = button.getModel();
            if (button.isRolloverEnabled()) {
                model.setRollover(false);
            }
            model.setArmed(false);
        }
    }

    public BasicButtonListener(AbstractButton b) {
    }
}

