##
# Borges::Callback is an abstract base class for Callbacks.

class Borges::Callback

  ##
  # Abstract evaluate method for Callbacks.

  def evaluate(input, store)
    raise NoMethodError, "Subclass Responsibility"
  end

  ##
  # Is this an ActionCallback?

  def action_callback?
    false
  end

  ##
  # Is this a DispatchCallback?

  def dispatch_callback?
    false
  end

  ##
  # Is this a ValueCallback?

  def value_callback?
    false
  end

end # class Borges::Callback

