#############################################################################
##
#W  lag.gd                   GAP library                Richard Rossmanith
##
##
##
##
#Y  Copyright (C)  1997,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St.  Andrews, Scotland
##
#1
##  The {\LAG} package contains the declaration of attributes, properties,
##  and operations for associated Lie algebras of
##  associative algebras, in particular group algebras.
##
##  If $A$ is an associative algebra, its associated Lie algebra is the
##  Lie Algebra $L$ which has the same underlying vector space as $A$, and
##  which satisfies $[a,b]=ab-ba$ for all $a,b \in A$.
##  
##  In {\GAP}, however, the bracket notation $[a,b]$ is reserved for lists, so
##  the product in $L$ is denoted by the star `*' -- the same
##  symbol which is also used to
##  denote the associative multiplication in $A$.
##  Therefore, {\GAP} needs to distinguish between the elements in $A$ and the
##  elements in $L$, i.e.\ here the underlying vector spaces are not equal,
##  but only (however canonically) isomorphic.
##  {\GAP} stores the Lie algebra $L$ and the natural linear bijection
##  from $A$ onto $L$ as attributes of the associative algebra $A$.
##  
##  The usual commands that apply to algebras, such as `Dimension',
##  `IsFiniteDimensional', `IsFinite', `Size', `Elements', etc.\ also work for
##  the Lie Algebra, if they work for the underlying associative algebra.
##  Additionally, the standard Lie algebra functions (described
##  in the chapter about Lie algebras) of course also apply to Lie
##  algebras that come from associative algebras.
##  This will not be explained in detail for every single command in
##  this chapter.
##  
##  The main objective of this package, however, is to deal with Lie algebras
##  of group algebras. Some new functions are added, and, for other functions
##  that also apply to abstract Lie algebras, much faster methods are
##  implemented (which was possible due to the special structure of such
##  Lie algebras).
##
##  I would like to point out that many properties of Lie algebras of group
##  algebras carry over to the commutator structure of the unit group.
##  E.g., if the Lie algebra of the group algebra is solvable, then so is its
##  unit group (in odd characteristic --- there are counterexamples in
##  characteristic 2).
##  However, no such functions have been included in the {\LAG} package,
##  due to the fact that unit groups were only ``in the making'' at the time
##  when {\LAG} was programmed. See the survey article \cite{Bov98}
##  %[Adalbert Bovdi, The group of units of a group algebra of 
##  %characteristic p, Publ. Math. Debrecen 52/1-2 (1998), 193-244]
##  for a detailed description of the interplay
##  between the unit group and the Lie algebra of a group algebra. It might be
##  useful for future implementations of fast algorithms for the unit group.
##
##  The {\LAG} package arose as a byproduct of the author's dissertation thesis
##  %[Richard Rossmanith, Centre-by-metabelian group algebras,
##  %Friedrich-Schiller-Universitaet Jena, 1997]
##  \cite{Ros97}. It was ported to {\GAP}~4
##  and brought into standard {\GAP} package format during a visit to 
##  St.~Andrews in September 1998, under the supervision of the {\GAP} team. 
##  I want to thank everybody on the team for their support, in particular
##  Steve Linton, Willem de Graaf, Thomas Breuer, and Alexander Hulpke.
##
##  (Richard Rossmanith)
##


#############################################################################
##
#C  IsLieAlgebraByAssociativeAlgebra( <L> )
##  
##  This category signifies that the Lie algebra is constructed as an
##  associated Lie algebra of an associative algebra. (That knowledge
##  cannot be obtained later on.)
DeclareCategory( "IsLieAlgebraByAssociativeAlgebra", IsLieAlgebra );


#############################################################################
##
#A  UnderlyingAssociativeAlgebra( <L> )
##  
##  If a Lie algebra is constructed from an associative algebra, it remembers
##  this underlying associative algebra as one of its attributes. 
DeclareAttribute( "UnderlyingAssociativeAlgebra", 
                             IsLieAlgebraByAssociativeAlgebra );


#############################################################################
##
#P  IsLieAlgebraOfGroupRing( <L> )
##  
##  If a Lie algebra is constructed from an associative algebra which happens
##  to be in fact a group ring, it has many nice properties that
##  can be used for faster algorithms, so this information is stored as a
##  property.
DeclareProperty( "IsLieAlgebraOfGroupRing",
                             IsLieAlgebraByAssociativeAlgebra);


#############################################################################
##
#P  IsBasisOfLieAlgebraOfGroupRing( <B> )
##  
##  A basis has this property if the basis vectors are exactly the images
##  of group elements (in sorted oreder).
##  A basis can be told that it has this above property. (This is important
##  for the speed of the calculation of the structure constants table.)
DeclareProperty( "IsBasisOfLieAlgebraOfGroupRing",
                             IsBasis);


#############################################################################
##
#A  UnderlyingGroup( <L> )
##  
##  The underlying group of a Lie algebra <L> which is constructed from a
##  group ring is defined to be
##  the underlying magma of the group ring in question.
##  (Note that the term *underlying group* applies only to the Lie algebra.
##  For the group ring itself, the term *underlying magma* is preferred
##  over *underlying group* for greater generality.
##  In fact (or unfortunately?),
##  ``underlying group of a group ring'' is not at all defined.)
##
##  *Remark:* The underlying field may be accessed by the command
##  `LeftActingDomain( <L> )'.
DeclareAttribute( "UnderlyingGroup",
                             IsLieAlgebraOfGroupRing);


#############################################################################
##
#A  NaturalBijectionToLieAlgebra( <A> )
##  
##  The natural linear bijection between the (isomorphic, but not equal,
##  see introduction) underlying vector
##  spaces of an associative algebra $A$ and its associated Lie algebra is
##  stored as an attribute of $A$.
##  (Note that this is a vector space isomorphism between two algebras,
##  but not an algebra homomorphism in general.)
DeclareAttribute( "NaturalBijectionToLieAlgebra",
                             IsAlgebra and IsAssociative);


#############################################################################
##
#A  NaturalBijectionToAssociativeAlgebra( <L> )
##  
##  This is the inverse of the linear bijection mentioned above, stored as
##  an attribute of the Lie algebra. 
DeclareAttribute( "NaturalBijectionToAssociativeAlgebra",
                             IsLieAlgebraByAssociativeAlgebra);


#############################################################################
##
#O  NaturalMapping( <U>, <L> )
##  
##  Let <U> be a submagma of a group $G$, let $A := FG$ be the group ring of $G$
##  over some field $F$, and let <L> be the associated Lie algebra of $A$.
##  Then `NaturalMapping( <U>, <L> )' returns the obvious mapping $<U> \to <L>$
##  (as the composition of the mappings `Embedding( <U>, <A> )' and
##  `NaturalBijectionToLieAlgebra( <A> )'~).
DeclareOperation( "NaturalMapping",
                             [IsMagma, 
                              IsLieAlgebraOfGroupRing]);


#############################################################################
##
#A  AugmentationHomomorphism( <A> )
##  
##  Nomen est omen for this attribute of the group ring $<A> := FG$ of a
##  group $G$ over some field $F$.
DeclareAttribute( "AugmentationHomomorphism",
                             IsAlgebraWithOne and IsGroupRing );


#############################################################################
##
#A  SubgroupsOfIndexTwo( <G> )
##  
##  A list is returned here. (The subgroups of index two in the group <G>
##  are important for the Lie structure of the group algebra $F<G>$, in case
##  that the underlying field $F$ has characteristic 2.)
DeclareAttribute( "SubgroupsOfIndexTwo", IsGroup);


#############################################################################
##
#P  IsLieMetabelian( <L> )
##  
##  A Lie algebra is called (Lie) metabelian, if its (Lie) derived subalgebra
##  is (Lie) abelian, i.e. its second (Lie) derived subalgebra is trivial.
##  
##  Note that he prefix `Lie' is consistently used to
##  distinguish properties of Lie algebras from the analogous properties
##  of groups (or of general algebras). Not using this prefix may
##  result in error messages, or even in wrong results without warning.
DeclareProperty( "IsLieMetabelian",
                             IsLieAlgebra);


#############################################################################
##
#P  IsLieCentreByMetabelian( <L> )
##  
##  A Lie algebra is called (Lie) centre-by-metabelian,
##  if its second (Lie) derived
##  subalgebra is contained in the (Lie) centre of the Lie algebra.
##  
##  Note that he prefix `Lie' is consistently used to
##  distinguish properties of Lie algebras from the analogous properties
##  of groups (or of general algebras). Not using this prefix may
##  result in error messages, or even in wrong results without warning.
DeclareProperty( "IsLieCentreByMetabelian",
                             IsLieAlgebra);

#############################################################################
##
#E
