(require 'quail)
;; # HANYU input table for mule
;; AUTHOR:      Chue Chi To ($(07C,6Fq(B)
;; DATE:        28 NOV 1994
;; ENCODE:	BIG5
;; MULTICHOICE:	YES
;; PROMPT:	$(0&d'GTT&,!JX|/y!K(B
;; # define keys
;; VALIDINPUTKEY:	abcdefghijklmnopqrstuvwxyz/?;:'"\|[{]}`~!@#$%^&*()-_=+
;; SELECTKEY:	1\040
;; SELECTKEY:	2
;; SELECTKEY:	3
;; SELECTKEY:	4
;; SELECTKEY:	5
;; SELECTKEY:	6
;; SELECTKEY:	7
;; SELECTKEY:	8
;; SELECTKEY:	9
;; SELECTKEY:	0
;; BACKSPACE:	\010\177
;; DELETEALL:	\015\025
;; MOVERIGHT:	.>
;; MOVELEFT:	,<
;; REPEATKEY:	\020\022
;; # the following line must not be removed
;; BEGINDICTIONARY
(quail-define-package
 "chinese-b5-quick" "Chinese-BIG5" "$(0X|(BB"
 t
 "$(0&d'GTT&,!JX|/y!K(BBIG5

	$(0KHM$X|/yTT&,WoOu(B

   [Q $(0'D(B] [W $(0(q(B] [E $(0'V(B] [R $(0&H(B] [T $(0'>(B] [Y $(0&4(B] [U $(0&U(B] [I $(0'B(B] [O $(0&*(B] [P $(0'A(B]

    [A $(0'K(B] [S $(0&T(B] [D $(0'N(B] [F $(0'W(B] [G $(0&I(B] [H $(0*M(B] [J $(0&3(B] [L $(0&d(B]
	
      [Z  ] [X $(0[E(B] [C $(01[(B] [V $(0&M(B] [B $(0'M(B] [N $(0&_(B] [M $(0&"(B] 
"
 '(
  ("." . quail-next-translation-block)
  ("," . quail-prev-translation-block)
  )
 nil nil)

(quail-define-rules
;; #
("a"    "$(0'K'L(B")
("aa"    "$(0A_AaDgF=/zUp$(1`<'.CL[S[W[Z(B")
("ab"    "$(0=*A^Dh$(1*v5mJ`$(0/}$(1PqeYai(B")
("ac"    "$(0YaYoZ:]C^P$(1<LCKWA$(0K&$(1jU(B")
("ad"    "$(03RDf$(1$;$(00<$(1.#d=CFUQ(B")
("ae"    "$(0@3F?FAO3Uq;8Z;$(1`@'('/*y5o[X(B")
("af"    "$(0AcFzF}RsW|Y`$(1's'z<J=kCHDiPnWE\1ahi!k!k4$(0A`$(1k5p:m+nkp"p#(B")
("ag"    "$(0DYDdM\XL$(1.N/V$(0/w$(1:ki"<IURW>[Y`>gg(B")
("ah"    "$(0?qFC/yN`$(1HU')'2*q5p<KBR(B")
("ai"    "$(07mDiM]M_3WRr$(1Pp$<*nB|(B")
("aj"    "$(0,UF>F@LMRq\P]=$(1$::,<G$(0*/$(1CMWFHXPoWB(B")
("ak"    "$(03QDcW{$(1$='''+=s$(00#$(1CGp;CNPrW?[V\~`?jT(B")
("al"    "$(0/|0"+<A]$(1WC$(0IQ$(1*r*x@yNY(B")
("am"    "$(0/~3T5o7sFBK%$(1:+J_$(0(Z$(1WGjV[Td;(B")
("an"    "$(06L$(1"N$(01]$(1'1AB*o(B")
("ao"    "$(03S$(1au$(03X7t:aFYM[Yb$(1','K*tPlPmag(B")
("ap"    "$(0;3A-/{^;$(1h~*p(B")
("aq"    "$(0W}$(1CIl[WDdQ(B")
("ar"    "$(07r;C='AdM^M`O43PQe$(1_X$(0WzW~$(1*u/YHVTH(B")
("as"    "$(0=,3U[r$(1AA'&'**z/W/X3q(B")
("at"    "$(03VDeGBY_0$[C$(1d<HWJaW@(B")
("au"    "$(02$3N4`7p;)=&QfRo'<$(1#fgf$>'0*s5l5n<F<H<MACD'D)K5[U`=(B")
("av"    "$(07o=(*cFD$(1l\$(0\p$(1UP(B")
("aw"    "$(07q$(1l](B")
("ax"    "$(0Tp$(1US(B")
("ay"    "$(0=)$(1[R(B")
("b"    "$(0'M(B")
("ba"    "$(09\$(1bC$(0GHHoQ/W'[%$(1-'7Q?2EGF;YTZb]j(B")
("bb"    "$(011:m>iGCHtLSR70&SQ$(1js$(0WU^U$(1(Q9V>B>E>FEHFAM2XcZ]]i^[bkf*(B")
("bc"    "$(0.'6DCPOyOzSyWSWVY-]v^E$(1,{$(0-K$(1@MpdN>TTXbYW[f]kdUf)gviDlClp(B")
("bd"    "$(00i1Z>jB{GJGKOwYy$(1%N(:-"12$(0+x$(13&bB7M8PF>GbTX^X(B")
("be"    "$(00%13154<?JEyH)H*MtOZPN$(1,F5r8L8T$(0.@$(1?4qyEDEFFCFEL+N=RFU|Z\^WbldCiEiG(B")
("bf"    "$(0>CBT0gM6$(1q*$(0PQSRSmVKVL[\\W]P_F$(1ECL.M.TYV:XkYCYYY\Y]]l^Fbme$f+fPhVhWibk*k3k7m,(B")
("bg"    "$(0>;GEGNH(M2PLRKSPTtVGV~XmYg$(1217N$(0-?$(18No<8Q8R?6B.EEF@H]S)S/WHY_iakomt(B")
("bh"    "$(04c4d:A:C<4<5H$POQ2,0Sz$(1cc$y%%-(-)18>A(B")
("bi"    "$(0142&6C8y:BCMLTQ-V;WW^W_0_4$(1$u$x,D$(0-=$(1,xl6,z-&/28O>GHqM|S+S.Z3^YfOfsgzju(B")
("bj"    "$(0-<5]CQ-9GL$(1g9$(0Hq[0$(1(;(O3%7P>D?8EAF?HpS*TRTSXiYXZa]h]mdfg6(B")
("bk"    "$(07w9_9b<vCLKtPMVI$(1"i,!,|-*$(06s$(17Lq+COEIF<L,Xj[v_b`qc_g7iz(B")
("bl"    "$(0H'Ip$(1(P,J,}15$(050$(120Y^3=3?@v@|@}H-N?ODV>(B")
("bm"    "$(0->5+54CKH%KvQ,$(1!*,H-$$(0'c$(113jt8M@P@RFHG`M&RIS,^U(B")
("bn"    "$(0)I*[+5-22-6M9]&~D2$(1f'$(0Ms$(1!h!~#/$w(<(M(N,y11233p7O7V8U9WFFL0Z^(B")
("bo"    "$(08|>=?ICTD;GDGFHxU1W&XMXoZT$(1-!-+/Z/[162/228KFDL-$(06E$(1Xf^V]n(B")
("bp"    "$(0H&U_V}[m[s\{$(1?7M1Xh[x$(08{$(1_c(B")
("bq"    "$(05)><CVH"(oVJ$(1]g7UGaYU(B")
("br"    "$(0.S519`9cD1D3D5HpHwOvQ*R!SxU2W%WNWQXn\F$(1#,)L*|-%191<7R?3EJFIM0TUZc$(0)R$(1c^lAh0(B")
("bs"    "$(0*Z+8199h@:LQ]/]q$(1,E,I-#17[y^Z$(0'z$(1iF(B")
("bt"    "$(0(x9g>nOxVH\0'v^)$(1lB$(0^V$(1G[M-M/[w_d(B")
("bu"    "$(0(y-E-g/&12164^(p52$(1p*$(09[9a>l?=CJCRE+GMM3\.$(1'4*{,C,G,~3O8J8S>@>C>H?1@N@OE@EBFGL4N0SiXdYVY[Z__Gg$mWnS(B")
("bv"    "$(01-9d>:>o+uCO$(1c`$(0H#LUM5Q.UPW$Zi]I$(1(9142.7S?5BAFBS-Xe(B")
("bw"    "$(0KsH+TJ$(1YZF=(B")
("bx"    "$(09kY,(B")
("by"    "$(0CS&f$(18V(B")
("c"    "$(01[(B")
("ca"    "$(0Ae$(1j>$(0IITd$(1A;Ny[0[F[J[N_~j:(B")
("cb"    "$(0ICQZQ[TkYZY\[6_-$(1A>H8HLHQNgU9$(0D]$(1[.qc[>[G[L[O`.d0gOjBjOlUn9n?(B")
("cc"    "$(0?OIdIeQbYVYY]6_>$(1GZH<[D$(0:_$(1[IpZ`6`Ud#g\j@jDjKlSn8o[(B")
("cd"    "$(0TiYX^M$(1:%:(HRNaNzN~O"$(0MT$(1UCn>[+[6`0`2d*d1gVjNjQlTlW(B")
("ce"    "$(0INThWlWvWw[;^N$(1A3A<NtU0U3U6$(0Db$(1UIr2[4[A[C`#`&`'d+gYg]jJlYn:o](B")
("cf"    "$(0WuYW[=[>^L$(1'{A,$(0Wp$(1V8r0[-[2[<d%d2d|e(gSg^j?jGm8(B")
("cg"    "$(0MVQ`QcTjWt[:[A\M]8_@$(1#L$(0D[$(1:'qfH7NhNvO#U;[B`(`3gXqd(B")
("ch"    "$(0,/DZILQYTgWx$(1:#:)A?UK`9$(0'"$(1c\rHgTgcj7jMlX(B")
("ci"    "$(0?k?m?pIJIKTe[?];]|$(19R:"A/A6A:H9HF$(0&}$(1HMr:O!U.U:U>_;_yd$d&gUg`gbj;jHnAqCqF(B")
("cj"    "$(0QXQaQd[9]:_6$(19|A7$(0:]$(1Ndo\Nf[:[K`/d7gaj<jC(B")
("ck"    "$(0IBMPWmWq[8$(1'#5j9~A1HENiU7`)g3gWj8$(0'Y$(1j=r1(B")
("cl"    "$(0/u24?nG&IDIP$(1"?$(0&:$(1%-_{3BA0A4NrU!UE(B")
("cm"    "$(09S?o$(1qE$(0D^IAWs[7$(1H:HBHDHPNuNxTPUG[/[;`-d(d/gQ(B")
("cn"    "$(08W:\:^D`$(1,;-b3F3H$(02($(1:!n<A8NbNlNsUJ[7]]`"(B")
("co"    "$(0B$DaT`$(1A5HGHTNjU4[1`%d"gPgZjEjP$(0=D$(1lOqGlQlZ(B")
("cp"    "$(0NlTm$(19}A+A.H6H?HKNeU5UDW.[H`$$(0/D$(1a\p[d,d8g_jLlNoToZ(B")
("cq"    "$(19SHI$(0Wo$(1N}lR`1j9(B")
("cr"    "$(0?lI@IFIHMRMSMUQ^TbTlTnWrYTY]Y^$(1H;H@HAHHHJHN$(0-H$(1N:p\NcNmNnNoNwU2U<U?UBUL[*[5[8[E`!`7`8d'd.gRjR(B")
("cs"    "$(0D\IMQ\Q]WyYU]<$(13G:&A*NpN{jIlV$(0&|$(1qe(B")
("ct"    "$(0MYTcY[]}^p$(1#r$(04Z$(1A-n@U1[3d)d4jA(B")
("cu"    "$(0,&0jD_IGMZQ_Tf+,[5$(1d6$(0\N$(1-c0#A2A9A=H>HCNkN|UAUH[,[=[?[M`:d5(B")
("cv"    "$(0MXTa[@_,$(1:$H=N`U/$(0MQ$(1U8o^UF[@_z_}`4`5d3lP(B")
("cw"    "$(0IOIETo$(1qD$(0Wn]7]9$(1d-jF(B")
("cx"    "$(1[9$(0\O$(1_|n=(B")
("cy"    "$(0:`$(1U=HOHS(B")
("d"    "$(0'N(B")
("da"    "$(03jA~FIO;Uv0,Z?$(1eZ/o/u<[<zCVE=JkK'K,P~WIWLWYam(B")
("db"    "$(03d=0=4Al3YAm$(1mU$(0A|A}K*K-RyR|R~$(1"U';+,/f/j6165<h<sC^CiCkCoCtCyJrJtPsPtP{Q,Q8]'],alaqgq(B")
("dc"    "$(0FPK,MjRxTKXNXPZ=$(1"W+/+1+:/e60<S<aJhJ~K&Q.TWWMWNWW]&areeo1$(0Aw$(1pb(B")
("dd"    "$(0008.=5ApAqK.OCUy$(1$?$E$F+4/h6#6*6869<b<c<r<u<v<|CRCXC\C]JyQ'WbWd]#$(0,X$(1`Oi*dRdSe`(B")
("de"    "$(00/03=;=CAvAzO5X"$(1'G'H+'5z6($(0(w$(1<VmV<Y<_<wC`CdCgJpQ#Q$]+ase[e\(B")
("df"    "$(0023^>UAjBPFVG\O:OBS"$(1+867<U<oCfJ}K#K$K%K)PyQ5WTWZhO$(001$(1h_q$k,nqp<pt(B")
("dg"    "$(0043[7|8!80=9A{K/XSXU]c$(1':/k45$(0,\$(15uo35|6!6&636:CuCzK!Q3Q7WJWf]%mT(B")
("dh"    "$(0,Z,_0;3f<3=/FO_I$(1'8'@*~$(0&`$(16)]564<mCpQ!Q&We(B")
("di"    "$(0,[,b05=2ArDzFSK3K5RtRzS#XTZ<$(1$D$H'=$(0&Q$(1'Bq&+6+D91JnJuMzPwQ0WR]$]7k]k_l5nCq#(B")
("dj"    "$(0,`07093m=1=3(^As$(1la$(0FJFQK1O6Rv$(1(8+"/s66<f<pCSJzK*O3PzQ%Q4WPWQWX](andPgs(B")
("dk"    "$(0087y<z=7FKO<O>R{Ut$(1!<$B$(0,]$(1+.W^+</]>!CUChCvJgJsJxO4Q1(B")
("dl"    "$(0063l3n=<FFFMO7Uw$(1"S+@/c/i/q5{6,$(0,W$(16/\C9p9q<{@z(B")
("dm"    "$(0,a3e3h3o7}8#AyFLK0RmUr$(1'C'E+%+++?/a$(0(\$(16-r,8C<O<W<Z<eCPCZCeJiPvP|Q"Q6]2i%k^(B")
("dn"    "$(00'0:./2+$(1]3$(08182FUXR$(1!L"P"Q"T$G'J+*/b/g5}<lCQCrC{W`(B")
("do"    "$(03b7z8-FHOARuR}UuXO$(1'7'>+3+7+B/r$(0-u$(15vef6;<\<]<d<qCcI%PxP}WS]"]/]4ao(B")
("dp"    "$(00.Ax$(1i#$(0ExUa[_^<$(1"V$A'A'I*}+)/`;n<g<~CxW%Wc]!(B")
("dq"    "$(0AtZ8$(1'F+!C>$(05v$(1C[k`CwFJWKWU])(B")
("dr"    "$(03`3c3i8"8*8,=6AiAnFXK)K4,YK6$(1i)$(0O9U{Z>\!\s$(1+&+(+=+>/n5x5y6%6'6.62<P<^<t<y<}C_CnCsJfJoU^W]akape^(B")
("ds"    "$(00(3kFRK'K($(1"R$@'?+#+-+A+E/_/t5~PuW_$(0*6$(1]*e_(B")
("dt"    "$(0=8FTRwXQ$(1'5+$+;$(03a$(1/\i&5t6+JmJvK"Q*gr(B")
("du"    "$(0(_$(1ed$(0,^0)0-4_8$8/8u=>=BFNFWK9S!S$[t_$$(1$C'6'9'<'D+0+2+5/l6$<T<`CjJ{K+Q+Q-Q9]0(B")
("dv"    "$(0;cAu7~O=$(1ka$(0\q$(1/^5s5w6"<Q<XCYCaCbCqJeJlK(WOWa`Pati$(B")
("dw"    "$(03gAoK2UsUx\r$(1/d<iCTCW$(00*$(1E.q%Q2Wg]1e](B")
("dx"    "$(0[I$(1Jw$(0O8$(1WVi'aj(B")
("dy"    "$(03p==$(1+C/m$(0*7$(1<R]6<xJq(B")
("e"    "$(0'V(B")
("ea"    "$(00]40=`BJKPOQOX$(1$T'P6U$(0,s$(16\b$6d=/=;=VDIKJQ`QaQjX%(B")
("eb"    "$(04,8>8@8D8K=S=e=iB:B<B@F`FeFmK@KAKF,mKI$(1kd$(0KJOROSV-[v^a$(1$V060;6W=0=A=H=SD-D6DQDRKDKOKRKUKWQNQVW|X.]>b!b&eoi5(B")
("ec"    "$(03|=T=nFfK>KEOVO\S(S3V$X\ZBZE$(1!a'Q'W070E6I6S=E$(00V$(1D0qqD1DMQHQIQMQeU@X'`*`+`;axb#epergui,i.i7m[p?q](B")
("ed"    "$(0*B,p0^3Z3q8'8G=.=K=U=f=hB-B3FsGlKXOUS*_3$(1+W+[0.050@0C0I6]6c6h=8=UD4D9DNDO$(0*@$(1KKb%KVQQQYX0X1(B")
("ee"    "$(0,x0E0M8A8H=W=aB/BLKCKKKQOLS)V.X^$(1$[$(0,u$(1$\i9'e6K6V<;=.DADFK8K9K>Q[Qk]=]Ea}b"en(B")
("ef"    "$(0=L=J=N$(1pl$(0FdFgKGKRKVOMONO]S>V/X1XYZ!$(1'U+e=3=6=9=K=MD2D5DJKYK`QRQUQXQ_QdX*]FayelhRi3i8(B")
("eg"    "$(00D8E8N=V=c=gB4B;BM,nBN$(1mX$(0EVFjOJOWV*V1\u]f$(1!P+R+T+d.S0:6`:w=XB8D@DHKPKZK]WtX-aza|emkekfkg(B")
("eh"    "$(0,y0G8=8FB>BAKWOT$(1$Q$(0,h$(1$XrB'`'c0LKEKLKaX!X)(B")
("ei"    "$(0*C*G*H,q0O0P0b:*=R=YBFFh&GKY$(1pe$(0O[S-V(X]$(1"]"_$O$S'R'_0+0M6a=OD8D:D>DBDKKAKFQJQbWzX(]B]Sa~eui1i4p=(B")
("ej"    "$(0*?*F0N4"=l(eBC$(1o5$(0BEFaFnK=KOOPS,$(1$]'T086J6T=<=>=YDDK;KGQSQgWvWx]?]Gkc(B")
("ek"    "$(0,w,|0X4(=M=bB2BHFrFtKDKSS/S0[w$(1"\$R'Y+P+^+a+h$(0,o$(1+lW~020?0A0D0H6b=4===@=F=R=\D?K@KQKXK\QKQTQ^Qh(B")
("el"    "$(0-"0a3{8C=]=^BIKM$(1"`$Y+f0)0-046RK<QLWy$(0,t$(1X#]D(B")
("em"    "$(0,}0U0`4+8?=IB0B5FkS2V+ZCZD$(1$U'V'j$(0*A$(1'mmZ'o6H6L6O6g=I=ZD3DCK=K^QOQ\eqi2(B")
("en"    "$(0,v,{0Q4!8P=XB.BBBDV#(fX_$(1i0$(0Z@_%$(1!b"^'f'g+S+j+n..0=6Y=1KCK[(B")
("eo"    "$(00\4/8M=mKBKHKLV&V'V0$(1'^'a09$(00W$(16Eeg6N=$=GD+D<KNKSKTQWWuW}X"X2(B")
("ep"    "$(0-!0F0H,i0_$(1es$(04.8L=Q=\XBX[]e$(1$Z$^+X6Z6^;^DPK?KIQcX&X+X/]C]HaTek(B")
("eq"    "$(03~$(1'S+]+i0,5K$(03z$(1=?X$=WDLQFQfQi(B")
("er"    "$(00J0K0L0Y0Z4#4%4&4)8I8J=O=[=kB6B=FbFpKT0IS1$(1i-#F'[']'h'k'l+Y+Z+\+b+m0/030J6F6_6i6k=2=5=:=C=D=L=N>SD.D7DEESKBQZW{(B")
("es"    "$(0,~B1B9Fc$(1!c$L$(0*E$(1'ZQG'i'p+U+c0G6f(B")
("et"    "$(00R42BzF_FiFlOKS.V)VFZF$(1$M$N$(00C$(1+QrA016P7K=P=QD=KM]@]Ab'kbkh(B")
("eu"    "$(0*D,j,k,l,r0T0[3}4$(g4-$(1p@$(0418O=Z=dB,B8BGBKKUOOS4V,$(1"[$P$W'n+k0*000<0>0F6G6Q6X6e6j=+=B=T=]D;K7K_eji6o6(B")
("ev"    "$(04'6t8<;h=_B7B?HNK?KNS+S5$(1"Z'X+`0K=J$(0*>$(1D,q'DGKHa{eti+i/(B")
("ew"    "$(0:Y=jFoOYXZ[u$(1'\$(00S$(1+Vp>+g6M=7=[D/WwX,(B")
("ex"    "$(0V%ZAFq$(16[QP(B")
("ey"    "$(08B=P,z$(1'bmY+_(B")
("f"    "$(0'W(B")
("fa"    "$(0J*>QS6$(1f;$(0V9Va$(1=h>oQpRkX6(B")
("fb"    "$(0459f-:<'$(1ku$(0=sJ]L5P6Xc\($(1*40X6t6x=iD\DdDfKbKkM3QsQuRjX>XBY3]Mkj(B")
("fc"    "$(0FwQ+V_[K$(10`KcKd$(08R$(1O5qIX5XA]L`Wd9ewkw(B")
("fd"    "$(04wAkFxK+*NV5$(1b+$(0V6ZH$(1$`'w6r=_DVDWKgLhRiX<(B")
("fe"    "$(0G#G%V4V8V]26ZG$(1]N1l6q<?K6Q|(B")
("ff"    "$(0FyK_L4S=0dS@$(1pA$(0SgSkX`\^]N^+$(1=c>yDhQnRXX:XCexm0no(B")
("fg"    "$(0;Y?{E_FvF~OfX}\/-#$(1'vrL+o0O0]1p6|DaDgE|GIQvb)e{m](B")
("fh"    "$(0.-0e9@F|Vc'8$(1"ar71r6m6w=m(B")
("fi"    "$(043T.-$V7$(1qv$(0\)$(1'y+w,iX7X=Y4Y6]K^<_=b,kim\(B")
("fj"    "$(0=q=rL3QB7j$(1't]I(I,g,k8&=^=`DSDZD_LjQqX4X8X9(B")
("fk"    "$(07i<rAUG!GmS7V:V`){$(1'qY5'u+u,j=gDeR!X@(B")
("fl"    "$(0QP$(19m'r1o(B")
("fm"    "$(0K\$(1$_+p+t0N0V$(0>P$(16pr-=a=fDbY7bh(B")
("fn"    "$(00c2)Jd+3$(1*>]\,f.*0\E*QyR7Rl(B")
("fo"    "$(0HnV2$(1!=0P$(00f$(10Ucq6v="=bQm(B")
("fp"    "$(0K^S?Uo$(10T$(0BV$(1PCa7QtQz]J(B")
("fq"    "$(07U8QA@Kb(%S8$(1U_0dC!DUD^(B")
("fr"    "$(0/!$(1_W$(0474;8TBOKZShV3Vb$(10Y0^6o6u6y6z8%>pDTD`DcKiKlQo(B")
("fs"    "$(04649)J8S$(1i;$(0@9$(18$(B")
("ft"    "$(0F{Jc>OS:$(1iY$(0Xa[x$(10[8'=jKfKjQwb((B")
("fu"    "$(0.;4:4]>8S'S9SS$(1'x+q."0Z1m1q6n=eAWDYE}$(0)=$(1Keq(QrT9YK_Ic(cwmD(B")
("fv"    "$(0Lw$(1,h6lBDDX$(0G$$(1I\kkLgLiQxZA(B")
("fw"    "$(0\v$(1>nD]$(0G6$(1X;qs_u(B")
("fx"    "$(0BR$(1X?i:(B")
("fy"    "$(1+v6{0W(B")
("g"    "$(0&I(B")
("ga"    "$(0NAQ5;Z\U$(1j\:d(B")
("gb"    "$(06l6oM8'uUZ$(1o4$(0^_$(1.X494<4C:h:qB/B4B5I?ICIFIJ\Vg=(B")
("gc"    "$(0EYM7NBQ1QoX>YD$(14IB*$(0-L$(1B,q`T]UMZdcbeFg;g[gdlb(B")
("gd"    "$(0)h$(1%z)Y.Q41424J4M4N:fB6$(0)c$(1Ghj&GkQ(T[VT(B")
("ge"    "$(0.\?P@_B'IqP'Q7W_$(1&$.Y484F4L$(0+d$(1Awm&BiD%IDJjQ]RHW<Y=Ze_K_^iB(B")
("gf"    "$(0E]+fO_$(1np$(0O`S<UOXb$(14@:mIMX3^Ka(g<hLlmlnnc(B")
("gg"    "$(06m;UJ=LX$(1%~)U)_.O.R4H:e:s:u$(0)e$(1IPpyN@OzT\lD(B")
("gh"    "$(0A&D@$(1#N$(0@\$(14;IG9Y@U(B")
("gi"    "$(0)z2m;[E\E^JAW<$(1"+%y&#.P444O:t$(0(+$(1;=p+GdI@OsO|Z:\W_5_6(B")
("gj"    "$(0/2;V;WM9VxVy]T$(1$I.V3(4AIIOvTZVW$(0.Z$(1dL(B")
("gk"    "$(06n<s?Q@bJ@NE$(1%w$(06k$(1)[o$9X:gIOR"VUVX(B")
("gl"    "$(0)b$(1m?$(0+g.^5[:W$(1-Z-[.ZIK(B")
("gm"    "$(0+b.[.]2Q;R@dEZN@RLY(Z0$(1%s%{$(0+`$(1%|i_464>4E9Z:c:j@TB1B7B:GmIA(B")
("gn"    "$(1!O"*#K%R%t.W.[:vGj$(0+_$(1Gl]_IB(B")
("go"    "$(0-M2U@]B"EWUL$(1)W$(0+c$(1/yZgE'GfGnOwVVWk(B")
("gp"    "$(0]a,6$(1#JPE%u&")S/"B+ILJ,(B")
("gq"    "$(0Nx$(1&!)T$(0N?$(1)\PW4BDoPV(B")
("gr"    "$(0.Y2R;\@F@aD?EFEUEXJ.Q6SV$(1%v%x)V)^4G4K:pB2GgGiO{_ecTcU$(0)P$(1c[p6e@m>(B")
("gs"    "$(0+7+^2S2TE=$(1%V%}-T:rB3IN$(0)f$(1IR(B")
("gt"    "$(08w@cE[$(1)aB-$(0.X$(1Ouhp\X\Y]feE(B")
("gu"    "$(0:E@ZJ;VuWXXl^~$(1!:")#M)X)].U3)43$(0)g$(147n$4:4P:o@VAXGeN/Ote0e1g:(B")
("gv"    "$(0:1@G@[@^D>Z.2P[g$(1m@)R.M:iIEJb(B")
("gw"    "$(0NF$(1rJ4D:nB0Zf(B")
("gx"    "$(14=eG(B")
("gy"    "$(0.:+a._Z*5Z(B")
("h"    "$(0*M(B")
("ha"    "$(00!3%5~>sC2L.L0P(XyX|\'$(1'-*wEfRE$(0(v$(1Wsr#\j];^-^^eiiR(B")
("hb"    "$(0172v7<C"C&C-KaL#P%P2S_SeXWY}]K^A$(1*58WBcEhEq$(0/0$(1Erp'FLKpLOLQL[L]RBS6XFY&Y2^#^9^_`vbYf"f7f:m6mA(B")
("hc"    "$(0D<$(1q{$(0D}L)LYQ3SYS|U&WaX)XxX{ZJZY[&]B]n_2_L$(11Q=r??E`HhR\RgUgY,Y.\/^"^*`T`VbWdnf5h!hMiQiXkGn-p,q.(B")
("hd"    "$(0'h(~$(1iA$(0*8*9-)-^.x4v7C9j=@=AGdI$JNK8L/R%RQSaV\$(10b1Y<n=o>^>_EdEgEwFMFOL\LbR`S2Y(Y*[le&(B")
("he"    "$(0,3/?3&3u3y4X6S859o9p=GA'E)F[G_P)R.S}YwZWZ[[N\|'1$(1!@qr#u1g7y7};[>`DlLPLdOGS4WoWp]<e)e}hwmln{pKq)ql(B")
("hf"    "$(04r8V@%B(MzSXSbZ'Z(\-^y_G$(12r54;v?>KhM!M4Q{XyY/YE\3\4\:]O]}$(0-8$(1^,qRa,a-a.a0a6bUe%e,eze|h@hYh[h\h]i@iPk9k:k=kElclvm.m/m5m7nmozp%pvpw(B")
("hg"    "$(0-(/<4W5n;*A)C$C/DwG`H-L"MeP3_&_'$(1)`.T0c2s$(0'2$(17ko>9M>h>jE_EtS5V[XEY#Y%]|^;bndohZiTiVi{kHmj(B")
("hh"    "$(00m4q9:>JS[S]XsYr_+$(1(R+{,`1U1f7#7{>]ASHiO;RdX{^5aAbOjb$(0-O$(1nF(B")
("hi"    "$(0&>)$)i*b+=,=-40|3"4n5z7-8X:q<6>K>rC,C4L*R&SdVYY|ZZ\%$(1"@#t$(0&<$(1$apo&X(1+}1/2l7|8\>>@$L3RfT(\|]~^+_<bQfQg{hei?l7memimmnXo@pC(B")
("hj"    "$(0.91^394p4u8t9495C#C5L2MvVZV|X9Xz\L$(1#P$r&r0'<B@'DnEcExFNLeRD^0$(0&F$(1bSnzbZf6gplImk(B")
("hk"    "$(0+Z/T0l969?9i<w>4E`EsGgJfNbP5R+U\VW^]$(1"(1e>dBjDmEuJ*L/Q@ReV%W"W;\i^7a?a@b?bXe3ksnb$(0'6$(1nxp-nyoq(B")
("hl"    "$(0())N.=/U1'1W6P<:DTGhM|QS$(1!8,]-^-`-a26$(0'I$(13ApH7p8"8Z9r9t>eA#H1H2H3LaNZOHU&^6^8n7(B")
("hm"    "$(0(c$(1qW$(0(n/=1+2N4=4?7B7T97>(>H>LGiL+L-P4PJScSuY)^?$(1&W&Y,e--1$1S1V1j7$7x=pEaEeLXYb^'^)^1dme5icnW(B")
("hn"    "$(0*h+4.1.2.3/>5Q9m:F>D?5@8CzHMMWN,P-PlPmR:T0^i$(1-M$(0&.$(11bq^1k7s96@(@)AUE)EzHuK}K~L!L^LcR6RbT,Uh\D^3hfiUkR(B")
("ho"    "$(0'X'g(C(k0=1<7A99<7<8<;GjP&P1V[XVZ\$(1!-0~1h;\>f?:C~Ep$(0&-$(1K.o=K/LZL_LfRa^.^4^:bNboiWidn4(B")
("hp"    "$(0*K-1-f/@3,6!7K9l<?>qE{F'GbJgLZNaNkRWSfU7VUZ4ZX]m$(1!((E,\,_1W$(0'U$(11de~7J7h7tD*O<^(dXeN(B")
("hq"    "$(03$3'=vA?C.F^LOW)$(1"f$(0']$(1'|m^;]?@C"DkJBLRPBY0(B")
("hr"    "$(0)X)\*`+@+L.P.V3#4><<>M>t@SBXBxC0C1GaL(L1MmP$P0QAQrS~X4YKZ]\_].$(1*T$(0)W$(1*Un*1T53557"7%7i7q7r7u7v7w7z8!8X=*>g>i>kEbEsEyKoLWO6Rc^2bIbTe4e6f0f9hghoj#(B")
("hs"    "$(0'f,2-5/S9n;0>NBjC3ErGnH,R;\w$(1"b#2(H)61R8[?AEvI-Y$YabPfS$(0'C$(1gDq-(B")
("ht"    "$(0*g38>GL,L\OsOuSO\&\1$(1101c$(0'+$(125mu7I7~EoY'Yc^/bRbVh"h^mn(B")
("hu"    "$(0(*)@*]-6.$0h1(4a4b56779>;(<T@xA('TBw$(1pz$(0C%GkP.P/\=$(1"g$(*',^0$1!1:1i272[7o8#:F=,=n=q>lBkEmFKGDKqLNL`O7RCRhS1S3T;VqVuY+Y-Y1Y`^!`cm2p.(B")
("hv"    "$(03!HUIrL|S`VXXtY~^1$(1,d/3;5$(0.h$(1>\rEBEEnP$V$ZEZs^]f!hvmhp/r*(B")
("hw"    "$(0>IBmI?XrZ+Z^^@$(1*@+|0&1X$(08i$(18YleLM]ef8fRkt(B")
("hx"    "$(0P*Xw*_$(1-,ief4(B")
("hy"    "$(0(Y'w<9$(1e7$(0A>Qk$(1LYY)`d(B")
("i"    "$(0'B(B")
("ia"    "$(1*m5-bMJ"V~(B")
("ib"    "$(07;7x<,N[W!-.$(1!gmg.%I~LBf3iO(B")
("ic"    "$(0@)D4En([GZ$(1pG$(0HrK}N]Q4[<[]$(1.)3'@SJ!J$RZdVj_p&pF(B")
("id"    "$(0N)V^X3$(1(C*<+9.(.x/v$(0,,$(17bm:7j>mClE[LEVzXz\=(B")
("ie"    "$(0)D,f2z6G<+A$ByEoG[NYNc$(1#m$(0(d$(1,YkB.z5,>ZBgLLhc(B")
("if"    "$(0<-<RE&K]My^/^z$(1+r>{BeP=$(044$(1P@o7RURVV<VE\6^Ja1d~hIm#nf(B")
("ig"    "$(06H7>7?J9$(1"=*93l:2AkB9IHLDP>ZJ$(01$$(1\;kZ(B")
("ih"    "$(09+;7Jb(T$(1#^LH#o.{(B")
("ii"    "$(0+1/5M{NZZV]J]R$(1&q(D*8$(0*)$(1.lo(1J1KBfJ#Z;]{_4ld(B")
("ij"    "$(07=VT$(150@p$(0*'$(1E]kALJV|]z(B")
("ik"    "$(0-34j<tN^O/$(1!d#-$(0'^$(1,Ze.1N=tJ%LC(B")
("il"    "$(01&4l5i90A!JaLWMJN\)}$(1#qcx(x,X,[-\39@wI)NS(B")
("im"    "$(0*(/6/Q4k9/92$(1!{.~7`I}RYXx$(0*#$(1\<px(B")
("in"    "$(0,*.*>'A"Io)G$(1#pkQ%T1#3mAo(B")
("io"    "$(0*:/3&g</$(1bL$(0LPR8YE$(1![*;/|1P5.5/6>7aLGLKP?(B")
("ip"    "$(0,+3*4m7E9e@'A*EwJiNiRVU]Z2_#$(1!Z#v*:*AHvI|LIPSmO$(0&^$(1rC(B")
("iq"    "$(02y>ANw*J^\$(1huLFQ}V}(B")
("ir"    "$(0+0/4292<6I6U9,9-(;L!$(1k@$(0STVS$(1%P.'1L1M1O7e:G>[E\ha(B")
("is"    "$(093**$(1$s,W(B")
("it"    "$(0,<>7GAXqZ3$(1*7>?>X$(0(P$(1Bd(B")
("iu"    "$(0'9/71%91<.A#D!&yR-$(1hb#n%O7cE^QBRWa9(B")
("iv"    "$(02]2eHR]l-A$(1!]ht.&7d>YJ&Uie-(B")
("iw"    "$(08hK~6F$(1.yV{Bh(B")
("ix"    "$(1qT(B")
("iy"    "$(0[H(B")
("j"    "$(0&3(B")
("ja"    "$(09T10;o$(1LS$(0O2(B")
("jb"    "$(02l5/7*@pAhM;QCQG[/^>$(1!>1[9c;<NP$(0/,$(1TrnvTvZw(B")
("jc"    "$(08z;lD6JSM4UcWTYm[B[M[k)!\#$(1n;;;@fBPG~HgR^TVU``RgE(B")
("jd"    "$(0)t)v+v+y+{7{8(@qGf(]JT$(1n6$(0K7[`$(1(G4v7l>aIfQ)TuW\Y!Zu\d]-_lcueagG(B")
("je"    "$(0;k;nJUQD$(19d;:$(0'F$(1BOe2I5K4QETsZx(B")
("jf"    "$(09FBUJWNNNQP+U8Z_\V$(1;6TqV4X~a%d}gFhGhKk(k-k>m"m(m)m3ng$(0.y$(1qN(B")
("jg"    "$(0>ECGESI(J>JqL$YS$(17n9e?;$(02j$(1@qd?H#K:VZ(B")
("jh"    "$(0JQJR4s$(1&9ct@nAl(B")
("ji"    "$(0+|:H;r@(@<A=LnNOYL^h$(1(F3.?y@j@lPUTtW:Z,\>c:ft$(0)w$(1j*lH(B")
("jj"    "$(0-P237%:GDLEmI&&]K!$(1j/$(0TS]3$(1@cEiR]cv(B")
("jk"    "$(0)Q3K4t<uC(&8I%$(1LT$(0JOTUXvYM$(1#\,b3-7m@d@h(B")
("jl"    "$(0<~?h\]$(1.i$(02i$(11^Y"3;9nH!NV(B")
("jm"    "$(0.|1!1)2h9R&JI'$(1oX$(0M=StVV^d$(1@kEjM(bi(B")
("jn"    "$(0-h1*2,5^6K:r@5JPP,-7TT$(1OO!S!T"h.+9f@mAmLU(B")
("jo"    "$(07'>F?UDKR,$(1(6)y1Z1_4u;9?/$(0.z$(1@ogHBQG|L#R_Wi\e^$_kcreV(B")
("jp"    "$(0)x*SA.QJRUZ1$(19b;_;`$(0(G$(1X}j,cs(B")
("jq"    "$(0J{OcUe-'X'$(1a:$(0[.$(1>2(B")
("jr"    "$(0.{2;2k7&7)7+;mC'C)DIJVL%WPW]$(1&:,s.j@e@i@rH"IhNONQTwXr$(0(-$(1Zy_V(B")
("js"    "$(0.7209;9<$(1)5.k$(0*T$(1Vh(B")
("jt"    "$(1;7G}$(0(&$(1_mr<lGoW(B")
("ju"    "$(0+-+z.~1R5$:I;p?TGeJ!M<M>S^$(1#],a1\1]1`9`9a;8@gNNQCTxZz\?^%^&$(0&%$(1fHn%(B")
("jv"    "$(0.g7(7,C{QIRRW^W`)yXu$(1j.$(0][$(1I^IgX|Z?Zvj-(B")
("jw"    "$(0@oDJNP.}QH$(1n5$(0TR$(1BzZtgIj+(B")
("jx"    "$(1Ek(B")
("jy"    "$(0@n$(1H$(B")
("k"    "$(0&L$(1!!(B")
("ka"    "$(0;^*2=y$(1b;$(0NG$(1"OE0E8L$XM(B")
("kb"    "$(0*5(M,)$(1r=$(0188]8k9^<(=wBoG)G+OlSLSMXjZR$(1!/0i7.7D=v=~>7>:BSE:R&R+]P]Q]di>(B")
("kc"    "$(0D8G;U!XdZL\z^c$(1'}1):4E9$(08[$(1R)knR@(B")
("kd"    "$(03_=z={G@)u$(10jE;=w>6Dv(B")
("ke"    "$(04P8m=EBtOpOrV>$(10k<9<:=)=x$(0'/$(1=}o:DtKuL'R<]bb-b8m_(B")
("kf"    "$(0-*.c4SG9InQ|VD[[$(1'~DqDrF,R%$(0*I$(1R(qSXXX]X_\8]Ra)e!e'e*hNnhos(B")
("kg"    "$(0-+2Y8\>2Du)d]g$(1o;$(0^b$(1#_$d$h0g1';>>;E<R#R:kl(B")
("kh"    "$(0Km$(1$c0e$(08q$(1>5X[>9XG(B")
("ki"    "$(0'54@6q&;>/$(1R>$(0JEKnSB$(1!9"6((7E=|DpR;(B")
("kj"    "$(0G=KdSKXi$(1"c,#,w7&7,$(0G:$(1]co%(B")
("kk"    "$(04B8j=tB\KcKp[|$(1=uL%L)R*XKXWX\b<$(0'Z$(1o9(B")
("kl"    "$(00o4R5j$(1",$e&%0h$(0+}$(13<o83@9vE5ISKtb9(B")
("km"    "$(00p8l8n8o8sB]BqEpKl$(1("(&('(7,%2($(0(K$(17-]aJAR9XZ(B")
("kn"    "$(0'$)k0z2'>3BnKoV=$(1!e"d$g$(0&'$(1$pL&%S($)c.-0l1,7*7G>1E6(B")
("ko"    "$(00r0{8Z>%OeZS+i$(1,(`A1.6=7B=!={E1E7R'R?XLX^(B")
("kp"    "$(0BpN/Xk]j$(1$q(%,$,?$(0>1$(1,@XY577)R=RA(B")
("kq"    "$(1,q$(0]k$(17CXJ(B")
("kr"    "$(0(..b0q8rBsG?JFOmOq$(1(#,",&-R.<0f1(1+7'7/7F7H=y>8Du$(0'|$(1E/b>E3E4L(L*(B")
("ks"    "$(0)lVC&1$(1!R1*"!(B")
("kt"    "$(0.e=x$(11-$(0>5BrOnUT$(1,'(B")
("ku"    "$(0(h.d&S0y$(1R$$(04Q4T;2VE$(1$f+M.r2Z7(7+:6D&DsE2Ks(B")
("kv"    "$(08Y>0?7B[G*G>4AXe$(1md$(0[{$(1"3(!)x=zXHXIb:i=(B")
("kw"    "$(0OoBZRN$(1b=(B")
("kx"    "$(1f((B")
("ky"    "$(08p$(1><$(0G8G<$(1$b(B")
("l"    "$(0&d(B")
("la"    "$(07uL~NW//WB$(1l;2n2u5*9B@%@,MaMeN&Sq_+c;f}l0(B")
("lb"    "$(02%5-5.HBHQLoObPbPhPsR$\;]%$(1.v2e2w9)939>G3$(0&[$(1G4pOG9GBMwN#SvS|T"T-T3Z/Z8ZG_'_(_/_?c4cAcGiy(B")
("lc"    "$(0D7D9D|QpR6T,U5ZI$(198;YB`BaIyMd$(0@|$(1P9oLT$T)Z`_&c*c/c2c7fifuirl8l9(B")
("ld"    "$(0G'L{PcPq$(1-N-O2a9@<k@-@/$(0Cv$(1G5itG8G<M^MkMmSkSuT0VvZ+ZH_2c?fvg!(B")
("le"    "$(0?8J`PePo$(1&P'd2`2y3!95G-Mh$(00k$(1Miq_MvN*N+S~T!T#T6_1cBiwl:(B")
("lf"    "$(0T-R)U9$(1ou$(0W>Zw$(1JcN!P;P<SnZ-Z5_)_-_Bc0c3c6nl(B")
("lg"    "$(0<*?,CsCtHCHTNVPiW9:3$(1;XpNG.G=MqT+_>fliupM(B")
("lh"    "$(05R:.K$Lr$(1(j2j2{9DG0I{N'Sy_0_F$(01P$(1c,(B")
("li"    "$(0*f:-?4HGT3Y:Zq])$(1-K-P5+9$9,999;=l$(0)~$(1G7quMfM{Z7\g_CaRaSc1c8cFfpf{l2q:q;(B")
("lj"    "$(0:,BWHIJ\L}PjQET2W7W8Y9$(1-HMtP:T'T._@c-$(0:($(1cCfzfo(B")
("lk"    "$(0(B:':2AZCrC}HDO0W;Zx$(1&O2c2h$(0(9$(14QnU9&9<@!@.IzMxStT*T8Z)Z2Z6_D(B")
("ll"    "$(0'[(t*l1Y:)LqPa$(1%*(i$(0&V$(12fix2k2v@~G2MuN,SsU#Vy_,(B")
("lm"    "$(05w=%?-?0?3?9BlJ_LKW?$(12p2x9-$(05N$(194oN9C9HG1McMrSjZ<ZI_.fjfwoJ(B")
("ln"    "$(0:oHLJ#PkPr$(1!Y#.(h(k-J./2\2i2z?x?{$(0(R$(1DjT&(B")
("lo"    "$(0Zs\:$(1&Q2]2b2t9+9/9?B_G/G6$(0)?$(1GAivM`SxS}T4T5\h_Ec5cDcEfxf~(B")
("lp"    "$(0*4/A:4<>?+A,W@]*$(1-I2_2q97Z4Z>_*_3c.eMm|$(0("$(1n#q9(B")
("lq"    "$(01/@}$(1+y9:$(0*X$(1?vq<@&@0MlT2(B")
("lr"    "$(0?.?/CuCwCyHPHVLsLvM!/.Pf$(1f|$(0T5Zu$(1*3+z9'9(929=9A?z@*@1@2@3MgN%VwZ(Z*ZFc+(B")
("ls"    "$(0T+$(1$o9%90$(0?2$(19Ic)Kn(B")
("lt"    "$(08xKqLpW:\<^H4\$(1*2pP?wG;Z0Z1Z=m~(B")
("lu"    "$(053?;@{ElHHHKHXLmLuT4Y8Zr]s$(1!6#k#l.w2^2d2g2m2o2~8]?~@+$(0&+$(1G>r5M_MoMsM~N$QASmSwSzZ9_Ac@dk(B")
("lv"    "$(0;`<)LyPnT1W=WD]($(14^?}@6G+$(05O$(1G,oKG:MnN"SpSrS{T1Z.`XfnfyoH(B")
("lw"    "$(0?:@zCx(rNX$(1oM$(0PdY;Zv$(1%29*MbSlT/fml1(B")
("lx"    "$(1Bb$(0CI$(1Mpm}is(B")
("ly"    "$(01g$(1So$(0Lx$(19.N((B")
("m"    "$(0&"(B")
("ma"    "$(04H6R7n84*LQ)$(1gj$(0QVRn$(10s<N='>.>=E"EOH5XQ[)][]p(B")
("mb"    "$(0)C0w8a9">k'`B}$(1mc$(0G-G0GVN0OhQg[~]>$(1"p,60w747=D}EUEYL5L=N;N\N_Q>R.RKUXXOXpXu[&[']yb/c{dlf#f-lM(B")
("mc"    "$(0:D@"B_D{GQGSHsIaIcKfK{SCSWU"U%VOXX[L5y[}$(1pE$(0]w^=$(10n7::K>/ARK0KxNqQ<RLRM_]`Fb.b0dEehf1g5gkiIiNj](B")
("md"    "$(0258%838b>?B`BgC6DXKxMLMOQTS{TwVB\"$(1$j(B.h0x3E6A$(0&A$(17?pW:J>+>P>WEPEREXH_K{K|R2R5RPRTU+UY]W]t]u_qecf$(B")
("me"    "$(00@4*4E6p9$>!?HG.GTMMNhTIVAX%Y<ZN[3$(1,P,Q,V1A6@9x=%>(>)D|E&L;L?U)U*_tb1eH$(0,g$(1h5qHp^(B")
("mf"    "$(0(}6Q8U=p>BKgKzP#R*SFVR[4[Y]5$(10_>">$OLQ?V2V3V6V9XmXn__`~a*a2b*c|e"iMk+krm'm*mboYot$(0&c$(1o~r@qOqn(B")
("mg"    "$(0*^0t2O8_8c;T>"AYDsDtGXOjO}QhTxUM[F'_^"$(1p_%[)<)Z1D73767^>R?<ALN]U-XTXo_skpm`(B")
("mh"    "$(0,14G4f4hG/OF$(1!%"%'M(*(-):+I,*$(0'\$(1,Nlu,R,u719y>MANDzD~GCH^J)L8R/XqXv]Yd!gm(B")
("mi"    "$(0'Q(j(l1#4F5%5P9#:J:[<SB%B^DyHJI\KhKwMwSDSUT/VQWkZM\R^g^x&j$(1!fpY$k,.1E1H1I3D7>>&>Q@#EVJ?KyMjN^R4RQU(XSXw[_bJc>f/gliJl3l^(B")
("mj"    "$(0(N8~C~G2GPGWOg&\QU$(1j6$(0Qn]?$(1$i()(0(=)9);,/0o3C>UR-TQWn]X]w]xb4bGgMgo(B")
("mk"    "$(0,S,V0u0v3J3s55<{?iAWB~DxG4J&K`\Q_=$(1#Q$9'L(,$(0'3$(1,tq,0m0z>-E%HaK2LAR3ROXlXt]Z]v_a`IbHf%g"l_pB(B")
("ml"    "$(0-Y-Z3L5t9%:p=~G,I<Mf]{^O$(1!'!2"r"s"t$l%,(.(u(w,-,5,9,S-]37383::x$(0*U$(1@xj1H.H/NTNUcze>gi(B")
("mm"    "$(0&6&W&l&m'b(`)(-]-j0>1h3r9&9(?|B&BkDWGYOiO{S&SvT_\t^q&)^r$(1q|#6#j$m(>+H,0,40y1@3#3t6C>ND$DwE$ENH`KwL7L:Q=]9^S_wbF(B")
("mn"    "$(0'{)E)F.05m;,>$>@BeE9G5J$Kj$(1!)!|"e(2(@)3.00t1B1F$(0&$$(17<`E@LE!L>[^(B")
("mo"    "$(0,(-,-J.&4i9'@=BaK;SGSHU~V?XpZU$(1(l,M0r3$6B757;9J>LC}D{ELG]GzN<O'R,R1[(]Tc]$(0&w$(1dGj4f2gN(B")
("mp"    "$(04I7GA+BcBiJh[^[z$(1#w(+(A,O/#0q1=$(0*<$(1A%qbR0W$a8j3p`(B")
("mq"    "$(0SEVN$(1/~0u$(04K$(10vDy7Y>%B~(B")
("mr"    "$(0(|+A+B3t4C6Y6f8d9!BfBhGUI=I>KiKyMNO~R?TvWi]@$(1,+,,,3,70}1?1G7278797W7\7_=(>'>*>,>VA&A'A)DxEMEQH4I/KvKzL@RJRSU'UW]V]r`G`H$(0(,$(1bDpXc}(B")
("ms"    "$(0'}(J219)?}O|UE[G&b$(1!&_v!.#777?=A(AMXs(B")
("mt"    "$(0-I0}4D4[,.4g$(1jX$(0P"VPWj\K$(1"<,10!1>9TK1RNWmXR[%_`_r_xb3b5c~f.g4(B")
("mu"    "$(0&x'.0s8`9*:Z>#>>BbBdC!G1GRIZI[KeQ'QWTyT}X$Xg$(1!+!?%Z(?)8,2,80p0{6?7[9U9w9{=&>#B^E#EWN-N.RRU,WlZ%]qa>mf$(0&C$(1nB(B")
("mv"    "$(05&5S=}C|K|P!QiTuV@Yv\x\y^Q^o^s$(1!$)w7Z>K>O$(0-R$(1G^jWL6L9[]\bdFj5(B")
("mw"    "$(0G3IYYh$(17XXP]U$(0*j$(1]siKbEbKf&(B")
("mx"    "$(0^!$(1b2(B")
("my"    "$(01eQjTz$(1(/$(0&7$(1,UET.30|>0(B")
("n"    "$(0&_(B")
("na"    "$(0DkR([U]L$(1:-$(05r$(1EKqKT=`xk$n`ndpk(B")
("nb"    "$(0DlDnISTrUSU[5*X/$(1qj$(0[V$(1(}-e.}2452:1V*`Ddqdzh9j|k%lxl~nVojopq=(B")
("nc"    "$(0&R$(1qL$(05YITI`JD$(1HYPAUTUe[g`,`ShDjSlyn[(B")
("nd"    "$(0(F*$3\8+:gS\$(1"4"w-i:0Cm$(0&N$(1\#qi].a"d{hBhFjzk"n&napi(B")
("ne"    "$(0-c.+1c?s?zBv]M]t^.$(1!;!`&S,A9L$(0'0$(1N1okN3PiV/dyh6h7j}o)(B")
("nf"    "$(07#@$G"MaMcSAU<Z%[Q[T\[]Q^--&$(1"5ov0Q4t51ONU{`C`zhUjrk1k<neoO(B")
("ng"    "$(0,--F:e:i?uDpNCNDX0Z"$(1:l$(0&a$(1AGr;AIGEOyhCk'n](B")
("nh"    "$(0DmY>$(13J$(0(z$(1HrdwV)V+\"(B")
("ni"    "$(0(Q)j.#/91O1b<1?1?vPgV!Zt\>$(1&T(yB{B}GLH\M}OJT%\$\)_7_8l{man\ogoh$(0&K$(1qh(B")
("nj"    "$(02}:c<}?wMb*kN_$(1nY$(0^,$(1"xJ(dMg%(B")
("nk"    "$(0+w2Z4UX.$(19KAE$(0&5$(1O%lzPfV,[[dtj~(B")
("nl"    "$(0'@QRZ#$(1-Q-f$(0'?$(19sj2@{N2V?\&`y(B")
("nm"    "$(0)#/81a7@:hDoDqRTZQ$(1%0&U$(0&O$(1(|pf.|4s?+@:@<HZO&OKV(\%\-l|nZol(B")
("nn"    "$(0&i-d4eA%C7J"&($(1"ye<-hAHI*V&b6(B")
("no"    "$(0&P'O(u.w/:/V2g5{:d:fD0DjDrTHTqTs^Z$(1-d3I$(0&=$(1=#oo@;\'`|h8j{n_(B")
("np"    "$(03+3-<=X![D\Z$(1%.J;OIV.\!d>$(01_$(1h:r?h=(B")
("nq"    "$(0--2{5sHY*aX-$(1k#$(0^Y$(1!1_J(B")
("nr"    "$(01`;]?rHj[W^X_A$(1&R(z:.>IGHJ'T<\*\+\,\.`w`{`}a$$(0)Y$(1cZqkdrdxh;k&lw(B")
("ns"    "$(0-`2.2/5T;.$(1!i({-gV'\($(0&&$(1n^(B")
("nt"    "$(0.v4YBuIR-b_B$(1pg,BH[\c(B")
("nu"    "$(0'7)O*d+.-a:b>.?xR'U6U@$(1!Q"v#s%/%1&7*11;$(0&#$(1GFphGGL1P8T>UUV-Wq[!a#dpdsdudvh<l}on(B")
("nv"    "$(05q<0D~$(1&5:|$(05p$(1ADpjAFW!hAjy(B")
("nw"    "$(0?t$(1omh>m!(B")
("nx"    "$(1"$`Boi$(0?y$(1qM(B")
("ny"    "$(1:/$(0(A$(1hE(B")
("o"    "$(0&*(B")
("oa"    "$(0-w6.67:s:~Ab+%FE$(1qp$(0IsIwN&UD$(1%A3d3fA]I']oj[(B")
("ob"    "$(0+*-z-}.!1p1q6*6,6@:|;$>m@-E,G^IiI{I~R1U-VM$(1!t!y'O))-x3W3[3]3i:;=-AcH~S0Ul$(0&z$(1`ZaC(B")
("oc"    "$(0-s66;!?M?ND=E-E1HvI}MkN$QqR4U$UB+/$(1!5r"#*-p.!3b:9:?AgH{I#\Fd:jejfjgkPnE(B")
("od"    "$(0'm)3+(-~1r1u86=?@.DvQv$(1+F/w$(0'k$(13Sn~:AH|I!UkWh^NdZjh(B")
("oe"    "$(01l1w:j:vB*E"E4UAYeYt[O$(1!j"Y$(0)<$(1)!f,)b-o-v.\/Q:<AaOWUo[i\Hev(B")
("of"    "$(0+$1|:tB)BQBSGtIxU;Vn).X2$(1r6$(0X8Z$]O]Y$(1!U!w#'-j-m-t-{0R0S3^6~:=:>A[A^AeAiD[I$OROSV7VD[h\9\Ea/a3e;h`m1o!oyo{(B")
("og"    "$(0)7)A*o+e-p."1d1}@`E!E2IW'lIt$(1p]$(0I|\d^e$(1%<)+)-)1-z3U3`3a:8>JAJOPUVVA[\`_g|kOmooQ(B")
("oh"    "$(0)%):0B6<E3&,E6$(1lg!v"zHj\J`\(B")
("oi"    "$(0'p'r)&)2+',e-o1{6&@,@/E/LtN!QtR3U*YuZ,\T_/'j$(1!pd[!s"}#()2-r-}3c3kHyJ@(B")
("oj"    "$(0'*($6+6?<|@1MpN"Y'$(1!m$(0&p$(1"{`Y%:-k-u3K3h:EAZA\I"[a(B")
("ok"    "$(0({)/)4,T-q1m1n1v6%698:9O'n:y$(1g~$(0;%<x<y@2E.MnUn]X$(1#$%4)&,L3P3g:C<=ATAjO9OTOY`[``(B")
("ol"    "$(0)5)8*{.<.U1X5k;'$(1!_!q!x$(0&v$(1!z[$"X$K%K+N,KA"A$HkU%Un(B")
("om"    "$(0'd)1);*w&o+!$(1lf$(0+&1~5!6(6-=H>`>dB+CFE0N#[P$(1!F!G!H!J"~#")"-|3_:::@F8OQ`QaF(B")
("on"    "$(0&q&s&u)-*p*t-t-y1z2!3x6061:k:u;"&@;#$(1`a$(0@7CUN-N.$(1!4!B!I!o!}#!%7%8)/)4-s1"3LI+V@VC]^(B")
("oo"    "$(0*Y*~++-{1o1s89@*E$IyIzN'S%$(1!l%5$(0)0$(1%6nH(L-n/{3ZAfAhD"H}NKO[VB[k]8`^(B")
("op"    "$(0'o)9*q-r/C<@<A'(E5$(1n}$(0E|M~RXU+\c$(1!r%3%>%J&[*B*O-~.n/$3X58:5AdOZ\GaDiH(B")
("oq"    "$(0*"*s+"-m6)7W)687$(1i<$(0:z:{L[$(1%G+~I&(B")
("or"    "$(0)Z*u$(1jd$(0*v*x*y*z*}+)+W1"1=1k1t1x2"6#6$6/65686:6A:x;H@0IfIgIvMqU)$(1#&%9%?%@%D%H%L%M)$).-y4(:7?%A`O8O:OXQ:g}(B")
("os"    "$(0),*=+#8}@+&tE%$(1Hz$(0IV$(1!3"|%;)((B")
("ot"    "$(0-x*n-|$(1mr$(0>6B|K<MoR2$(1#)%E*=3V?$UmXadYjc(B")
("ou"    "$(0*P-v/*/+6'62646>E#F]IhIuT7\S$(1!K!X!k!n!u$(0'q$(1#+aE$J%B%C)%)')*),-l-w.u3j6D:B:DA_BZD(HxOV(B")
("ov"    "$(0-n5|636=88:w:};&?<GON%QuX*$(1%=%I&6(~)#)0-q$(0*r$(12}qJ3R3T3YAbOU[j\I`]e:(B")
("ow"    "$(0N(UCYs$(10($(0*|$(13QI(3e7A9z>4(B")
("ox"    "$(0R5U,$(13\(B")
("oy"    "$(01y6;$(1##$(0&r$(1#%+O%F(B")
("p"    "$(0'A(B")
("pa"    "$(0*1/K4V<INp$(1'3*I*M5D;dJ1J6$(0*0$(1PL(B")
("pb"    "$(0227L<FA3A5JpU`$(1&_/'$(0/I$(1/)PR/,5J;lBqBrJ3PGPPPQ(B")
("pc"    "$(0@#E}IbJlNsSZZ6$(1&g$(0/H$(15IeO@QBnBvBwPOQDQl^AaVa[(B")
("pd"    "$(07S<O<QF!F#RY$(1%W*Q/+//1n5>5B;i;kPN$(0&?$(1W(W[(B")
("pe"    "$(0JjJkOt$(1#{$!&l$(0A8$(1/-o,5@;m;uBuaWaY(B")
("pf"    "$(0A;NqNtNu$(1$&+s5:5=$(031$(15Fo+BoJ2OAPMV5\5bchTk/m-(B")
("pg"    "$(0/J<NA9IXNmU^Yf\k$(1#O*H*S/*/0J0$(0,:$(1J9l<Oxk[(B")
("ph"    "$(0''(S7Q<LJo'#$(1!\PI&\+K;jJ5(B")
("pi"    "$(0'&*&&E,;$(1aX$(0/G33F%$(1&p5?BpJ/PT\q(B")
("pj"    "$(0<C<G<JNr\l$(1"C$(07O$(1#3W*#~&];e;hJ.PJ(B")
("pk"    "$(0)K,9/ENo(!R\$(1\r"A$$*C*N5EBxJ7J=W,(B")
("pl"    "$(0I:Jn$(1#}$(07N$(1$%;r(t*k-_(B")
("pm"    "$(0/F/M/P32A1'%[n$(1rK&e&n59;oJ4J>(B")
("pn"    "$(0+6/OA4A:$(1!"!7$(0)H$(1"BaZ$'*E*L:I\n(B")
("po"    "$(0Kk$(1$"&h*K$(0A/$(1+G\s;sW&W-\p(B")
("pp"    "$(0/B/N<PRZR['S$(1$#PK&`*F5G5H;a(B")
("pq"    "$(0NnH!R]$(1,<&m(B")
("pr"    "$(0/L3/3435367M<D<MF$$(1&^&b&c&j*J*P*R-S/15;$(0(<$(15AW+:H;pJ:J<(B")
("ps"    "$(0A0A2Jm$(1&i&k3r$(0+:$(1I,(B")
("pt"    "$(037F"'aF($(1/&*D(B")
("pu"    "$(0'~,83.7R';9q$(1W'$(0<BA6E~Z7$(1#z#|%X&d&o'N.2/(/.5<@7BsPFPH(B")
("pv"    "$(030<E<H<KA<Z5$(1&a/%2|;g;q;t$(0*%$(1J8hxW)a](B")
("pw"    "$(0;1A7$(1&f$(0-0$(1*GBm;f(B")
("px"    "$(1Bt\o(B")
("py"    "$(07P$(15C#y(B")
("q"    "$(0'D(B")
("qa"    "$(03A3O<^ACAfJx$(1$.$(0/j$(15qad<,C,C/JCJMJVM*(B")
("qb"    "$(07X7[7a<b<fAHATF-F9JsPKRjRl\n$(1$4&w&~*e/9$(01f$(15[a^5_5a5e;{<*<8C&C-C3C9JDP_PbPdYR\u(B")
("qc"    "$(03B?KF5N~XDXJ$(1/H5P5\$(0(W$(15gmSC)C.C?JQP[P`UNUf\t(B")
("qd"    "$(0/o7]98<Y<h<i<jADF0RhT|$(1"D"G*Y,v/7/?/O$(0*V$(1/phy5i<'<0C@CAJ\Q/W7a`(B")
("qe"    "$(0,I,N/_8;<gAOF1F3O!O&,AUm$(1k~$(0XF^9$(1$//8/D0B5U5X5dJR(B")
("qf"    "$(0<U<qABAPJ|O$O(O)Ui$(1$-*g5Q7!<!>zC0C:CBJJ$(09E$(1JKq2JPV1achJo-o.(B")
("qg"    "$(0/Y3G3I7`7d<_<eAJJzNzR`Ul]b$(1*[*h/E$(0,D$(1/JmP</<6C%GJP^eS(B")
("qh"    "$(0,M/gASJ},>$(1&zJ[/M2+JN(B")
("qi"    "$(0/i/s3>,G3v$(1p9$(09UF2F4HEO+Sw[q]&$(1"K"L$+&v&y/>?|JGPYP]W3\v(B")
("qj"    "$(0,@/\/d7f<aAKAMJtO,QFRfXG&e\m$(1W/"E"H*f/F/N5O5^<2C*JSJZPa(B")
("qk"    "$(0,Q/a2W2X7e<X<oAE,CAF$(1\w$(0AQJrJuJvO%XI$(1"J$5'!*W/G/K<"PXW2W4W9(B")
("ql"    "$(0,P-[/f7cO#XE$(1$8%+$(0,L$(1&}cy*X/<9u<%JHW8\x(B")
("qm"    "$(0,K/k3=3D7^<2<VANF+JyR_$(1&u&|/I$(0*,$(15Sh{5T5b;z;}C2C4C<(B")
("qn"    "$(0,?,J/[3:7g<dUh(U$(1"IeR$7*`*a5W;|;~<.(B")
("qo"    "$(0,B,O3H7Y7_<[<mAIN{O-RdRiT{Uj$(1$0&x'"5c<+JLJU$(0'4$(1NJh|PZ\y(B")
("qp"    "$(0,H/Z3@<nNdRcXHZ9$(1$1&{*c/!565R5h<3Bl$(0*-$(1C5mRJEJTPDa_eP(B")
("qq"    "$(0/X7V<\N}.aRb$(1Pc;x;y<(JW(B")
("qr"    "$(0/^/`/c/n/r3?*+3E$(1Pe$(03F6Z7\<p>fF.F/F6M(RkUk$(1*^*_,T/:/;/B5M5N5V5Z8E8F<5>TC(C;JIJO(B")
("qs"    "$(0/]/b/p3CE>F,N|Re$(1!^*Z*]8DC$$(0(V$(1F:YQJF(B")
("qt"    "$(0/l3<9VAR$(1&t$(0/W$(1<-eUC'C+C6P\(B")
("qu"    "$(0,E,F/h/m7b'E9W$(1UZ$(09X<W<]<`<l?>F7F8O"O*]W^:^`$(1"F"M$*$,$2$3$6&s/6/=/A/L5L5]<)<7C8C=JXJYO((B")
("qv"    "$(03;1Q7Z$(1q!$(0<ZALJw[o$(1*\*b*d/@5`5f<$<&<4C1G@I]W0W1W6^TaaabeQeThzk\(B")
("qw"    "$(0AAO'Ra/eRg$(1C#$(0[p$(1<#<1(B")
("qx"    "$(0AG>pUg$(1C75Y(B")
("qy"    "$(0/q<c<k(X$(1$)mQ/C(B")
("r"    "$(0&H(B")
("ra"    "$(0;:;A$(1qA$(0EEJ4Q<UHX<[)$(1)Q3~:L:T:YCJObOgTeVOZh\Rceclg>(B")
("rb"    "$(0+R6T6W6\6h;?@A@D@NJ(N4N6R<TLTPUIYFYG$(1$v%`%e%m3}:WApAtAvB&NFNGOeOqTp$(0)S$(1ZolEZp\O_icfcmgC(B")
("rc"    "$(0(=2D5\6`@yHyJ)J2N;Q8RAUJYIYp]y$(1%f.8.=4+AqAuAxAzI=OjOkOpTf_faKcjeDgA$(0(8$(1kTqamI(B")
("rd"    "$(0+E.A.L2B2I6b@JEBH~I#Q:Q=RBTO\H)U^5$(1n1"&)E.B.J3,3x4.A{A}A~I<NDTlZk(B")
("re"    "$(0+V.O6[;IDGRFTM$(1.;3u9\9^:NAyB#CCNIOm$(0+O$(1Tgr/TiTn\P\QaGaIg@pSqz(B")
("rf"    "$(0@UECEDEKEPMxN3N5R@Z&Z-^{$(1#=$(0;B$(1#?ow:Q:XI1I2I7OoZr\2\Lcgk6nt(B")
("rg"    "$(0+H2?6^;E@H@TTQX#]1)T]\$(1qB$(0_<$(1#>)@.@.I4-:Z@XGqGsGxI:TdTmVH\UaHcnkSkUn/(B")
("rh"    "$(0+K+N+Q+UJ5Q;(2$(1%\Zn.4.::O@`NMVL(B")
("ri"    "$(0)].M6d@PEIF*J0N>Q9R^[([f\I\f]0]Z^^$(1#8#;%]%n%p$(0)V$(1.En.3*@aB!GrOaOiVMcohnmG(B")
("rj"    "$(0@K@MEOJ6N7YJ\e_*$(1#@%j)>)J$(0;F$(1.Dck3y4$4*<AI;I>OlOnTaTj\T(B")
("rk"    "$(0+S272:2A2L6_6a6g;L@Q@V@WDCEM+GI"$(1j($(0J'J1RHW\ZK[e$(1#9#<)H*j9]I4OfVKVN(B")
("rl"    "$(0(6+Y.G.H6c6e:X;KDSJ3MI(1N<$(1[#$(0]x$(1#E.93>:P:\:_H0PjU$["(B")
("rm"    "$(0.D(3.F$(1n3$(0;=?R@@@L@OE@ELN8WYWZ$(1#C%^%d%l%o)=4%@_I3I8ZleA(B")
("rn"    "$(0)[+2+?+X.J2=2K6X@I@RUG(0$(1#0Zq%_%a)I.H3+4"B%GpGwI6O\(B")
("ro"    "$(0+M-N.N2>+C;<$(1j'$(0?S@XDFH}J+J-N:RERGUFUKYH['[*$(1)D.6.?.C3v3|4,NCNLOhTcVPVQZmcp(B")
("rp"    "$(0(b)^.R;GDAEJF&R=[b$(1#:%k)N)O@\GtGu$(0(:$(1NEoVOdToch(B")
("rq"    "$(0\J$(1#A)F)P$(02J$(13{lF:`@WVIg?(B")
("rr"    "$(0.B.C.E2C2E2F6V6];@;M@?@BDHEHENH|J,M:N2Q>Q@RC\g$(1%b%g%i)?)B)G.A.G4'$(0+I$(1:UaJ:a@Y@[@]@^AsA|GyI9L<T_TbTh_j(B")
("rs"    "$(0(>.T@;DBH{(7N1$(1B'$(0TN$(1%c%h)M(B")
("rt"    "$(0DD;;EG$(1eB$(0N9[+$(1#B.59[:[@ZArB"Go\N\S(B")
("ru"    "$(0't+D&Z+F$(1qV$(0+P+T-X.I.K2H;D;JDEHAI!Q?[,[-$(1#D.>3z4!4#4&9_:M:];KB$B(GvHwI0L2NBO`OcT^]:aLe?n0p5(B")
("rv"    "$(0@EHzJ/RDRI[c[d^&$(1)A.F3w:S:^NAT`TkVJZj_ggJmHn2pTp~$(0@C$(1q@(B")
("rw"    "$(0R>$(1.7:V$(02@$(1G{pVZi_hgB(B")
("rx"    "$(0N=W[;N]2$(1eC:R\Mci(B")
("ry"    "$(0;>EA.Q$(14)NH@b(B")
("s"    "$(0&T(B")
("sa"    "$(0>eNRY*$(1O>h2jvlinJnT$(0;t$(1of(B")
("sb"    "$(0/-7.;6CNR#W"W#[R[S^'(#$(1)zr48HVxYP`m`raOdjh4lrnN(B")
("sc"    "$(02GJ%Q0QyU'Vw]~^*^w_9$(1&;Ud[P[ebjcacd$(0')$(1d\q}j`jwjxp8pc(B")
("sd"    "$(07$@mIjUz$(1!M<j$(02n$(1P,r&[|`od_f<h%nM(B")
("se"    "$(0.>,"70$(1ls$(0E'F\NSOHX,$(18>O@PgS#V"`jd`h)h,jm(B")
("sf"    "$(0:lK[9ZL<$(1r>$(0OaYz\Y]F]H^0$(16s=dHtM)OMV;XD^La5aPe#e+fEgehPhQk0ninrnsp)puqPqg(B")
("sg"    "$(0/$2q;SE?G|LLQxRJ$(1Jd$(0)L$(1VYr3[p[t`sdcghh.hlob(B")
("sh"    "$(0N+$(1""2)3M8B$(0&/$(1UpltUzV!`idill(B")
("si"    "$(0;q>h@sNvQ~XCXfY{\X&D\i$(1jo2,HnMyUwXN_9gxja(B")
("sj"    "$(0I)LJY+^S$(1.m?,HlI.S$Uq[n[o[z$(0*W$(1^RnQ`e`l`ujiljlonKnO(B")
("sk"    "$(0,RIkMrQzR"$(18A:*O=$(0&h$(1OCnRS!S([m[q`ph'jklq(B")
("sl"    "$(0*\+;-\1V5(:V>gDVIlWh$(1"u#52*9o?-?9$(0)M$(1NWq"OBU"^\`h(B")
("sm"    "$(0*RVv$(1,r8GM+M,$(0&0$(1UsocUtU}YSjqlhnP(B")
("sn"    "$(0..$(1i`$(0SI$(1!V"#%Q(K2-3n3sS'`tb7h#h1h3(B")
("so"    "$(01;LNODU.^T^v$(18?A@F9IiS&[rav$(0':$(1d]j)h(h*(B")
("sp"    "$(0,!,5,72p7FNfNjQwU4Vz]p_H(H$(1Hmlk\ld^jl(B")
("sq"    "$(0G{G~UfBY]!$(1nI;wQ~h&(B")
("sr"    "$(0(4(5+J+~/#;4;5CHQ}U0U3W(Yx\@(/]E$(1h-%Y4w8@?.EZUvUxUyU~[u[{`kdddefNh+(B")
("ss"    "$(0.5G}X+(I$(1#1Ur8IOE(B")
("st"    "$(05#;u>c2oKr$(1bA$(0Q(U/V{^}_8$(1">8=HoVF`g(B")
("su"    "$(0&Y'x,#.%/"9YImMu]+&X^($(1r%$t0"0%@9O?OFS"UOV#[s`ndbdhjnqo(B")
("sv"    "$(07/;_JYUUWEZy_1$(1"-)74rBN$(01\$(1I_r'M'VcZB`fh$h/jjodoer$(B")
("sw"    "$(1&<$(0YQ$(1Uujp[}(B")
("sx"    "$(1nL(B")
("sy"    "$(06O;v$(1da(B")
("t"    "$(0'>(B")
("ta"    "$(0:"=+A\CbO1P_/xW1$(1mw$(0Y3Zp$(1?\F}G!G&MB^|`Lf^(B")
("tb"    "$(05A7v?'AgC^CeG]H.H4H:J^L^L_LcT~Zm1L$(1([my-B.$2A8k8n8{?f?gAVFsFvM@MDMEMLMQS9SKSQS_YeYkYqYvYw[`^`^tc&c'fXhdi^ijl/(B")
("tc"    "$(0-e.(.)6BE(\7_E$(1?T?eFqM;M?S;UcYiYl$(0)B$(1Yoq~Y~^d^e^f^h^lbfbxfZf\gtiij^oEpa(B")
("td"    "$(03]9w9~:#>x?&@lB!CfCiCmFGH5H>U|X&YiZo[j\2\8]"$(1%!2M8l8v?Z?pFTF~J|M6MAMJO.SVS^YdYt$(0-C$(1dNl'l#(B")
("te"    "$(01KC[C`CgCoH=PXP`T*X;Zn\h$(1(`(e2&888a8t8w?O?R?Y?^E>$(01C$(1F7o_FlFuG'G)HdMMM[M\O1S8S<S\SfY{Z"^g^q^u_#fWfbfcink}(B")
("tf"    "$(09Q?%FuLdLfLgPRP[S;T'T)Y4Y7Yj[Z]G^F^R_7_J$(1(c-@?LFVF\FnL~MGMXR}SDSFSPSXS]YOYx$(01J$(1Y|qQZ$a'a+brbyc$c%eyfYh?ipk2k;k?l-m$m%njoFo`oro}p!p$q6(B")
("tg"    "$(0:%;X>a>~ETH;J<QmY6[E\5^G$(1${->2=2E2V8p8q8u?bAKFtM=SLS[YfZ#^w^~$(09{$(1a;q7b{c"d@igl&mxmzoA(B")
("th"    "$(01F595?;+>uT%$(1"l(_-0$(01B$(12'r88f?aMTSOScYu\B^j^n(B")
("ti"    "$(01I5I9|>b@rCpF)GyJXLiPTPWPYPZW,Z`Zk$(1!E%#%$%U(f-?-A-E2N2X8r?W?d@"AQFXFzM<MCMFMKO,SCSESHSTYhYn^p^s^}_!bvc!c=fU$(0-D$(1fqr!frl4l`m{oI(B")
("tj"    "$(05@5u9v9x>wCXCZC_F;H/PUP]T#W.W2$(1%"-12;$(0',$(12?ik8x?(?cAOFeFiG"H%J^MYO*S@SYW=Yr`MfT(B")
("tk"    "$(0*e$(1l.$(05"5C9y>|@eAXF:G(H2MhPSW3YkZgZl$(1(S(X(Y(^-2292J2O?UFRG(M9MNMZS?SB^y^{a=b}fh(B")
("tl"    "$(01D1G$(1lK$(05LA[MKQQT^W+$(1(v-Y2U2W<C?VA!HbHcNXPkS:SISbT~Y}^o_pgKgLimjY(B")
("tm"    "$(01M5K5l7:>zCEH1LlMgW/Y0Zf^$$(1(g-9-C282@4?8:8b9!?E$(0(m$(1?JpL?Q?kF6FmFoFyM>MIMOO/S%SASNSSSWYm^i`J`bill(oB(B")
("tn"    "$(0579u>&?"JCSJW5$(1"k"m$}(T(Z(](b-4.,2<2C2L2Q898;8~:3?)?S?X?tFSFWFfFhHeMPR~Ygbpbwb~fV$(02*$(1fdl*io(B")
("to"    "$(01@:$>yB#CcCdCjGzK:LaOET$\G]d$(1(a,p-:-;-=2:8e8g8y?*?F?N?nD#MUMWSGSMS`SaSg_$bsbtbzdIfKf[$(01?$(1l)q5pU(B")
("tp"    "$(01H7D7IEvEzI^NgP^T!T"W4$(1$|(W-3-D2>2H8_8j$(01E$(1;bo*?[?uFkG$J+MRMVS>Yp\k\m^b^caUf_faffifl%(B")
("tq"    "$(0H3NyUd]$^#$(1/42Y?MFw$(0*Q$(1MSfeO)Ys^m^z_"bqdH(B")
("tr"    "$(05<5=5>5F5J9z9}:!>}?$CDCWC\H0H9L]LhLj\4\A$(1)C-5-72I2K2P2R8h8i?D?h?j?mFQFYFaFpM8M:MHO-R|SJ$(05;$(1TJrGU[U]^r^x`NdKf]fggnihl$q8(B")
("ts"    "$(05:9t;-;/?#E:E<H8SsY/[a$(1"n-<-G$(01>$(12DSR8s8z8|8}?lF[FcFjFrG%M7O2O^(B")
("tt"    "$(0*!8v>{H6LbLeY1\6\9&k$(1!Nmv-/2T8c?P?sFPG*G\O+^a`Kb|dO(B")
("tu"    "$(01A2t585D5E5G5H5}9s>v?(CaClH<I_PVY2Y=^t_)$(1$~(U(V(\(d-62G$(01.$(18^r.8o?B?G?I?K?_?rAPF5F`FdFgF{O0S7SUSeXgYjZ![b^v_Hawiqq[(B")
("tv"    "$(02[4J9rC]CkCnH7I*LkPIQlQsW*\3$(12F2S8`8m?H?]FZF^F_FbFxF|G#M5S=SZU\Yy^kbuc#dJ$(0-B$(1jZoGl"l+oC(B")
("tw"    "$(05BL`P\T&W-W0Zj]#$(1-82B8d?i?o?qFUF]ShYzbg$(0*3$(1f`l,(B")
("tx"    "$(0Y.T(Y5$(1?`(B")
("ty"    "$(0CYCh$(1$z-F$(0?!$(1SdoD(B")
("u"    "$(0&U(B")
("ua"    "$(1*!5$&LImP5IvP0(B")
("ub"    "$(0;~<"71<#$(1kX$(0Ej$(1*/.o4z;G;PIlP4dAdB(B")
("uc"    "$(0UWYq]^$(1&>$(0UV$(15(mN;RIxgw(B")
("ud"    "$(0UY$(14x;JBWBX$(0;|$(1Vpmpi((B")
("ue"    "$(0,'73$(1#c&K4{$(0,$$(1;H(B")
("uf"    "$(09.;w48$(1B[P7P3(B")
("ug"    "$(0<!$(1)}*$;T;VIqIr$(0;{$(1kYq/(B")
("uh"    "$(1#b#d$(0&2$(1;@It;EIn(B")
("ui"    "$(02x75:+<$@v[l\j$(1"9&F;A;UBY$(02r$(1Isn"IwP/ViVtaQgyhs(B")
("uj"    "$(076$(1.s4y5#$(0/'$(15&Vs;NH&IjVl(B")
("uk"    "$(0UX^6$(1#g&D$(0'!$(1J]o'Kr(B")
("ul"    "$(0JZ$(1!,#h#i&C*+$(05'$(1lJlL(B")
("um"    "$(0Ek$(1&A$(0;x$(1&BIu)|(B")
("un"    "$(0,%@4@6$(1#e&H$(0)|$(1*"An*)3o;I;M;Q(B")
("uo"    "$(078@uNUWR$(1){4~$(072$(15!\f;SD!IpP6Vo(B")
("up"    "$(0;}$(1&=**3N;L$(0/%$(1BVeL(B")
("uq"    "$(1;OP-Vn(B")
("ur"    "$(02s74;yJ[$(1&@&E&G&I*%*&*,*-.p.q4}5)$(0/($(1;WhrBTBUB](B")
("us"    "$(1&?&J&M*0;DIk!WP.Vr(B")
("ut"    "$(0NTYC:@_D$(1&N#`(B")
("uu"    "$(0)>79;z<%WF^m'y$(1"7P1"8":"j#a)~*#-.5";C?C(B")
("uv"    "$(1*(*..t5';B;FIo$(0@w$(1VjmMVk(B")
("uw"    "$(14|5%$(0/)$(1;?P2B\(B")
("uy"    "$(1Vm(B")
("v"    "$(0&M(B")
("va"    "$(0;gCALFSpVdX~;eY%$(1o0$(0Zc]A$(14g;->}P&Rr(B")
("vb"    "$(06w9L;b@hEd/1Gp$(1rM$(0JGJHLBLDNLP7P>SnVi$(1#T&+)p)t*64U4q;";$;.;3F&F)IaLoM$P"RsY?\Z\^^=b_bbiZkVpI(B")
("vc"    "$(0SjSoUQVeVt\+\~_?$(14W4l$(0Ec$(1;2q1B;P'P)VeY@b`eJkvkx(B")
("vd"    "$(0)q.i4~<&@iEqGqLCNIO?O@Vm]]$(1&3&8)i4Z4n80:{$(0)p$(1;%o2;,?!BHF#F/IZLkLsVfYHYIf@(B")
("ve"    "$(0+s9J@jEhL:L;L=LHOIP@PAPBVr$(1&V$(0(D$(14Xky4f4k;0F$F%IYIbLrRyV_^HbekW(B")
("vf"    "$(0*O-%$(1m4$(0.sC=C>EeJKJLJML8NKP8Q{VhVpY#^[_K$(11u4a4c4e6}:yB<BII`LmM#P!P#Y>YJ\7^Ga4eKfChXi\k8(B")
("vg"    "$(0+m+t2`2b7!9HCBLE\}$(1&&)v.d1t4]4h8*;4>t?"F'IQRz$(0+h$(1Vgq3\[\a^EdDkz(B")
("vh"    "$(0.q6|9B9NPEVfVs+o$(1#WLv&..c82;!E~F*IX(B")
("vi"    "$(0.l/R4x4{4}6~9K;s>S@~SlURVq\,]'^D)s_($(1qw#S#X&-&4,m1w4j8+86B?BCBGIVY<\`^@_:b[c<p7(B")
("vj"    "$(0;fC:L9NJP=PDVjZa$(1"2#R&')g1|4V$(0)n$(14\ba4m;/BKITLlL|O~P*RmY9^?^C^M(B")
("vk"    "$(0+p0n2^*.2f$(1o&$(06r6x9C>_C8EbJIOdP:Ze^I$(1#Y&),n.].`1v85;)>wB>F!I[L}RnRvRwVa^Bb]eImJ(B")
("vl"    "$(06v6z>ZDUGrP<XK$(1!##V#[&2'$,l.b1x1{$(01,$(1:zN[>|F"(B")
("vm"    "$(0.p4y>[GoPC^C$(1!C!D"/&(&*&/)f.^$(0.m$(14Yhq8,84;(;+B=LtL{O}RoV\V`Y8b^f>(B")
("vn"    "$(0/;2_4|6N>W@fE7]`$(1#U$(0+r$(1(Jo")l.g1y1z8(;';*?#Rx\]aN(B")
("vo"    "$(0.t2cEaL6P?PFVl$(1*?._4T4b8/:~$(0'i$(1>qq4>r>~IcIdLpVbXV^>^D^If?i](B")
("vp"    "$(0.j2a3(7H9I9MEgEiVk^7$(1".$(0+n$(14pq08);Z>xIWLuRuVdb\f=mK(B")
("vq"    "$(0>RCCP9Vo^8.u$(1)rfF*V/50abdfD(B")
("vr"    "$(0.k.o;d>V@kC9C?C@JJL7L@LANHP;X=Y!]z$(1&,&1)d)e)m)n)q)s)u+x.a1C4R4[4_$(0)r$(14di[4i8-8183;#>vBFF+F.IeKmLzP%RtYDYF(B")
("vs"    "$(0(E(O+9+k+l'=7"$(1YG$(09AE;$(1&0)hIU(B")
("vt"    "$(0+q.n$(1mq$(02\>^EfSiXA$(1;&>sE?P(YA\_iC(B")
("vu"    "$(04z6y)o6}$(1pD$(09G:U;a>T>X@gC;L?NMSqY"Zb[h]__:$(1"1#Z)j)k.e1s1}4S4`:}>uB@BBF(F-LnLyM"RqY;(B")
("vv"    "$(02d6u6{;iGsHSL>ROVg[i]D^B+j$(1"0o?)o.f4oBJLqLxV^Y:fAfBmL(B")
("vw"    "$(0>YLG.rOk$(1V]$(0V<X@Y&YR$(1(58.;1BMP+Rp(B")
("vx"    "$(0Y$$(1BLYB(B")
("vy"    "$(0>]$(1Lw(B")
("w"    "$(0(q(B")
("wa"    "$(0Gx]S$(1^P(B")
("wb"    "$(02M$(1fI$(05,6i$(1#H4/40:b?&(B")
("wc"    "$(0>-(??L$(1nw$(0D:ERX(_C$(1OrdW(B")
("wd"    "$(0+[0+$(1%q?'F2YNeb$(0)a$(1q\(B")
("we"    "$(11&<<,>>3\{E-F4(B")
("wf"    "$(0E*PGU:^f$(1,o$(0>\$(1fJqmkCk{nuoxpJpqpr(B")
("wg"    "$(0>+J?R/SrX?-_Zd$(1o#1~87L"^Om;(B")
("wh"    "$(0+]$(11%p(2"(B")
("wi"    "$(04oHFJ7(aZP$(1YL%r7@(B")
("wj"    "$(0'R$(1YM$(0;Q>,GIGv$(1!AVS(B")
("wk"    "$(04N4OU=$(1\z$(0)_$(1aM(B")
("wl"    "$(00x(s4M$(1(4(B")
("wm"    "$(0Gu]i$(1,=2!2$$(0;P$(1F0fMa<(B")
("wn"    "$(0JBLIU>?j$(1#Ie/$n^Q(B")
("wo"    "$(0>9(@U}$(12%.L/z(B")
("wp"    "$(03w7JEtPH$(1#G+L$(03)$(12#V=J-M%(B")
("wq"    "$(08e@Y$(1]`(B")
("wr"    "$(0.W6j9P>*G7X5)`Z)$(1qU.K@GiLms(B")
("ws"    "$(0X7-/$(1\\(B")
("wt"    "$(1B)m=(B")
("wu"    "$(0;O+\X6$(1k|E,F3\@\AkDkF(B")
("wv"    "$(0EQ4L$(1"'m<(3@5RGVR(B")
("ww"    "$(1R8$(0J8$(1R{(B")
("wy"    "$(0Gw$(1F1(B")
("xf"    "$(1rXrWrYr_rZr[r\r]r^(B")
("xh"    "$(1rarbrcrdr`rerhrfrg(B")
("xl"    "$(1ri(B")
("xm"    "$(1rj(B")
("xo"    "$(1rkrlrnrm(B")
("xr"    "$(1rOrNrPrVrQrRrSrTrU(B")
("y"    "$(0&4(B")
("ya"    "$(05e$(1p2$(05xHbHgPzQNT>TEZ{Z|$(132TFTOcMcNeXg+(B")
("yb"    "$(0-;-@1:2u2w?B?W?XI3I6I]L'LRLVM"M/M0MAPPPyQ"QKT8TBWJ(LWe$(1p|$(0YBYN[!_"$(1/R367g9hCDCEGXH)R[TzZPZVZZZ|[~_LcHcIg-g/(B")
("yc"    "$(0)*5X5_HuK"TZT]U#WIYn[J]u^%^4^n_._5$(1@?GcH*HfM]O$T@UaUb[Q$(0&{$(1_[qYcWg,g8h}j$kKmBnDoU(B")
("yd"    "$(0-S-T-k3M5f8&8):>:?:M=:?eGcHeI,,cPw$(1n|$(0P{Q#T<T=WG\C$(1*l9#ElE{GTN9TL_QcP(B")
("ye"    "$(0.?0?$(1p1$(01T?DC+D#D/DMI2J~MGOGTG]-$(1*i+J/P9i9l@uK3T?TDVGX`_N_R_Sb@cQiSj%j0n)oa(B")
("yf"    "$(09D=o?cC<HaMBO^PuPvQLT:T\X:[$[X_;$(17fHsV0\0\}_Za!a&cVcXe8g.$(0-l$(1hHr)hSk)k.mEnnoPo|pmpnppqtr((B")
("yg"    "$(0=-?_?dC*D"DNDQHhI7IUJ:M.MdQ!RM'eRp$(1q?$(0UNYcYdYlZ/^K_!$(1(nGKGNGOTyZMZ[(B")
("yh"    "$(02~?*?@D-FZJeT9,dYA$(1p{(o,)9"9P9gH(_%hi(B")
("yi"    "$(08^:7;j?E@&DPH^MlRSTCTXUbWM["(i\?$(1n!$(0\b^k$(1,c/}3"5k>c@EByTATBZ&g&l>(B")
("yj"    "$(0-Q-U.6.85U:6'H::$(1q>$(0=|?C?Z?b?~D$I+Q$TVTWWbZOZzZ~\*\B]4]o^u$(1(r@tTIT|ZLZOZY[d_McLg0hm(B")
("yk"    "$(0)).`/t2V7h:&:K=!?AAVH?HmM)O.QMWgY?[y$(1(q(s9Q<>@@N7PhT}$(0'G$(1_OqxdTg'g)kN(B")
("yl"    "$(01U5h:<?G?[?\?f?gF<I;1SM?$(1hk"q%(%)/U>bGMH,NRhj(B")
("ym"    "$(0'P-i5M:8=#>)?^CqD&&9D)$(1p0$(0D+H]MFPtPxY@\`^l$(1!08<<@@JAYE+GPN5ZKZQZU[c_Y_ncOfLi|l?m9mFn'o/oS(B")
("yn"    "$(0*m-V.,1i5V6J:=?)E8I8N*R9RPTDXh&nZh$(1ps$(0\E$(1'%(m,:3/33E(GVO]XUcYe9fkkml!(B")
("yo"    "$(05d8f:Q="?]H[I.M%M1Q&R0WcYO]h^3^|$(1/x6<<D?0@DC|GSG_$(0)+$(1K-l@Q;TCTMT{WjZS_oaec9eWj"l=(B")
("yp"    "$(0,40A6":;=$?FEuHZM#M&NeU?]U^J$(1"o#x&Z-V;c@HGQ$(0*;$(1N6rFTGW#ZTaBcSg*mCn,pQr+(B")
("yq"    "$(0H\I/I1T;=uTY$(1W5$(0T[Wf$(134@I(B")
("yr"    "$(0+>-G5`5a5c5g9=:P:R:S:n;9?V?`@>D%D'D(D.DOHOH_HdHiHkHlI5K#M$M+MCMiP~T?T@[#\D\\\a],^2$(1)K-X1a3031357]9j@A@B@F@sGRGYH+ZN_TcKg2$(0(($(1kJr9kLkqoRp3(B")
("ys"    "$(0.47k???aD*H@H`HcM-W6WH[1$(1#4%&-W.19k@=@KO_ZR\K$(0'J$(1cJp}e=(B")
("yt"    "$(02|:T?YM'SNWOZ}$(1-L-U$(0)"$(1@>qXGWLVZWZ~_\dghhkI(B")
("yu"    "$(0)'0~1N1j2#:5:9:L=F@!@tGGHfI-I9KuM*MDMEQOT6V"WKWLYP\$$(1";%'(p/T7T9N9O<E@8@CGUT:TE$(0's$(1TNrDWrZ'Z{Z}_P_UfGg#g(i~kMp4qZ(B")
("yv"    "$(0)m*i-W.f287l:/:0:N?6DRHWI4L&LzM@PpP|TATFU(WAWCWd[2]V]r^j$(1709E9F9G@4G?N)$(0&B$(1N4rIN8T7TKUjZ@ZCZDcRi}j!nG(B")
("yw"    "$(08g:OI0MH\o$(1H'ZXafg1n($(05b$(1n+pR(B")
("yx"    "$(0M}P}(B")
("yy"    "$(0('/v'-5W$(1/S$(0D,M,Q%(B")
;v "z\,"     "$(0!"!#!.!/(B")
;v "z\."     "$(0!%!$!&!0!1(B")
("z\;"     "$(0!'!2!"!#!.!/(B")
("z\:"     "$(0!(!+!3!%!$!&!0!1(B")
("z\'"     "$(0!e!d(B")
("z\""     "$(0!g!f!h!i!q(B")
("z\\"     "$(0"`"b#M(B")
("z\|"     "$(0!6!8!:"^(B")
("z\/"     "$(0"_"a#L(B")
("z\?"     "$(0!)!4(B")
("z\<"     "$(0!R"6"A!T"H(B")
("z\>"     "$(0!S"7"B!U(B")
("z\["     "$(0!F!J!b!H!L!V!Z!X!\(B")
("z\]"     "$(0!G!K!c!I!M!W![!Y!](B")
("z\{"     "$(0!B!`!D(B ")
("z\}"     "$(0!C!a!E(B")
("z\`"     "$(0!j!k(B")
("z\~"     "$(0"D"+",!<!=(B")
("z\!"     "$(0!*!5(B")
("z\@"     "$(0"i"n(B")
("z\#"     "$(0!l"-(B")
("z\$"     "$(0"c"l(B")
("z\%"     "$(0"h"m(B")
("z\&"     "$(0!m".(B")
("z\*"     "$(0!n"/!o!w!x(B")
("z\("     "$(0!>!^!@(B")
("z\)"     "$(0!?!_!A(B")
("z\-"     "$(0!7!9"#"$"1"@(B")
("z\_"     "$(0"%"&(B")
("z\="     "$(0"8"C(B")
("z\+"     "$(0"0"?(B")
)