/* $MirOS: src/include/adler32.h,v 1.2 2013/10/31 20:06:06 tg Exp $ */

#ifndef _ADLER32_H
#define _ADLER32_H

#define ADLER32_DIGEST_LENGTH		4
#define ADLER32_DIGEST_STRING_LENGTH	(ADLER32_DIGEST_LENGTH * 2 + 1)

typedef uint32_t ADLER32_CTX;

#define ADLER32_DIGEST_UPPERCASE

#include <sys/cdefs.h>

__BEGIN_DECLS
void ADLER32Init(ADLER32_CTX *);
void ADLER32Update(ADLER32_CTX *, const uint8_t *, size_t)
	;
void ADLER32Final(uint8_t *, ADLER32_CTX *)
	;
char *ADLER32End(ADLER32_CTX *, char *)
	;
char *ADLER32File(const char *, char *)
	;
char *ADLER32FileChunk(const char *, char *, off_t, off_t)
	;
char *ADLER32Data(const uint8_t *, size_t, char *)
	
	;
__END_DECLS

#endif
