/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Locale;
import org.apache.solr.search.SyntaxError;

public class StrParser {
    public String val;
    public int pos;
    public int end;

    public StrParser(String val) {
        this(val, 0, val.length());
    }

    public StrParser(String val, int start, int end) {
        this.val = val;
        this.pos = start;
        this.end = end;
    }

    public void eatws() {
        while (this.pos < this.end && Character.isWhitespace(this.val.charAt(this.pos))) {
            ++this.pos;
        }
    }

    public char ch() {
        return this.pos < this.end ? this.val.charAt(this.pos) : (char)'\u0000';
    }

    public void skip(int nChars) {
        this.pos = Math.max(this.pos + nChars, this.end);
    }

    public boolean opt(String s) {
        this.eatws();
        int slen = s.length();
        if (this.val.regionMatches(this.pos, s, 0, slen)) {
            this.pos += slen;
            return true;
        }
        return false;
    }

    public boolean opt(char ch) {
        this.eatws();
        if (this.pos < this.end && this.val.charAt(this.pos) == ch) {
            ++this.pos;
            return true;
        }
        return false;
    }

    public void expect(String s) throws SyntaxError {
        this.eatws();
        int slen = s.length();
        if (this.val.regionMatches(this.pos, s, 0, slen)) {
            this.pos += slen;
        } else {
            throw new SyntaxError("Expected '" + s + "' at position " + this.pos + " in '" + this.val + "'");
        }
    }

    public float getFloat() {
        char ch;
        int i;
        this.eatws();
        char[] arr = new char[this.end - this.pos];
        for (i = 0; i < arr.length && ((ch = this.val.charAt(this.pos)) >= '0' && ch <= '9' || ch == '+' || ch == '-' || ch == '.' || ch == 'e' || ch == 'E'); ++i) {
            ++this.pos;
            arr[i] = ch;
        }
        return Float.parseFloat(new String(arr, 0, i));
    }

    public Number getNumber() {
        this.eatws();
        int start = this.pos;
        boolean flt = false;
        while (this.pos < this.end) {
            char ch = this.val.charAt(this.pos);
            if (ch >= '0' && ch <= '9' || ch == '+' || ch == '-') {
                ++this.pos;
                continue;
            }
            if (ch != '.' && ch != 'e' && ch != 'E') break;
            flt = true;
            ++this.pos;
        }
        String v = this.val.substring(start, this.pos);
        if (flt) {
            return Double.parseDouble(v);
        }
        return Long.parseLong(v);
    }

    public double getDouble() {
        char ch;
        int i;
        this.eatws();
        char[] arr = new char[this.end - this.pos];
        for (i = 0; i < arr.length && ((ch = this.val.charAt(this.pos)) >= '0' && ch <= '9' || ch == '+' || ch == '-' || ch == '.' || ch == 'e' || ch == 'E'); ++i) {
            ++this.pos;
            arr[i] = ch;
        }
        return Double.parseDouble(new String(arr, 0, i));
    }

    public int getInt() {
        char ch;
        int i;
        this.eatws();
        char[] arr = new char[this.end - this.pos];
        for (i = 0; i < arr.length && ((ch = this.val.charAt(this.pos)) >= '0' && ch <= '9' || ch == '+' || ch == '-'); ++i) {
            ++this.pos;
            arr[i] = ch;
        }
        return Integer.parseInt(new String(arr, 0, i));
    }

    public String getId() throws SyntaxError {
        return this.getId("Expected identifier");
    }

    public String getId(String errMessage) throws SyntaxError {
        char ch;
        this.eatws();
        int id_start = this.pos;
        if (this.pos < this.end && (ch = this.val.charAt(this.pos)) != '$' && Character.isJavaIdentifierStart(ch)) {
            ++this.pos;
            while (this.pos < this.end && (Character.isJavaIdentifierPart(ch = this.val.charAt(this.pos)) || ch == '.')) {
                ++this.pos;
            }
            return this.val.substring(id_start, this.pos);
        }
        if (errMessage != null) {
            throw new SyntaxError(errMessage + " at pos " + this.pos + " str='" + this.val + "'");
        }
        return null;
    }

    public String getGlobbedId(String errMessage) throws SyntaxError {
        char ch;
        this.eatws();
        int id_start = this.pos;
        if (this.pos < this.end && (ch = this.val.charAt(this.pos)) != '$' && (Character.isJavaIdentifierStart(ch) || ch == '?' || ch == '*')) {
            ++this.pos;
            while (this.pos < this.end && (Character.isJavaIdentifierPart(ch = this.val.charAt(this.pos)) || ch == '?' || ch == '*' || ch == '.')) {
                ++this.pos;
            }
            return this.val.substring(id_start, this.pos);
        }
        if (errMessage != null) {
            throw new SyntaxError(errMessage + " at pos " + this.pos + " str='" + this.val + "'");
        }
        return null;
    }

    public String getSimpleString() {
        char ch;
        this.eatws();
        int startPos = this.pos;
        while (this.pos < this.end && !Character.isWhitespace(ch = this.val.charAt(this.pos))) {
            ++this.pos;
        }
        return this.val.substring(startPos, this.pos);
    }

    public Boolean getSortDirection() throws SyntaxError {
        int startPos = this.pos;
        String order = this.getId(null);
        Boolean top = null;
        if (null != order) {
            String orderLowerCase = order.toLowerCase(Locale.ROOT);
            if ("desc".equals(orderLowerCase) || "top".equals(orderLowerCase)) {
                top = true;
            } else if ("asc".equals(orderLowerCase) || "bottom".equals(orderLowerCase)) {
                top = false;
            }
            this.eatws();
            char c = this.ch();
            if ('\u0000' != c) {
                if (',' == c) {
                    ++this.pos;
                } else {
                    top = null;
                }
            }
        }
        if (null == top) {
            this.pos = startPos;
        }
        return top;
    }

    public String getQuotedString() throws SyntaxError {
        this.eatws();
        char delim = this.peekChar();
        if (delim != '\"' && delim != '\'') {
            return null;
        }
        int val_start = ++this.pos;
        StringBuilder sb = new StringBuilder();
        while (true) {
            if (this.pos >= this.end) {
                throw new SyntaxError("Missing end quote for string at pos " + (val_start - 1) + " str='" + this.val + "'");
            }
            char ch = this.val.charAt(this.pos);
            if (ch == '\\') {
                ++this.pos;
                if (this.pos >= this.end) break;
                ch = this.val.charAt(this.pos);
                switch (ch) {
                    case 110: {
                        ch = '\n';
                        break;
                    }
                    case 116: {
                        ch = '\t';
                        break;
                    }
                    case 114: {
                        ch = '\r';
                        break;
                    }
                    case 98: {
                        ch = '\b';
                        break;
                    }
                    case 102: {
                        ch = '\f';
                        break;
                    }
                    case 117: {
                        if (this.pos + 4 >= this.end) {
                            throw new SyntaxError("bad unicode escape \\uxxxx at pos" + (val_start - 1) + " str='" + this.val + "'");
                        }
                        ch = (char)Integer.parseInt(this.val.substring(this.pos + 1, this.pos + 5), 16);
                        this.pos += 4;
                    }
                }
            } else if (ch == delim) {
                ++this.pos;
                break;
            }
            sb.append(ch);
            ++this.pos;
        }
        return sb.toString();
    }

    public char peek() {
        this.eatws();
        return this.pos < this.end ? this.val.charAt(this.pos) : (char)'\u0000';
    }

    public char peekChar() {
        return this.pos < this.end ? this.val.charAt(this.pos) : (char)'\u0000';
    }

    public String toString() {
        return "'" + this.val + "', pos=" + this.pos;
    }
}

