/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.BlockLineReader;
import blbutil.FileIt;
import blbutil.Filter;
import blbutil.SampleFileIt;
import bref.SeqCoder3;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Stream;
import vcf.GTRec;
import vcf.Marker;
import vcf.RefGTRec;
import vcf.Samples;
import vcf.VcfHeader;
import vcf.VcfIt;
import vcf.VcfRecGTParser;

public class RefIt
implements SampleFileIt<RefGTRec> {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final VcfHeader vcfHeader;
    private final Function<String, RefGTRec> mapper;
    private final Filter<Marker> markerFilter;
    private final BlockLineReader reader;
    private final List<RefGTRec> lowFreqBuffer;
    private final Deque<RefGTRec> recBuffer;
    private final SeqCoder3 seqCoder;
    private final int maxSeqCodedAlleles;
    private final int maxSeqCodingMajorCnt;
    private int lastChrom = -1;

    public static RefIt create(FileIt<String> fileIt) {
        return RefIt.create(fileIt, Filter.acceptAllFilter(), Filter.acceptAllFilter(), 1024);
    }

    public static RefIt create(FileIt<String> fileIt, Filter<String> filter, Filter<Marker> filter2) {
        return new RefIt(fileIt, filter, filter2, 1024);
    }

    public static RefIt create(FileIt<String> fileIt, Filter<String> filter, Filter<Marker> filter2, int n) {
        return new RefIt(fileIt, filter, filter2, n);
    }

    private RefIt(FileIt<String> fileIt, Filter<String> filter, Filter<Marker> filter2, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (filter2 == null) {
            filter2 = Filter.acceptAllFilter();
        }
        String string2 = fileIt.file() == null ? "stdin" : fileIt.file().getName();
        String[] stringArray = VcfIt.head(string2, fileIt);
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length - 1);
        String string3 = stringArray[stringArray.length - 1];
        boolean[] blArray = VcfHeader.isDiploid(string3);
        this.vcfHeader = new VcfHeader(string2, stringArray2, blArray, filter);
        this.mapper = string -> RefGTRec.alleleCodedInstance(new VcfRecGTParser(this.vcfHeader, (String)string));
        this.markerFilter = filter2;
        this.seqCoder = new SeqCoder3(this.vcfHeader.samples());
        this.maxSeqCodedAlleles = Math.min(this.seqCoder.maxNSeq(), 255);
        this.maxSeqCodingMajorCnt = this.maxSeqCodingMajorCnt(this.vcfHeader.samples());
        this.lowFreqBuffer = new ArrayList<RefGTRec>();
        this.recBuffer = new ArrayDeque<RefGTRec>(n);
        int n2 = 1;
        this.reader = BlockLineReader.create(fileIt, n, n2);
        this.fillRecBuffer(string3);
    }

    private int maxSeqCodingMajorCnt(Samples samples) {
        int n = samples.size() << 1;
        return (int)Math.floor((float)n * 0.995f - 1.0f);
    }

    private void fillRecBuffer() {
        this.fillRecBuffer(null);
    }

    private void fillRecBuffer(String string) {
        assert (this.recBuffer.isEmpty());
        while (this.recBuffer.isEmpty()) {
            String[] stringArray = this.reader.next();
            if (string != null) {
                stringArray = this.combine(string, stringArray);
                string = null;
            }
            if (stringArray == BlockLineReader.SENTINAL) {
                this.flushCompressedRecords();
                return;
            }
            RefGTRec[] refGTRecArray = this.parseLines(stringArray);
            for (int i = 0; i < refGTRecArray.length; ++i) {
                RefGTRec refGTRec = refGTRecArray[i];
                int n = refGTRec.marker().chromIndex();
                if (this.lastChrom == -1) {
                    this.lastChrom = n;
                }
                if (n != this.lastChrom || this.lowFreqBuffer.size() == Integer.MAX_VALUE) {
                    this.flushCompressedRecords();
                    this.lastChrom = n;
                }
                if (!this.applySeqCoding(refGTRec)) {
                    this.lowFreqBuffer.add(refGTRec);
                    continue;
                }
                boolean bl = this.seqCoder.add(refGTRec);
                if (!bl) {
                    this.flushCompressedRecords();
                    bl = this.seqCoder.add(refGTRec);
                    assert (bl);
                }
                this.lowFreqBuffer.add(null);
            }
        }
    }

    private String[] combine(String string, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    private RefGTRec[] parseLines(String[] stringArray) {
        return (RefGTRec[])((Stream)Arrays.stream(stringArray).parallel()).map(this.mapper).filter(refGTRec -> this.markerFilter.accept(refGTRec.marker())).toArray(RefGTRec[]::new);
    }

    private void flushCompressedRecords() {
        List<RefGTRec> list = this.seqCoder.getCompressedList();
        int n = 0;
        int n2 = this.lowFreqBuffer.size();
        for (int i = 0; i < n2; ++i) {
            GTRec gTRec = this.lowFreqBuffer.get(i);
            if (gTRec != null) continue;
            this.lowFreqBuffer.set(i, list.get(n++));
        }
        this.recBuffer.addAll(this.lowFreqBuffer);
        this.lowFreqBuffer.clear();
    }

    @Override
    public void close() {
        this.reader.close();
        this.recBuffer.clear();
        this.lowFreqBuffer.clear();
    }

    @Override
    public boolean hasNext() {
        return !this.recBuffer.isEmpty();
    }

    @Override
    public RefGTRec next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        RefGTRec refGTRec = this.recBuffer.removeFirst();
        if (this.recBuffer.isEmpty()) {
            this.fillRecBuffer();
        }
        return refGTRec;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    @Override
    public File file() {
        return this.reader.file();
    }

    @Override
    public Samples samples() {
        return this.vcfHeader.samples();
    }

    @Override
    public String toString() {
        File file = this.reader.file();
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(" : ");
        stringBuilder.append(file == null ? "stdin" : file.toString());
        return stringBuilder.toString();
    }

    private boolean applySeqCoding(RefGTRec refGTRec) {
        assert (refGTRec.isAlleleCoded());
        if (refGTRec.marker().nAlleles() > this.maxSeqCodedAlleles) {
            return false;
        }
        int n = refGTRec.size();
        int n2 = refGTRec.majorAllele();
        int n3 = n;
        int n4 = refGTRec.marker().nAlleles();
        for (int i = 0; i < n4; ++i) {
            if (i == n2) continue;
            n3 -= refGTRec.alleleCount(i);
        }
        return n3 <= this.maxSeqCodingMajorCnt;
    }
}

