/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf.movie;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.igoweb.util.Emitter;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.xiph.speex.Bits;
import org.xiph.speex.NbDecoder;

public class SpeexPlayer
extends Emitter
implements EventListener {
    public static final int OPENED_EVENT = 0;
    public static final int LINE_UNAVAILABLE_EVENT = 1;
    private int framesPerPacket = -1;
    private boolean started = false;
    private float[] floatPcmData;
    private byte[] bytePcmData;
    private NbDecoder decoder;
    SourceDataLine lineOut;
    private FloatControl volumeCtrl;
    private boolean zeroVolume;
    public static final int SAMPLES_PER_SECOND = 8000;

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 16: {
                this.setFramesPerPacket((Integer)event.arg);
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                if (!this.started) {
                    this.start();
                }
                this.playAudio((byte[])event.arg);
                break;
            }
        }
    }

    public void setFramesPerPacket(int val) {
        this.framesPerPacket = val;
    }

    public void start() {
        if (this.framesPerPacket < 0) {
            throw new IllegalStateException();
        }
        this.started = true;
        this.decoder = new NbDecoder();
        this.decoder.nbinit();
        this.floatPcmData = new float[this.decoder.getFrameSize()];
        this.bytePcmData = new byte[this.floatPcmData.length * 2];
        this.openLine();
    }

    public synchronized void openLine() {
        if (this.lineOut != null) {
            return;
        }
        AudioFormat format = new AudioFormat(8000.0f, 16, 1, true, false);
        try {
            this.lineOut = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, format));
            this.lineOut.open(format);
            this.volumeCtrl = (FloatControl)this.lineOut.getControl(FloatControl.Type.MASTER_GAIN);
        }
        catch (LineUnavailableException excep) {
            this.emit(1);
            return;
        }
        this.lineOut.start();
        this.emit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playAudio(byte[] rawData) {
        BitReader bits = new BitReader(rawData);
        for (int i = 0; i < this.framesPerPacket; ++i) {
            this.decoder.decode(bits, this.floatPcmData);
            for (int j = 0; j < this.floatPcmData.length; ++j) {
                int ival = (int)this.floatPcmData[j];
                if (ival > Short.MAX_VALUE) {
                    ival = Short.MAX_VALUE;
                } else if (ival < Short.MIN_VALUE) {
                    ival = Short.MIN_VALUE;
                }
                this.bytePcmData[j * 2] = (byte)ival;
                this.bytePcmData[j * 2 + 1] = (byte)(ival >> 8);
            }
            SpeexPlayer speexPlayer = this;
            synchronized (speexPlayer) {
                if (this.lineOut != null && !this.zeroVolume) {
                    this.lineOut.write(this.bytePcmData, 0, this.bytePcmData.length);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SpeexPlayer speexPlayer = this;
        synchronized (speexPlayer) {
            this.started = false;
            if (this.lineOut != null) {
                this.lineOut.stop();
                this.lineOut = null;
            }
        }
    }

    public void setVolume(float volume) {
        if (this.volumeCtrl == null) {
            return;
        }
        if (volume == 0.0f) {
            this.zeroVolume = true;
        } else {
            this.zeroVolume = false;
            float min = this.volumeCtrl.getMinimum();
            float max = this.volumeCtrl.getMaximum();
            this.volumeCtrl.setValue(volume * (max - min) + min);
        }
    }

    public float getVolume() {
        if (this.volumeCtrl == null || this.zeroVolume) {
            return 0.0f;
        }
        float min = this.volumeCtrl.getMinimum();
        float max = this.volumeCtrl.getMaximum();
        return (this.volumeCtrl.getValue() - min) / (max - min);
    }

    public boolean isOpened() {
        return this.lineOut != null;
    }

    private static class BitReader
    extends Bits {
        public BitReader(byte[] buf) {
            this.setBuffer(buf);
        }
    }
}

