/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.defaults;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.defaults.BorderManager;
import org.flexdock.docking.defaults.DefaultDockingPort;

public class StandardBorderManager
implements BorderManager {
    private Border assignedBorder;

    public StandardBorderManager() {
    }

    public StandardBorderManager(Border border) {
        this.setBorder(border);
    }

    public Border getBorder() {
        return this.assignedBorder;
    }

    public void setBorder(Border border) {
        this.assignedBorder = border;
    }

    public void managePortNullChild(DockingPort port) {
        this.setBorder(port, this.assignedBorder);
    }

    public void managePortSimpleChild(DockingPort port) {
        if (port != null) {
            this.setBorder(port.getDockedComponent(), null);
            this.setBorder(port, this.assignedBorder);
        }
    }

    public void managePortSplitChild(DockingPort port) {
        BasicSplitPaneDivider divider;
        if (port == null || !(port.getDockedComponent() instanceof JSplitPane)) {
            return;
        }
        this.setBorder(port, null);
        JSplitPane split = (JSplitPane)port.getDockedComponent();
        if (split.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)split.getUI()).getDivider()) != null && divider.getBorder() != null) {
            divider.setBorder(null);
        }
        this.setBorder(split, null);
        this.setSubComponentBorder(split.getLeftComponent(), this.assignedBorder);
        this.setSubComponentBorder(split.getRightComponent(), this.assignedBorder);
    }

    private void setSubComponentBorder(Component comp, Border border) {
        if (comp instanceof DefaultDockingPort) {
            ((DefaultDockingPort)comp).evaluateDockingBorderStatus();
        } else {
            this.setBorder(comp, border);
        }
    }

    public void managePortTabbedChild(DockingPort port) {
        this.managePortSimpleChild(port);
        if (port == null || !(port.getDockedComponent() instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane tabs = (JTabbedPane)port.getDockedComponent();
        int tc = tabs.getTabCount();
        Component cmp = null;
        for (int i = 0; i < tc; ++i) {
            cmp = tabs.getComponentAt(i);
            if (!(cmp instanceof JComponent)) continue;
            ((JComponent)cmp).setBorder(null);
        }
    }

    private void setBorder(Component cmp, Border border) {
        if (cmp instanceof JComponent) {
            ((JComponent)cmp).setBorder(border);
        }
    }

    private void setBorder(DockingPort port, Border border) {
        if (port instanceof JComponent) {
            ((JComponent)((Object)port)).setBorder(border);
        }
    }

    private static class SimpleTabbedPaneUI
    extends BasicTabbedPaneUI {
        private SimpleTabbedPaneUI() {
        }

        protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            if (tabPlacement == 3) {
                super.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            }
        }

        protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            if (tabPlacement == 2) {
                super.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            }
        }

        protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            if (tabPlacement == 4) {
                super.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            }
        }

        protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            if (tabPlacement == 1) {
                super.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            }
        }
    }
}

