/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.dranger;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.dranger.DRangerFeature;
import org.broad.igv.renderer.FeatureRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

public class DRangerRenderer
extends FeatureRenderer {
    @Override
    public void render(List<IGVFeature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (featureList != null && featureList.size() > 0) {
            for (IGVFeature feature : featureList) {
                double pixelStart = ((double)feature.getStart() - origin) / locScale;
                double pixelEnd = ((double)feature.getEnd() - origin) / locScale;
                if (!(pixelEnd >= trackRectangle.getX()) || !(pixelStart <= trackRectangle.getMaxX())) continue;
                this.renderFeature(feature, context, trackRectangle);
            }
        }
    }

    private void renderFeature(IGVFeature feature, RenderContext context, Rectangle rect) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        DRangerFeature dr = (DRangerFeature)feature;
        int x = (int)(((double)dr.getStart() - origin) / locScale);
        int length = dr.getEnd() - dr.getStart();
        int h = (int)Math.min(12.0, rect.getHeight());
        int w = (int)Math.ceil((double)length / locScale);
        int y = (int)Math.max(rect.getY(), rect.getY() + (rect.getHeight() - (double)h) / 2.0);
        Graphics2D g = context.getGraphic2DForColor(feature.getColor());
        g.fillRect(x, y, w, h);
    }
}

