/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.text.NumberFormat;
import java.util.Locale;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.Range;

public class Locus
extends Range
implements NamedFeature {
    private static NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);

    public Locus(String chr, int start, int end) {
        super(chr, start, end);
    }

    public static Locus fromString(String locusString) {
        Locus l = new Locus(locusString);
        return l.isValid() ? l : null;
    }

    public Locus(String locusString) {
        this(null, -1, -1);
        this.parseLocusString(locusString);
    }

    public boolean isValid() {
        return this.getChr() != null && this.getStart() >= 0 && this.getEnd() >= this.getStart();
    }

    private void parseLocusString(String locusString) {
        int colonIndex = locusString.indexOf(":");
        int dashIndex = locusString.indexOf("-");
        if (colonIndex > 0) {
            this.chr = locusString.substring(0, colonIndex);
            String posString = locusString.substring(colonIndex).replace(":", "");
            this.setStartEnd(posString);
        }
    }

    private void setStartEnd(String posString) {
        String[] posTokens = posString.split("-");
        String startString = posTokens[0].replaceAll(",", "");
        this.start = Math.max(0, Integer.parseInt(startString) - 1);
        this.end = this.start + 1;
        if (posTokens.length >= 2) {
            try {
                String endString = posTokens[1].replaceAll(",", "");
                this.end = Integer.parseInt(endString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        return this.chr + ":" + this.start + "-" + this.end;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public static String getFormattedLocusString(String chr, int start, int end) {
        String startStr = NUMBER_FORMAT.format(start + 1);
        String endStr = NUMBER_FORMAT.format(end);
        String position = chr + ":" + startStr + "-" + endStr;
        return position;
    }
}

