/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.asm.ClassVisitor;
import net.sf.cglib.beans.BeanMapEmitter;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.KeyFactory;
import net.sf.cglib.core.ReflectUtils;

public abstract class BeanMap
implements Map {
    public static final int REQUIRE_GETTER = 1;
    public static final int REQUIRE_SETTER = 2;
    protected Object bean;
    static /* synthetic */ Class class$net$sf$cglib$beans$BeanMap;
    static /* synthetic */ Class class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey;

    public static BeanMap create(Object bean) {
        Generator gen = new Generator();
        gen.setBean(bean);
        return gen.create();
    }

    public abstract BeanMap newInstance(Object var1);

    public abstract Class getPropertyType(String var1);

    protected BeanMap() {
    }

    protected BeanMap(Object bean) {
        this.setBean(bean);
    }

    public Object get(Object key) {
        return this.get(this.bean, key);
    }

    public Object put(Object key, Object value2) {
        return this.put(this.bean, key, value2);
    }

    public abstract Object get(Object var1, Object var2);

    public abstract Object put(Object var1, Object var2, Object var3);

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    public boolean containsValue(Object value2) {
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object v = this.get(it.next());
            if ((value2 != null || v != null) && !value2.equals(v)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.keySet().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t2) {
        Iterator it = t2.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t2.get(key));
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        if (this.size() != other.size()) {
            return false;
        }
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (!other.containsKey(key)) {
                return false;
            }
            Object v1 = this.get(key);
            Object v2 = other.get(key);
            if (v1 != null ? v1.equals(v2) : v2 == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = 0;
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value2 = this.get(key);
            code += (key == null ? 0 : key.hashCode()) ^ (value2 == null ? 0 : value2.hashCode());
        }
        return code;
    }

    public Set entrySet() {
        HashMap copy = new HashMap();
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            copy.put(key, this.get(key));
        }
        return Collections.unmodifiableMap(copy).entrySet();
    }

    public Collection values() {
        Set keys2 = this.keySet();
        ArrayList<Object> values2 = new ArrayList<Object>(keys2.size());
        Iterator it = keys2.iterator();
        while (it.hasNext()) {
            values2.add(this.get(it.next()));
        }
        return Collections.unmodifiableCollection(values2);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            sb.append(key);
            sb.append('=');
            sb.append(this.get(key));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$net$sf$cglib$beans$BeanMap == null ? (class$net$sf$cglib$beans$BeanMap = BeanMap.class$("net.sf.cglib.beans.BeanMap")) : class$net$sf$cglib$beans$BeanMap).getName());
        private static final BeanMapKey KEY_FACTORY = (BeanMapKey)((Object)KeyFactory.create(class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey == null ? (class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey = BeanMap.class$("net.sf.cglib.beans.BeanMap$Generator$BeanMapKey")) : class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey, KeyFactory.CLASS_BY_NAME));
        private Object bean;
        private Class beanClass;
        private int require;

        public Generator() {
            super(SOURCE);
        }

        public void setBean(Object bean) {
            this.bean = bean;
            if (bean != null) {
                this.beanClass = bean.getClass();
            }
        }

        public void setBeanClass(Class beanClass) {
            this.beanClass = beanClass;
        }

        public void setRequire(int require) {
            this.require = require;
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.beanClass.getClassLoader();
        }

        public BeanMap create() {
            if (this.beanClass == null) {
                throw new IllegalArgumentException("Class of bean unknown");
            }
            this.setNamePrefix(this.beanClass.getName());
            return (BeanMap)super.create(KEY_FACTORY.newInstance(this.beanClass, this.require));
        }

        public void generateClass(ClassVisitor v) throws Exception {
            new BeanMapEmitter(v, this.getClassName(), this.beanClass, this.require);
        }

        protected Object firstInstance(Class type) {
            return ((BeanMap)ReflectUtils.newInstance(type)).newInstance(this.bean);
        }

        protected Object nextInstance(Object instance) {
            return ((BeanMap)instance).newInstance(this.bean);
        }

        static interface BeanMapKey {
            public Object newInstance(Class var1, int var2);
        }
    }
}

