/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.Tls13Verifier;

final class JcaTls13Verifier
implements Tls13Verifier {
    private final Signature verifier;
    private final OutputStream output;

    JcaTls13Verifier(Signature signature) {
        this.verifier = signature;
        this.output = OutputStreamFactory.createStream(signature);
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        return this.output;
    }

    @Override
    public final boolean verifySignature(byte[] byArray) throws IOException {
        try {
            return this.verifier.verify(byArray);
        }
        catch (SignatureException signatureException) {
            throw new TlsFatalAlert(80, (Throwable)signatureException);
        }
    }
}

