#    Jools -- a graphical puzzle game in the Tetris tradition
#    
#    Copyright (C) 2002-2003 Paul Pelzl
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# sound.py
#
# class wrapper for pygame sounds.
#


import pygame


class Sound:

   # initialize with a list of files that could be played,
   # and the default choice of fileNum.  'audio' is the audio status
   # variable; baseVolumes is a sequence
   # of BASE_VOLUME values that corresponds to the filenames.
   def __init__(self, audio, filenames, baseVolumes, fileNum):
      self.filenames   = filenames
      self.baseVolumes = baseVolumes
      self.fileNum     = fileNum
      self.audio       = audio
      self.load()


   def load(self):
      if self.audio.Capable:
         self.pySound = pygame.mixer.Sound(self.filenames[self.fileNum])
         self.pySound.set_volume(self.baseVolumes[self.fileNum])


   def switchSet(self, fileNum):
      self.fileNum = fileNum
      self.load()


   def setVolume(self, multiplier):
      if self.audio.Capable:
         self.pySound.set_volume(self.baseVolumes[self.fileNum] * multiplier)


   def play(self):
      if self.audio.Capable and self.audio.soundEnabled:
         self.pySound.play()



# arch-tag: sound class
