/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class WrappingStoreProvider
implements StateStoreProvider {
    private final List<StateStoreProvider> storeProviders;

    public WrappingStoreProvider(List<StateStoreProvider> storeProviders) {
        this.storeProviders = storeProviders;
    }

    @Override
    public <T> List<T> stores(String storeName, QueryableStoreType<T> type) {
        ArrayList<T> allStores = new ArrayList<T>();
        for (StateStoreProvider provider : this.storeProviders) {
            List<T> stores = provider.stores(storeName, type);
            allStores.addAll(stores);
        }
        if (allStores.isEmpty()) {
            throw new InvalidStateStoreException("The state store, " + storeName + ", may have migrated to another instance.");
        }
        return allStores;
    }
}

